// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a service-linked configuration recorder that is linked to a specific
// Amazon Web Services service based on the ServicePrincipal you specify.
//
// The configuration recorder's name , recordingGroup , recordingMode , and
// recordingScope is set by the service that is linked to the configuration
// recorder.
//
// For more information and a list of supported services/service principals, see [Working with the Configuration Recorder]
// in the Config Developer Guide.
//
// This API creates a service-linked role AWSServiceRoleForConfig in your account.
// The service-linked role is created only when the role does not exist in your
// account.
//
// # The recording scope determines if you receive configuration items
//
// The recording scope is set by the service that is linked to the configuration
// recorder and determines whether you receive configuration items (CIs) in the
// delivery channel. If the recording scope is internal, you will not receive CIs
// in the delivery channel.
//
// # Tags are added at creation and cannot be updated with this operation
//
// Use [TagResource] and [UntagResource] to update tags after creation.
//
// [Working with the Configuration Recorder]: https://docs.aws.amazon.com/config/latest/developerguide/stop-start-recorder.html
// [TagResource]: https://docs.aws.amazon.com/config/latest/APIReference/API_TagResource.html
// [UntagResource]: https://docs.aws.amazon.com/config/latest/APIReference/API_UntagResource.html
func (c *Client) PutServiceLinkedConfigurationRecorder(ctx context.Context, params *PutServiceLinkedConfigurationRecorderInput, optFns ...func(*Options)) (*PutServiceLinkedConfigurationRecorderOutput, error) {
	if params == nil {
		params = &PutServiceLinkedConfigurationRecorderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutServiceLinkedConfigurationRecorder", params, optFns, c.addOperationPutServiceLinkedConfigurationRecorderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutServiceLinkedConfigurationRecorderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutServiceLinkedConfigurationRecorderInput struct {

	// The service principal of the Amazon Web Services service for the service-linked
	// configuration recorder that you want to create.
	//
	// This member is required.
	ServicePrincipal *string

	// The tags for a service-linked configuration recorder. Each tag consists of a
	// key and an optional value, both of which you define.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type PutServiceLinkedConfigurationRecorderOutput struct {

	// The Amazon Resource Name (ARN) of the specified configuration recorder.
	Arn *string

	// The name of the specified configuration recorder.
	//
	// For service-linked configuration recorders, Config automatically assigns a name
	// that has the prefix " AWSConfigurationRecorderFor " to the new service-linked
	// configuration recorder.
	Name *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutServiceLinkedConfigurationRecorderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutServiceLinkedConfigurationRecorder{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutServiceLinkedConfigurationRecorder{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutServiceLinkedConfigurationRecorder"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutServiceLinkedConfigurationRecorderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutServiceLinkedConfigurationRecorder(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutServiceLinkedConfigurationRecorder(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutServiceLinkedConfigurationRecorder",
	}
}
