// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Adds an attribute to an existing data table. Creating a new primary attribute
// uses the empty value for the specified value type for all existing records. This
// should not affect uniqueness of published data tables since the existing primary
// values will already be unique. Creating attributes does not create any values.
// System managed tables may not allow customers to create new attributes.
func (c *Client) CreateDataTableAttribute(ctx context.Context, params *CreateDataTableAttributeInput, optFns ...func(*Options)) (*CreateDataTableAttributeOutput, error) {
	if params == nil {
		params = &CreateDataTableAttributeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDataTableAttribute", params, optFns, c.addOperationCreateDataTableAttributeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDataTableAttributeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDataTableAttributeInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias. If the version is provided as part of the identifier
	// or ARN, the version must be one of the two available system managed aliases,
	// $SAVED or $LATEST.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The name for the attribute. Must conform to Connect human readable string
	// specification and have 1-127 characters. Must not start with the reserved case
	// insensitive values 'connect:' and 'aws:'. Whitespace trimmed before persisting.
	// Must be unique for the data table using case-insensitive comparison.
	//
	// This member is required.
	Name *string

	// The type of value allowed or the resultant type after the value's expression is
	// evaluated. Must be one of TEXT, TEXT_LIST, NUMBER, NUMBER_LIST, and BOOLEAN.
	//
	// This member is required.
	ValueType types.DataTableAttributeValueType

	// An optional description for the attribute. Must conform to Connect human
	// readable string specification and have 0-250 characters. Whitespace trimmed
	// before persisting.
	Description *string

	// Optional boolean that defaults to false. Determines if the value is used to
	// identify a record in the table. Values for primary attributes must not be
	// expressions.
	Primary bool

	// Optional validation rules for the attribute. Borrows heavily from JSON Schema -
	// Draft 2020-12. The maximum length of arrays within validations and depth of
	// validations is 5. There are default limits that apply to all types. Customer
	// specified limits in excess of the default limits are not permitted.
	Validation *types.Validation

	noSmithyDocumentSerde
}

type CreateDataTableAttributeOutput struct {

	// The lock version information for the data table and attribute, used for
	// optimistic locking and versioning.
	//
	// This member is required.
	LockVersion *types.DataTableLockVersion

	// The name of the created attribute since it also serves as the identifier. This
	// could be different than the parameter passed in since it will be trimmed for
	// whitespace.
	//
	// This member is required.
	Name *string

	// The unique identifier assigned to the created attribute.
	AttributeId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDataTableAttributeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDataTableAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDataTableAttribute{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDataTableAttribute"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDataTableAttributeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDataTableAttribute(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDataTableAttribute(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDataTableAttribute",
	}
}
