// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Evaluates values at the time of the request and returns them. It considers the
// request's timezone or the table's timezone, in that order, when accessing time
// based tables. When a value is accessed, the accessor's identity and the time of
// access are saved alongside the value to help identify values that are actively
// in use. The term "Batch" is not included in the operation name since it does not
// meet all the criteria for a batch operation as specified in Batch Operations:
// AWS API Standards.
func (c *Client) EvaluateDataTableValues(ctx context.Context, params *EvaluateDataTableValuesInput, optFns ...func(*Options)) (*EvaluateDataTableValuesOutput, error) {
	if params == nil {
		params = &EvaluateDataTableValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EvaluateDataTableValues", params, optFns, c.addOperationEvaluateDataTableValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EvaluateDataTableValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EvaluateDataTableValuesInput struct {

	// The unique identifier for the data table. Must also accept the table ARN with
	// or without a version alias.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// A list of value evaluation sets specifying which primary values and attributes
	// to evaluate.
	//
	// This member is required.
	Values []types.DataTableValueEvaluationSet

	// The maximum number of data table values to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Optional IANA timezone identifier to use when resolving time based dynamic
	// values. Defaults to the data table time zone if not provided.
	TimeZone *string

	noSmithyDocumentSerde
}

type EvaluateDataTableValuesOutput struct {

	// A list of evaluated values with their computed results, error information, and
	// metadata.
	//
	// This member is required.
	Values []types.DataTableEvaluatedValue

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEvaluateDataTableValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpEvaluateDataTableValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpEvaluateDataTableValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EvaluateDataTableValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEvaluateDataTableValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEvaluateDataTableValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// EvaluateDataTableValuesPaginatorOptions is the paginator options for
// EvaluateDataTableValues
type EvaluateDataTableValuesPaginatorOptions struct {
	// The maximum number of data table values to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// EvaluateDataTableValuesPaginator is a paginator for EvaluateDataTableValues
type EvaluateDataTableValuesPaginator struct {
	options   EvaluateDataTableValuesPaginatorOptions
	client    EvaluateDataTableValuesAPIClient
	params    *EvaluateDataTableValuesInput
	nextToken *string
	firstPage bool
}

// NewEvaluateDataTableValuesPaginator returns a new
// EvaluateDataTableValuesPaginator
func NewEvaluateDataTableValuesPaginator(client EvaluateDataTableValuesAPIClient, params *EvaluateDataTableValuesInput, optFns ...func(*EvaluateDataTableValuesPaginatorOptions)) *EvaluateDataTableValuesPaginator {
	if params == nil {
		params = &EvaluateDataTableValuesInput{}
	}

	options := EvaluateDataTableValuesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &EvaluateDataTableValuesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *EvaluateDataTableValuesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next EvaluateDataTableValues page.
func (p *EvaluateDataTableValuesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*EvaluateDataTableValuesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.EvaluateDataTableValues(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// EvaluateDataTableValuesAPIClient is a client that implements the
// EvaluateDataTableValues operation.
type EvaluateDataTableValuesAPIClient interface {
	EvaluateDataTableValues(context.Context, *EvaluateDataTableValuesInput, ...func(*Options)) (*EvaluateDataTableValuesOutput, error)
}

var _ EvaluateDataTableValuesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opEvaluateDataTableValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EvaluateDataTableValues",
	}
}
