// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists predefined attributes for the specified Amazon Connect instance. A
// predefined attribute is made up of a name and a value. You can use predefined
// attributes for:
//
//   - Routing proficiency (for example, agent certification) that has predefined
//     values (for example, a list of possible certifications). For more information,
//     see [Create predefined attributes for routing contacts to agents].
//
//   - Contact information that varies between transfers or conferences, such as
//     the name of the business unit handling the contact. For more information, see [Use contact segment attributes]
//     .
//
// For the predefined attributes per instance quota, see [Amazon Connect quotas].
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// [Use contact segment attributes]: https://docs.aws.amazon.com/connect/latest/adminguide/use-contact-segment-attributes.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
// [Amazon Connect quotas]: https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#connect-quotas
// [Create predefined attributes for routing contacts to agents]: https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html
func (c *Client) ListPredefinedAttributes(ctx context.Context, params *ListPredefinedAttributesInput, optFns ...func(*Options)) (*ListPredefinedAttributesOutput, error) {
	if params == nil {
		params = &ListPredefinedAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPredefinedAttributes", params, optFns, c.addOperationListPredefinedAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPredefinedAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPredefinedAttributesInput struct {

	// The identifier of the Amazon Connect instance. You can find the instance ID in
	// the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPredefinedAttributesOutput struct {

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Summary of the predefined attributes.
	PredefinedAttributeSummaryList []types.PredefinedAttributeSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPredefinedAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPredefinedAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPredefinedAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPredefinedAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPredefinedAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPredefinedAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPredefinedAttributesPaginatorOptions is the paginator options for
// ListPredefinedAttributes
type ListPredefinedAttributesPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPredefinedAttributesPaginator is a paginator for ListPredefinedAttributes
type ListPredefinedAttributesPaginator struct {
	options   ListPredefinedAttributesPaginatorOptions
	client    ListPredefinedAttributesAPIClient
	params    *ListPredefinedAttributesInput
	nextToken *string
	firstPage bool
}

// NewListPredefinedAttributesPaginator returns a new
// ListPredefinedAttributesPaginator
func NewListPredefinedAttributesPaginator(client ListPredefinedAttributesAPIClient, params *ListPredefinedAttributesInput, optFns ...func(*ListPredefinedAttributesPaginatorOptions)) *ListPredefinedAttributesPaginator {
	if params == nil {
		params = &ListPredefinedAttributesInput{}
	}

	options := ListPredefinedAttributesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPredefinedAttributesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPredefinedAttributesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPredefinedAttributes page.
func (p *ListPredefinedAttributesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPredefinedAttributesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPredefinedAttributes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPredefinedAttributesAPIClient is a client that implements the
// ListPredefinedAttributes operation.
type ListPredefinedAttributesAPIClient interface {
	ListPredefinedAttributes(context.Context, *ListPredefinedAttributesInput, ...func(*Options)) (*ListPredefinedAttributesOutput, error)
}

var _ ListPredefinedAttributesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPredefinedAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPredefinedAttributes",
	}
}
