// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists the manual assignment queues associated with a routing profile.
//
// # Use cases
//
// Following are common uses cases for this API:
//
//   - This API returns list of queues where contacts can be manually assigned or
//     picked by an agent who has access to the Worklist app. The user can additionally
//     filter on queues, if they have access to those queues (otherwise a invalid
//     request exception will be thrown).
//
// For information about how manual contact assignment works in the agent
//
//	workspace, see the [Access the Worklist app in the Amazon Connect agent workspace]in the Amazon Connect Administrator Guide.
//
// Important things to know
//
//   - This API only returns the manual assignment queues associated with a
//     routing profile. Use the ListRoutingProfileQueues API to list the auto
//     assignment queues for the routing profile.
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
//
// [Access the Worklist app in the Amazon Connect agent workspace]: https://docs.aws.amazon.com/connect/latest/adminguide/worklist-app.html
func (c *Client) ListRoutingProfileManualAssignmentQueues(ctx context.Context, params *ListRoutingProfileManualAssignmentQueuesInput, optFns ...func(*Options)) (*ListRoutingProfileManualAssignmentQueuesOutput, error) {
	if params == nil {
		params = &ListRoutingProfileManualAssignmentQueuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRoutingProfileManualAssignmentQueues", params, optFns, c.addOperationListRoutingProfileManualAssignmentQueuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRoutingProfileManualAssignmentQueuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRoutingProfileManualAssignmentQueuesInput struct {

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// The identifier of the routing profile.
	//
	// This member is required.
	RoutingProfileId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRoutingProfileManualAssignmentQueuesOutput struct {

	// The Amazon Web Services Region where this resource was last modified.
	LastModifiedRegion *string

	// The timestamp when this resource was last modified.
	LastModifiedTime *time.Time

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// Information about the manual assignment queues associated with the routing
	// profile.
	RoutingProfileManualAssignmentQueueConfigSummaryList []types.RoutingProfileManualAssignmentQueueConfigSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRoutingProfileManualAssignmentQueuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRoutingProfileManualAssignmentQueues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRoutingProfileManualAssignmentQueues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRoutingProfileManualAssignmentQueues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRoutingProfileManualAssignmentQueuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRoutingProfileManualAssignmentQueues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRoutingProfileManualAssignmentQueuesPaginatorOptions is the paginator
// options for ListRoutingProfileManualAssignmentQueues
type ListRoutingProfileManualAssignmentQueuesPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRoutingProfileManualAssignmentQueuesPaginator is a paginator for
// ListRoutingProfileManualAssignmentQueues
type ListRoutingProfileManualAssignmentQueuesPaginator struct {
	options   ListRoutingProfileManualAssignmentQueuesPaginatorOptions
	client    ListRoutingProfileManualAssignmentQueuesAPIClient
	params    *ListRoutingProfileManualAssignmentQueuesInput
	nextToken *string
	firstPage bool
}

// NewListRoutingProfileManualAssignmentQueuesPaginator returns a new
// ListRoutingProfileManualAssignmentQueuesPaginator
func NewListRoutingProfileManualAssignmentQueuesPaginator(client ListRoutingProfileManualAssignmentQueuesAPIClient, params *ListRoutingProfileManualAssignmentQueuesInput, optFns ...func(*ListRoutingProfileManualAssignmentQueuesPaginatorOptions)) *ListRoutingProfileManualAssignmentQueuesPaginator {
	if params == nil {
		params = &ListRoutingProfileManualAssignmentQueuesInput{}
	}

	options := ListRoutingProfileManualAssignmentQueuesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRoutingProfileManualAssignmentQueuesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRoutingProfileManualAssignmentQueuesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRoutingProfileManualAssignmentQueues page.
func (p *ListRoutingProfileManualAssignmentQueuesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRoutingProfileManualAssignmentQueuesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRoutingProfileManualAssignmentQueues(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRoutingProfileManualAssignmentQueuesAPIClient is a client that implements
// the ListRoutingProfileManualAssignmentQueues operation.
type ListRoutingProfileManualAssignmentQueuesAPIClient interface {
	ListRoutingProfileManualAssignmentQueues(context.Context, *ListRoutingProfileManualAssignmentQueuesInput, ...func(*Options)) (*ListRoutingProfileManualAssignmentQueuesOutput, error)
}

var _ ListRoutingProfileManualAssignmentQueuesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRoutingProfileManualAssignmentQueues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRoutingProfileManualAssignmentQueues",
	}
}
