// Code generated by smithy-go-codegen DO NOT EDIT.

package connectcases

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connectcases/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a related item (comments, tasks, and contacts) and associates it with a
// case.
//
// There's a quota for the number of fields allowed in a Custom type related item.
// See [Amazon Connect Cases quotas].
//
// # Use cases
//
// Following are examples of related items that you may want to associate with a
// case:
//
//   - Related contacts, such as calls, chats, emails tasks
//
//   - Comments, for agent notes
//
//   - SLAs, to capture target resolution goals
//
//   - Cases, to capture related Amazon Connect Cases
//
//   - Files, such as policy documentation or customer-provided attachments
//
//   - Custom related items, which provide flexibility for you to define related
//     items that such as bookings, orders, products, notices, and more
//
// Important things to know
//
//   - If you are associating a contact to a case by passing in Contact for a type
//     , you must have [DescribeContact]permission on the ARN of the contact that you provide in
//     content.contact.contactArn .
//
//   - A Related Item is a resource that is associated with a case. It may or may
//     not have an external identifier linking it to an external resource (for example,
//     a contactArn ). All Related Items have their own internal identifier, the
//     relatedItemArn . Examples of related items include comments and contacts .
//
//   - If you provide a value for performedBy.userArn you must also have [DescribeUser]
//     permission on the ARN of the user that you provide.
//
//   - The type field is reserved for internal use only.
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// [DescribeUser]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeUser.html
// [Amazon Connect Cases quotas]: https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#cases-quotas
// [DescribeContact]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeContact.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
func (c *Client) CreateRelatedItem(ctx context.Context, params *CreateRelatedItemInput, optFns ...func(*Options)) (*CreateRelatedItemOutput, error) {
	if params == nil {
		params = &CreateRelatedItemInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateRelatedItem", params, optFns, c.addOperationCreateRelatedItemMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateRelatedItemOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateRelatedItemInput struct {

	// A unique identifier of the case.
	//
	// This member is required.
	CaseId *string

	// The content of a related item to be created.
	//
	// This member is required.
	Content types.RelatedItemInputContent

	// The unique identifier of the Cases domain.
	//
	// This member is required.
	DomainId *string

	// The type of a related item.
	//
	// This member is required.
	Type types.RelatedItemType

	// Represents the creator of the related item.
	PerformedBy types.UserUnion

	noSmithyDocumentSerde
}

type CreateRelatedItemOutput struct {

	// The Amazon Resource Name (ARN) of the related item.
	//
	// This member is required.
	RelatedItemArn *string

	// The unique identifier of the related item.
	//
	// This member is required.
	RelatedItemId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateRelatedItemMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateRelatedItem{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateRelatedItem{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateRelatedItem"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateRelatedItemValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateRelatedItem(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateRelatedItem(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateRelatedItem",
	}
}
