// Code generated by smithy-go-codegen DO NOT EDIT.

package costexplorer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/costexplorer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Specifies the parameters of a planned commitment purchase and starts the
// generation of the analysis. This enables you to estimate the cost, coverage, and
// utilization impact of your planned commitment purchases.
func (c *Client) StartCommitmentPurchaseAnalysis(ctx context.Context, params *StartCommitmentPurchaseAnalysisInput, optFns ...func(*Options)) (*StartCommitmentPurchaseAnalysisOutput, error) {
	if params == nil {
		params = &StartCommitmentPurchaseAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCommitmentPurchaseAnalysis", params, optFns, c.addOperationStartCommitmentPurchaseAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCommitmentPurchaseAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCommitmentPurchaseAnalysisInput struct {

	// The configuration for the commitment purchase analysis.
	//
	// This member is required.
	CommitmentPurchaseAnalysisConfiguration *types.CommitmentPurchaseAnalysisConfiguration

	noSmithyDocumentSerde
}

type StartCommitmentPurchaseAnalysisOutput struct {

	// The analysis ID that's associated with the commitment purchase analysis.
	//
	// This member is required.
	AnalysisId *string

	// The start time of the analysis.
	//
	// This member is required.
	AnalysisStartedTime *string

	// The estimated time for when the analysis will complete.
	//
	// This member is required.
	EstimatedCompletionTime *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCommitmentPurchaseAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartCommitmentPurchaseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartCommitmentPurchaseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCommitmentPurchaseAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartCommitmentPurchaseAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCommitmentPurchaseAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCommitmentPurchaseAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCommitmentPurchaseAnalysis",
	}
}
