// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes the enrollment status of an organization's member accounts in Cost
// Optimization Hub.
type AccountEnrollmentStatus struct {

	// The Amazon Web Services account ID.
	AccountId *string

	// The time when the account enrollment status was created.
	CreatedTimestamp *time.Time

	// The time when the account enrollment status was last updated.
	LastUpdatedTimestamp *time.Time

	// The account enrollment status.
	Status EnrollmentStatus

	noSmithyDocumentSerde
}

// Contains the details of an Aurora DB cluster storage.
type AuroraDbClusterStorage struct {

	// The Aurora DB cluster storage configuration used for recommendations.
	Configuration *AuroraDbClusterStorageConfiguration

	// Cost impact of the resource recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Aurora DB cluster storage configuration used for recommendations.
type AuroraDbClusterStorageConfiguration struct {

	// The storage type to associate with the Aurora DB cluster.
	StorageType *string

	noSmithyDocumentSerde
}

// Describes the Amazon Elastic Block Store performance configuration of the
// current and recommended resource configuration for a recommendation.
type BlockStoragePerformanceConfiguration struct {

	// The number of I/O operations per second.
	Iops *float64

	// The throughput that the volume supports.
	Throughput *float64

	noSmithyDocumentSerde
}

// Describes the performance configuration for compute services such as Amazon
// EC2, Lambda, and ECS.
type ComputeConfiguration struct {

	// The architecture of the resource.
	Architecture *string

	// The memory size of the resource.
	MemorySizeInMB *int32

	// The platform of the resource. The platform is the specific combination of
	// operating system, license model, and software on an instance.
	Platform *string

	// The number of vCPU cores in the resource.
	VCpu *float64

	noSmithyDocumentSerde
}

// The Compute Savings Plans recommendation details.
type ComputeSavingsPlans struct {

	// Configuration details of the Compute Savings Plans to purchase.
	Configuration *ComputeSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The Compute Savings Plans configuration used for recommendations.
type ComputeSavingsPlansConfiguration struct {

	// The account scope for which you want recommendations. Amazon Web Services
	// calculates recommendations including the management account and member accounts
	// if the value is set to PAYER . If the value is LINKED , recommendations are
	// calculated for individual member accounts only.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// The DB instance configuration used for recommendations.
type DbInstanceConfiguration struct {

	// The DB instance class of the DB instance.
	DbInstanceClass *string

	noSmithyDocumentSerde
}

// The DynamoDB reserved capacity recommendation details.
type DynamoDbReservedCapacity struct {

	// The DynamoDB reserved capacity configuration used for recommendations.
	Configuration *DynamoDbReservedCapacityConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The DynamoDB reserved capacity configuration used for recommendations.
type DynamoDbReservedCapacityConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// The capacity unit of the recommended reservation.
	CapacityUnits *string

	// How much purchasing this reserved capacity costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of reserved capacity units that Amazon Web Services recommends that
	// you purchase.
	NumberOfCapacityUnitsToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// The reserved capacity recommendation term in years.
	Term *string

	// How much purchasing this reserved capacity costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Describes the Amazon Elastic Block Store volume configuration of the current
// and recommended resource configuration for a recommendation.
type EbsVolume struct {

	// The Amazon Elastic Block Store volume configuration used for recommendations.
	Configuration *EbsVolumeConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Amazon Elastic Block Store volume configuration used for recommendations.
type EbsVolumeConfiguration struct {

	// The Amazon Elastic Block Store attachment state.
	AttachmentState *string

	// The Amazon Elastic Block Store performance configuration.
	Performance *BlockStoragePerformanceConfiguration

	// The disk storage of the Amazon Elastic Block Store volume.
	Storage *StorageConfiguration

	noSmithyDocumentSerde
}

// The EC2 Auto Scaling group recommendation details.
type Ec2AutoScalingGroup struct {

	// The EC2 Auto Scaling group configuration used for recommendations.
	Configuration *Ec2AutoScalingGroupConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The EC2 Auto Scaling group configuration used for recommendations.
type Ec2AutoScalingGroupConfiguration struct {

	// The strategy used for allocating instances, based on a predefined priority
	// order or based on the lowest available price.
	AllocationStrategy AllocationStrategy

	// Details about the instance for the EC2 Auto Scaling group with a single
	// instance type.
	Instance *InstanceConfiguration

	// A list of instance types for an EC2 Auto Scaling group with mixed instance
	// types.
	MixedInstances []MixedInstanceConfiguration

	// The type of EC2 Auto Scaling group, showing whether it consists of a single
	// instance type or mixed instance types.
	Type Ec2AutoScalingGroupType

	noSmithyDocumentSerde
}

// Describes the EC2 instance configuration of the current and recommended
// resource configuration for a recommendation.
type Ec2Instance struct {

	// The EC2 instance configuration used for recommendations.
	Configuration *Ec2InstanceConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The EC2 instance configuration used for recommendations.
type Ec2InstanceConfiguration struct {

	// Details about the instance.
	Instance *InstanceConfiguration

	noSmithyDocumentSerde
}

// The EC2 instance Savings Plans recommendation details.
type Ec2InstanceSavingsPlans struct {

	// The EC2 instance Savings Plans configuration used for recommendations.
	Configuration *Ec2InstanceSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The EC2 instance Savings Plans configuration used for recommendations.
type Ec2InstanceSavingsPlansConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The instance family of the recommended Savings Plans.
	InstanceFamily *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	SavingsPlansRegion *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// The EC2 reserved instances recommendation details.
type Ec2ReservedInstances struct {

	// The EC2 reserved instances configuration used for recommendations.
	Configuration *Ec2ReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The EC2 reserved instances configuration used for recommendations.
type Ec2ReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing these reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// Indicates whether the recommendation is for standard or convertible
	// reservations.
	OfferingClass *string

	// The payment option for the commitment.
	PaymentOption *string

	// The platform of the recommended reservation. The platform is the specific
	// combination of operating system, license model, and software on an instance.
	Platform *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// Determines whether the recommended reservation is dedicated or shared.
	Tenancy *string

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// The ECS service recommendation details.
type EcsService struct {

	// The ECS service configuration used for recommendations.
	Configuration *EcsServiceConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The ECS service configuration used for recommendations.
type EcsServiceConfiguration struct {

	// Details about the compute configuration.
	Compute *ComputeConfiguration

	noSmithyDocumentSerde
}

// Contains cost efficiency metrics for a specific group over time. The group is
// defined by the grouping dimension specified in the request, such as account ID,
// Amazon Web Services Region.
type EfficiencyMetricsByGroup struct {

	// The value of the grouping dimension for this set of metrics. For example, if
	// grouped by account ID, this field contains the account ID. If no grouping is
	// specified, this field is empty.
	Group *string

	// An explanation of why efficiency metrics could not be calculated for this group
	// when the metricsByTime field is null. Common reasons include insufficient or
	// inconclusive cost and usage data during the specified time period. This field is
	// null or empty when metrics are successfully calculated.
	Message *string

	// A list of time-series data points containing efficiency metrics for this group.
	// Each data point includes an efficiency score, estimated savings, spending, and a
	// timestamp corresponding to the specified granularity. This field is null when
	// efficiency metrics cannot be calculated for the group, in which case the message
	// field provides an explanation.
	MetricsByTime []MetricsByTime

	noSmithyDocumentSerde
}

// The ElastiCache reserved instances recommendation details.
type ElastiCacheReservedInstances struct {

	// The ElastiCache reserved instances configuration used for recommendations.
	Configuration *ElastiCacheReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The ElastiCache reserved instances configuration used for recommendations.
type ElastiCacheReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing these reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Estimated discount details of the current and recommended resource
// configuration for a recommendation.
type EstimatedDiscounts struct {

	// Estimated other discounts include all discounts that are not itemized. Itemized
	// discounts include reservedInstanceDiscount and savingsPlansDiscount .
	OtherDiscount *float64

	// Estimated reserved instance discounts.
	ReservedInstancesDiscount *float64

	// Estimated Savings Plans discounts.
	SavingsPlansDiscount *float64

	noSmithyDocumentSerde
}

// Describes a filter that returns a more specific list of recommendations.
// Filters recommendations by different dimensions.
type Filter struct {

	// The account to which the recommendation applies.
	AccountIds []string

	// The type of action you can take by adopting the recommendation.
	ActionTypes []ActionType

	// The effort required to implement the recommendation.
	ImplementationEfforts []ImplementationEffort

	// The IDs for the recommendations.
	RecommendationIds []string

	// The Amazon Web Services Region of the resource.
	Regions []string

	// The Amazon Resource Name (ARN) of the recommendation.
	ResourceArns []string

	// The resource ID of the recommendation.
	ResourceIds []string

	// The resource type of the recommendation.
	ResourceTypes []ResourceType

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool

	// A list of tags assigned to the recommendation.
	Tags []Tag

	noSmithyDocumentSerde
}

// The instance configuration used for recommendations.
type InstanceConfiguration struct {

	// The instance type of the configuration.
	Type *string

	noSmithyDocumentSerde
}

// The Lambda function recommendation details.
type LambdaFunction struct {

	// The Lambda function configuration used for recommendations.
	Configuration *LambdaFunctionConfiguration

	// Cost impact of the recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Lambda function configuration used for recommendations.
type LambdaFunctionConfiguration struct {

	// Details about the compute configuration.
	Compute *ComputeConfiguration

	noSmithyDocumentSerde
}

// The MemoryDB reserved instances recommendation details.
//
// While the API reference uses "MemoryDB reserved instances", the user guide and
// other documentation refer to them as "MemoryDB reserved nodes", as the terms are
// used interchangeably.
type MemoryDbReservedInstances struct {

	// The MemoryDB reserved instances configuration used for recommendations.
	Configuration *MemoryDbReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The MemoryDB reserved instances configuration used for recommendations.
//
// While the API reference uses "MemoryDB reserved instances", the user guide and
// other documentation refer to them as "MemoryDB reserved nodes", as the terms are
// used interchangeably.
type MemoryDbReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing these reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing these reserved instances costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Contains efficiency metrics for a specific point in time, including an
// efficiency score, potential savings, optimizable spend, and timestamp.
type MetricsByTime struct {

	// The estimated savings amount for this time period, representing the potential
	// cost reduction achieved through optimization recommendations.
	Savings *float64

	// The efficiency score for this time period. The score represents a measure of
	// how effectively the cloud resources are being optimized, with higher scores
	// indicating better optimization performance.
	Score *float64

	// The total spending amount for this time period.
	Spend *float64

	// The timestamp for this data point. The format depends on the granularity:
	// YYYY-MM-DD for daily metrics, or YYYY-MM for monthly metrics.
	Timestamp *string

	noSmithyDocumentSerde
}

// The configuration for the EC2 Auto Scaling group with mixed instance types.
type MixedInstanceConfiguration struct {

	// The instance type of the configuration.
	Type *string

	noSmithyDocumentSerde
}

// The NAT Gateway recommendation details.
type NatGateway struct {

	// The NAT Gateway configuration used for recommendations.
	Configuration *NatGatewayConfiguration

	// Cost impact of the resource recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The NAT Gateway configuration used for recommendations.
type NatGatewayConfiguration struct {

	// The number of active connections through the NAT Gateway.
	ActiveConnectionCount *int64

	// The number of packets received from the destination through the NAT Gateway.
	PacketsInFromDestination *int64

	// The number of packets received from the source through the NAT Gateway.
	PacketsInFromSource *int64

	noSmithyDocumentSerde
}

// The OpenSearch reserved instances recommendation details.
type OpenSearchReservedInstances struct {

	// The OpenSearch reserved instances configuration used for recommendations.
	Configuration *OpenSearchReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The OpenSearch reserved instances configuration used for recommendations.
type OpenSearchReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing these reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Defines how rows will be sorted in the response.
type OrderBy struct {

	// Sorts by dimension values.
	Dimension *string

	// The order that's used to sort the data.
	Order Order

	noSmithyDocumentSerde
}

// The preferred configuration for Reserved Instances and Savings Plans
// commitment-based discounts, consisting of a payment option and a commitment
// duration.
type PreferredCommitment struct {

	// The preferred upfront payment structure for commitments. If the value is null,
	// it will default to AllUpfront (highest savings) where applicable.
	PaymentOption PaymentOption

	// The preferred length of the commitment period. If the value is null, it will
	// default to ThreeYears (highest savings) where applicable.
	Term Term

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB instance.
type RdsDbInstance struct {

	// The Amazon RDS DB instance configuration used for recommendations.
	Configuration *RdsDbInstanceConfiguration

	// Cost impact of the resource recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Amazon RDS DB instance configuration used for recommendations.
type RdsDbInstanceConfiguration struct {

	// Details about the instance configuration.
	Instance *DbInstanceConfiguration

	noSmithyDocumentSerde
}

// Contains the details of an Amazon RDS DB instance storage.
type RdsDbInstanceStorage struct {

	// The Amazon RDS DB instance storage configuration used for recommendations.
	Configuration *RdsDbInstanceStorageConfiguration

	// Cost impact of the resource recommendation.
	CostCalculation *ResourceCostCalculation

	noSmithyDocumentSerde
}

// The Amazon RDS DB instance storage configuration used for recommendations.
type RdsDbInstanceStorageConfiguration struct {

	// The new amount of storage in GB to allocate for the DB instance.
	AllocatedStorageInGb *float64

	// The amount of Provisioned IOPS (input/output operations per second) to be
	// initially allocated for the DB instance.
	Iops *float64

	// The storage throughput for the DB instance.
	StorageThroughput *float64

	// The storage type to associate with the DB instance.
	StorageType *string

	noSmithyDocumentSerde
}

// The RDS reserved instances recommendation details.
type RdsReservedInstances struct {

	// The RDS reserved instances configuration used for recommendations.
	Configuration *RdsReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The RDS reserved instances configuration used for recommendations.
type RdsReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The database edition that the recommended reservation supports.
	DatabaseEdition *string

	// The database engine that the recommended reservation supports.
	DatabaseEngine *string

	// Determines whether the recommendation is for a reservation in a single
	// Availability Zone or a reservation with a backup in a second Availability Zone.
	DeploymentOption *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// The license model that the recommended reservation supports.
	LicenseModel *string

	// How much purchasing this instance costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Describes a recommendation.
type Recommendation struct {

	// The account to which the recommendation applies.
	AccountId *string

	// The type of tasks that can be carried out by this action.
	ActionType *string

	// The currency code used for the recommendation.
	CurrencyCode *string

	// Describes the current resource.
	CurrentResourceSummary *string

	// The current resource type.
	CurrentResourceType *string

	// The estimated monthly cost of the current resource. For Reserved Instances and
	// Savings Plans, it refers to the cost for eligible usage.
	EstimatedMonthlyCost *float64

	// The estimated monthly savings amount for the recommendation.
	EstimatedMonthlySavings *float64

	// The estimated savings percentage relative to the total cost over the cost
	// calculation lookback period.
	EstimatedSavingsPercentage *float64

	// The effort required to implement the recommendation.
	ImplementationEffort *string

	// The time when the recommendation was last generated.
	LastRefreshTimestamp *time.Time

	// The ID for the recommendation.
	RecommendationId *string

	// The lookback period that's used to generate the recommendation.
	RecommendationLookbackPeriodInDays *int32

	// Describes the recommended resource.
	RecommendedResourceSummary *string

	// The recommended resource type.
	RecommendedResourceType *string

	// The Amazon Web Services Region of the resource.
	Region *string

	// The Amazon Resource Name (ARN) for the recommendation.
	ResourceArn *string

	// The resource ID for the recommendation.
	ResourceId *string

	// Whether or not implementing the recommendation requires a restart.
	RestartNeeded *bool

	// Whether or not implementing the recommendation can be rolled back.
	RollbackPossible *bool

	// The source of the recommendation.
	Source Source

	// A list of tags assigned to the recommendation.
	Tags []Tag

	noSmithyDocumentSerde
}

// The summary of rightsizing recommendations, including de-duped savings from all
// types of recommendations.
type RecommendationSummary struct {

	// The estimated total savings resulting from modifications, on a monthly basis.
	EstimatedMonthlySavings *float64

	// The grouping of recommendations.
	Group *string

	// The total number of instance recommendations.
	RecommendationCount *int32

	noSmithyDocumentSerde
}

// The Redshift reserved instances recommendation details.
type RedshiftReservedInstances struct {

	// The Redshift reserved instances configuration used for recommendations.
	Configuration *RedshiftReservedInstancesConfiguration

	// Cost impact of the purchase recommendation.
	CostCalculation *ReservedInstancesCostCalculation

	noSmithyDocumentSerde
}

// The Redshift reserved instances configuration used for recommendations.
type RedshiftReservedInstancesConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// Determines whether the recommendation is for a current generation instance.
	CurrentGeneration *string

	// The instance family of the recommended reservation.
	InstanceFamily *string

	// The type of instance that Amazon Web Services recommends.
	InstanceType *string

	// How much purchasing these reserved instances costs you on a monthly basis.
	MonthlyRecurringCost *string

	// The number of normalized units that Amazon Web Services recommends that you
	// purchase.
	NormalizedUnitsToPurchase *string

	// The number of instances that Amazon Web Services recommends that you purchase.
	NumberOfInstancesToPurchase *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Amazon Web Services Region of the commitment.
	ReservedInstancesRegion *string

	// The service for which you want recommendations.
	Service *string

	// Determines whether the recommendation is size flexible.
	SizeFlexEligible *bool

	// The reserved instances recommendation term in years.
	Term *string

	// How much purchasing this instance costs you upfront.
	UpfrontCost *string

	noSmithyDocumentSerde
}

// Cost impact of the purchase recommendation.
type ReservedInstancesCostCalculation struct {

	// Pricing details of the purchase recommendation.
	Pricing *ReservedInstancesPricing

	noSmithyDocumentSerde
}

// Pricing details for your recommended reserved instance.
type ReservedInstancesPricing struct {

	// The estimated cost of your recurring monthly fees for the recommended reserved
	// instance across the month.
	EstimatedMonthlyAmortizedReservationCost *float64

	// The remaining On-Demand cost estimated to not be covered by the recommended
	// reserved instance, over the length of the lookback period.
	EstimatedOnDemandCost *float64

	// The cost of paying for the recommended reserved instance monthly.
	MonthlyReservationEligibleCost *float64

	// The savings percentage relative to the total On-Demand costs that are
	// associated with this instance.
	SavingsPercentage *float64

	noSmithyDocumentSerde
}

// Cost impact of the resource recommendation.
type ResourceCostCalculation struct {

	// Pricing details of the resource recommendation.
	Pricing *ResourcePricing

	// Usage details of the resource recommendation.
	Usages []Usage

	noSmithyDocumentSerde
}

// Contains detailed information about the specified resource.
//
// The following types satisfy this interface:
//
//	ResourceDetailsMemberAuroraDbClusterStorage
//	ResourceDetailsMemberComputeSavingsPlans
//	ResourceDetailsMemberDynamoDbReservedCapacity
//	ResourceDetailsMemberEbsVolume
//	ResourceDetailsMemberEc2AutoScalingGroup
//	ResourceDetailsMemberEc2Instance
//	ResourceDetailsMemberEc2InstanceSavingsPlans
//	ResourceDetailsMemberEc2ReservedInstances
//	ResourceDetailsMemberEcsService
//	ResourceDetailsMemberElastiCacheReservedInstances
//	ResourceDetailsMemberLambdaFunction
//	ResourceDetailsMemberMemoryDbReservedInstances
//	ResourceDetailsMemberNatGateway
//	ResourceDetailsMemberOpenSearchReservedInstances
//	ResourceDetailsMemberRdsDbInstance
//	ResourceDetailsMemberRdsDbInstanceStorage
//	ResourceDetailsMemberRdsReservedInstances
//	ResourceDetailsMemberRedshiftReservedInstances
//	ResourceDetailsMemberSageMakerSavingsPlans
type ResourceDetails interface {
	isResourceDetails()
}

// The Aurora DB cluster storage recommendation details.
type ResourceDetailsMemberAuroraDbClusterStorage struct {
	Value AuroraDbClusterStorage

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberAuroraDbClusterStorage) isResourceDetails() {}

// The Compute Savings Plans recommendation details.
type ResourceDetailsMemberComputeSavingsPlans struct {
	Value ComputeSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberComputeSavingsPlans) isResourceDetails() {}

// The DynamoDB reserved capacity recommendation details.
type ResourceDetailsMemberDynamoDbReservedCapacity struct {
	Value DynamoDbReservedCapacity

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberDynamoDbReservedCapacity) isResourceDetails() {}

// The Amazon Elastic Block Store volume recommendation details.
type ResourceDetailsMemberEbsVolume struct {
	Value EbsVolume

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEbsVolume) isResourceDetails() {}

// The EC2 Auto Scaling group recommendation details.
type ResourceDetailsMemberEc2AutoScalingGroup struct {
	Value Ec2AutoScalingGroup

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2AutoScalingGroup) isResourceDetails() {}

// The EC2 instance recommendation details.
type ResourceDetailsMemberEc2Instance struct {
	Value Ec2Instance

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2Instance) isResourceDetails() {}

// The EC2 instance Savings Plans recommendation details.
type ResourceDetailsMemberEc2InstanceSavingsPlans struct {
	Value Ec2InstanceSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2InstanceSavingsPlans) isResourceDetails() {}

// The EC2 reserved instances recommendation details.
type ResourceDetailsMemberEc2ReservedInstances struct {
	Value Ec2ReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEc2ReservedInstances) isResourceDetails() {}

// The ECS service recommendation details.
type ResourceDetailsMemberEcsService struct {
	Value EcsService

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberEcsService) isResourceDetails() {}

// The ElastiCache reserved instances recommendation details.
type ResourceDetailsMemberElastiCacheReservedInstances struct {
	Value ElastiCacheReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberElastiCacheReservedInstances) isResourceDetails() {}

// The Lambda function recommendation details.
type ResourceDetailsMemberLambdaFunction struct {
	Value LambdaFunction

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberLambdaFunction) isResourceDetails() {}

// The MemoryDB reserved instances recommendation details.
type ResourceDetailsMemberMemoryDbReservedInstances struct {
	Value MemoryDbReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberMemoryDbReservedInstances) isResourceDetails() {}

// The NAT Gateway recommendation details.
type ResourceDetailsMemberNatGateway struct {
	Value NatGateway

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberNatGateway) isResourceDetails() {}

// The OpenSearch reserved instances recommendation details.
type ResourceDetailsMemberOpenSearchReservedInstances struct {
	Value OpenSearchReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberOpenSearchReservedInstances) isResourceDetails() {}

// The DB instance recommendation details.
type ResourceDetailsMemberRdsDbInstance struct {
	Value RdsDbInstance

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRdsDbInstance) isResourceDetails() {}

// The DB instance storage recommendation details.
type ResourceDetailsMemberRdsDbInstanceStorage struct {
	Value RdsDbInstanceStorage

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRdsDbInstanceStorage) isResourceDetails() {}

// The RDS reserved instances recommendation details.
type ResourceDetailsMemberRdsReservedInstances struct {
	Value RdsReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRdsReservedInstances) isResourceDetails() {}

// The Redshift reserved instances recommendation details.
type ResourceDetailsMemberRedshiftReservedInstances struct {
	Value RedshiftReservedInstances

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberRedshiftReservedInstances) isResourceDetails() {}

// The SageMaker AI Savings Plans recommendation details.
type ResourceDetailsMemberSageMakerSavingsPlans struct {
	Value SageMakerSavingsPlans

	noSmithyDocumentSerde
}

func (*ResourceDetailsMemberSageMakerSavingsPlans) isResourceDetails() {}

// Contains pricing information about the specified resource.
type ResourcePricing struct {

	// The savings estimate incorporating all discounts with Amazon Web Services, such
	// as Reserved Instances and Savings Plans.
	EstimatedCostAfterDiscounts *float64

	// The savings estimate using Amazon Web Services public pricing without
	// incorporating any discounts.
	EstimatedCostBeforeDiscounts *float64

	// The estimated discounts for a recommendation.
	EstimatedDiscounts *EstimatedDiscounts

	// The estimated net unused amortized commitment for the recommendation.
	EstimatedNetUnusedAmortizedCommitments *float64

	noSmithyDocumentSerde
}

// The SageMaker Savings Plans recommendation details.
type SageMakerSavingsPlans struct {

	// The SageMaker Savings Plans configuration used for recommendations.
	Configuration *SageMakerSavingsPlansConfiguration

	// Cost impact of the Savings Plans purchase recommendation.
	CostCalculation *SavingsPlansCostCalculation

	noSmithyDocumentSerde
}

// The SageMaker Savings Plans configuration used for recommendations.
type SageMakerSavingsPlansConfiguration struct {

	// The account scope for which you want recommendations.
	AccountScope *string

	// The hourly commitment for the Savings Plans type.
	HourlyCommitment *string

	// The payment option for the commitment.
	PaymentOption *string

	// The Savings Plans recommendation term in years.
	Term *string

	noSmithyDocumentSerde
}

// Cost impact of the purchase recommendation.
type SavingsPlansCostCalculation struct {

	// Pricing details of the purchase recommendation.
	Pricing *SavingsPlansPricing

	noSmithyDocumentSerde
}

// Pricing information about a Savings Plans.
type SavingsPlansPricing struct {

	// Estimated monthly commitment for the Savings Plans.
	EstimatedMonthlyCommitment *float64

	// Estimated On-Demand cost you will pay after buying the Savings Plans.
	EstimatedOnDemandCost *float64

	// The cost of paying for the recommended Savings Plans monthly.
	MonthlySavingsPlansEligibleCost *float64

	// Estimated savings as a percentage of your overall costs after buying the
	// Savings Plans.
	SavingsPercentage *float64

	noSmithyDocumentSerde
}

// The storage configuration used for recommendations.
type StorageConfiguration struct {

	// The storage volume.
	SizeInGb *float64

	// The storage type.
	Type *string

	noSmithyDocumentSerde
}

// The results or descriptions for the additional metrics, based on whether the
// metrics were or were not requested.
type SummaryMetricsResult struct {

	// The savings percentage based on your Amazon Web Services spend over the past 30
	// days.
	//
	// Savings percentage is only supported when filtering by Region, account ID, or
	// tags.
	SavingsPercentage *string

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type Tag struct {

	// The key that's associated with the tag.
	Key *string

	// The value that's associated with the tag.
	Value *string

	noSmithyDocumentSerde
}

// Specifies a date range for retrieving efficiency metrics. The start date is
// inclusive and the end date is exclusive.
type TimePeriod struct {

	// The end of the time period (exclusive). Specify the date in ISO 8601 format,
	// such as 2024-12-31.
	//
	// This member is required.
	End *string

	// The beginning of the time period (inclusive). Specify the date in ISO 8601
	// format, such as 2024-01-01.
	//
	// This member is required.
	Start *string

	noSmithyDocumentSerde
}

// Details about the usage.
type Usage struct {

	// The operation value.
	Operation *string

	// The product code.
	ProductCode *string

	// The usage unit.
	Unit *string

	// The usage amount.
	UsageAmount *float64

	// The usage type.
	UsageType *string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionDetail struct {

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	FieldName *string

	// A message with the reason for the validation exception error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResourceDetails() {}
