// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all DomainObjectType(s) in a Customer Profiles domain.
func (c *Client) ListDomainObjectTypes(ctx context.Context, params *ListDomainObjectTypesInput, optFns ...func(*Options)) (*ListDomainObjectTypesOutput, error) {
	if params == nil {
		params = &ListDomainObjectTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDomainObjectTypes", params, optFns, c.addOperationListDomainObjectTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDomainObjectTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDomainObjectTypesInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The maximum number of domain object types returned per page.
	MaxResults *int32

	// The pagination token from the previous call to ListDomainObjectTypes.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDomainObjectTypesOutput struct {

	// The list of domain object types.
	Items []types.DomainObjectTypesListItem

	// The pagination token from the previous call to ListDomainObjectTypes.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDomainObjectTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDomainObjectTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDomainObjectTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDomainObjectTypes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDomainObjectTypesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDomainObjectTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDomainObjectTypesPaginatorOptions is the paginator options for
// ListDomainObjectTypes
type ListDomainObjectTypesPaginatorOptions struct {
	// The maximum number of domain object types returned per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDomainObjectTypesPaginator is a paginator for ListDomainObjectTypes
type ListDomainObjectTypesPaginator struct {
	options   ListDomainObjectTypesPaginatorOptions
	client    ListDomainObjectTypesAPIClient
	params    *ListDomainObjectTypesInput
	nextToken *string
	firstPage bool
}

// NewListDomainObjectTypesPaginator returns a new ListDomainObjectTypesPaginator
func NewListDomainObjectTypesPaginator(client ListDomainObjectTypesAPIClient, params *ListDomainObjectTypesInput, optFns ...func(*ListDomainObjectTypesPaginatorOptions)) *ListDomainObjectTypesPaginator {
	if params == nil {
		params = &ListDomainObjectTypesInput{}
	}

	options := ListDomainObjectTypesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDomainObjectTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDomainObjectTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDomainObjectTypes page.
func (p *ListDomainObjectTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDomainObjectTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDomainObjectTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDomainObjectTypesAPIClient is a client that implements the
// ListDomainObjectTypes operation.
type ListDomainObjectTypesAPIClient interface {
	ListDomainObjectTypes(context.Context, *ListDomainObjectTypesInput, ...func(*Options)) (*ListDomainObjectTypesOutput, error)
}

var _ ListDomainObjectTypesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDomainObjectTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDomainObjectTypes",
	}
}
