// Code generated by smithy-go-codegen DO NOT EDIT.

package datasync

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datasync/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a transfer location for an Amazon FSx for Lustre file system. DataSync
// can use this location as a source or destination for transferring data.
//
// Before you begin, make sure that you understand how DataSync [accesses FSx for Lustre file systems].
//
// [accesses FSx for Lustre file systems]: https://docs.aws.amazon.com/datasync/latest/userguide/create-lustre-location.html#create-lustre-location-access
func (c *Client) CreateLocationFsxLustre(ctx context.Context, params *CreateLocationFsxLustreInput, optFns ...func(*Options)) (*CreateLocationFsxLustreOutput, error) {
	if params == nil {
		params = &CreateLocationFsxLustreInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLocationFsxLustre", params, optFns, c.addOperationCreateLocationFsxLustreMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLocationFsxLustreOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLocationFsxLustreInput struct {

	// Specifies the Amazon Resource Name (ARN) of the FSx for Lustre file system.
	//
	// This member is required.
	FsxFilesystemArn *string

	// Specifies the Amazon Resource Names (ARNs) of up to five security groups that
	// provide access to your FSx for Lustre file system.
	//
	// The security groups must be able to access the file system's ports. The file
	// system must also allow access from the security groups. For information about
	// file system access, see the [Amazon FSx for Lustre User Guide].
	//
	// [Amazon FSx for Lustre User Guide]: https://docs.aws.amazon.com/fsx/latest/LustreGuide/limit-access-security-groups.html
	//
	// This member is required.
	SecurityGroupArns []string

	// Specifies a mount path for your FSx for Lustre file system. The path can
	// include subdirectories.
	//
	// When the location is used as a source, DataSync reads data from the mount path.
	// When the location is used as a destination, DataSync writes data to the mount
	// path. If you don't include this parameter, DataSync uses the file system's root
	// directory ( / ).
	Subdirectory *string

	// Specifies labels that help you categorize, filter, and search for your Amazon
	// Web Services resources. We recommend creating at least a name tag for your
	// location.
	Tags []types.TagListEntry

	noSmithyDocumentSerde
}

type CreateLocationFsxLustreOutput struct {

	// The Amazon Resource Name (ARN) of the FSx for Lustre file system location that
	// you created.
	LocationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLocationFsxLustreMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLocationFsxLustre{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLocationFsxLustre{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLocationFsxLustre"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLocationFsxLustreValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLocationFsxLustre(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLocationFsxLustre(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLocationFsxLustre",
	}
}
