// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets an Amazon DataZone blueprint.
func (c *Client) GetEnvironmentBlueprint(ctx context.Context, params *GetEnvironmentBlueprintInput, optFns ...func(*Options)) (*GetEnvironmentBlueprintOutput, error) {
	if params == nil {
		params = &GetEnvironmentBlueprintInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetEnvironmentBlueprint", params, optFns, c.addOperationGetEnvironmentBlueprintMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetEnvironmentBlueprintOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetEnvironmentBlueprintInput struct {

	// The identifier of the domain in which this blueprint exists.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of this Amazon DataZone blueprint.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetEnvironmentBlueprintOutput struct {

	// The ID of this Amazon DataZone blueprint.
	//
	// This member is required.
	Id *string

	// The name of this Amazon DataZone blueprint.
	//
	// This member is required.
	Name *string

	// The provider of this Amazon DataZone blueprint.
	//
	// This member is required.
	Provider *string

	// The provisioning properties of this Amazon DataZone blueprint.
	//
	// This member is required.
	ProvisioningProperties types.ProvisioningProperties

	// A timestamp of when this blueprint was created.
	CreatedAt *time.Time

	// The deployment properties of this Amazon DataZone blueprint.
	DeploymentProperties *types.DeploymentProperties

	// The description of this Amazon DataZone blueprint.
	Description *string

	// The glossary terms attached to this Amazon DataZone blueprint.
	GlossaryTerms []string

	// The timestamp of when this blueprint was updated.
	UpdatedAt *time.Time

	// The user parameters of this blueprint.
	UserParameters []types.CustomParameter

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetEnvironmentBlueprintMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetEnvironmentBlueprint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetEnvironmentBlueprint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetEnvironmentBlueprint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetEnvironmentBlueprintValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetEnvironmentBlueprint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetEnvironmentBlueprint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetEnvironmentBlueprint",
	}
}
