// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists existing account pools.
func (c *Client) ListAccountPools(ctx context.Context, params *ListAccountPoolsInput, optFns ...func(*Options)) (*ListAccountPoolsOutput, error) {
	if params == nil {
		params = &ListAccountPoolsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccountPools", params, optFns, c.addOperationListAccountPoolsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccountPoolsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccountPoolsInput struct {

	// The ID of the domain where exsting account pools are to be listed.
	//
	// This member is required.
	DomainIdentifier *string

	// The maximum number of account pools to return in a single call to
	// ListAccountPools. When the number of account pools to be listed is greater than
	// the value of MaxResults, the response contains a NextToken value that you can
	// use in a subsequent call to ListAccountPools to list the next set of account
	// pools.
	MaxResults *int32

	// The name of the account pool to be listed.
	Name *string

	// When the number of account pools is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of account pools, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListAccountPools to list the next set of account pools.
	NextToken *string

	// The sort by mechanism in which the existing account pools are to be listed.
	SortBy types.SortFieldAccountPool

	// The sort order in which the existing account pools are to be listed.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListAccountPoolsOutput struct {

	// The results of the ListAccountPools operation.
	Items []types.AccountPoolSummary

	// When the number of account pools is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of account pools, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListAccountPools to list the next set of account pools.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccountPoolsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAccountPools{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAccountPools{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccountPools"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccountPoolsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccountPools(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAccountPoolsPaginatorOptions is the paginator options for ListAccountPools
type ListAccountPoolsPaginatorOptions struct {
	// The maximum number of account pools to return in a single call to
	// ListAccountPools. When the number of account pools to be listed is greater than
	// the value of MaxResults, the response contains a NextToken value that you can
	// use in a subsequent call to ListAccountPools to list the next set of account
	// pools.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccountPoolsPaginator is a paginator for ListAccountPools
type ListAccountPoolsPaginator struct {
	options   ListAccountPoolsPaginatorOptions
	client    ListAccountPoolsAPIClient
	params    *ListAccountPoolsInput
	nextToken *string
	firstPage bool
}

// NewListAccountPoolsPaginator returns a new ListAccountPoolsPaginator
func NewListAccountPoolsPaginator(client ListAccountPoolsAPIClient, params *ListAccountPoolsInput, optFns ...func(*ListAccountPoolsPaginatorOptions)) *ListAccountPoolsPaginator {
	if params == nil {
		params = &ListAccountPoolsInput{}
	}

	options := ListAccountPoolsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccountPoolsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccountPoolsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccountPools page.
func (p *ListAccountPoolsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccountPoolsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccountPools(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccountPoolsAPIClient is a client that implements the ListAccountPools
// operation.
type ListAccountPoolsAPIClient interface {
	ListAccountPools(context.Context, *ListAccountPoolsInput, ...func(*Options)) (*ListAccountPoolsOutput, error)
}

var _ ListAccountPoolsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccountPools(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccountPools",
	}
}
