// Code generated by smithy-go-codegen DO NOT EDIT.

package devicefarm

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/devicefarm/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of the actions taken in a TestGridSession.
func (c *Client) ListTestGridSessionActions(ctx context.Context, params *ListTestGridSessionActionsInput, optFns ...func(*Options)) (*ListTestGridSessionActionsOutput, error) {
	if params == nil {
		params = &ListTestGridSessionActionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestGridSessionActions", params, optFns, c.addOperationListTestGridSessionActionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestGridSessionActionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestGridSessionActionsInput struct {

	// The ARN of the session to retrieve.
	//
	// This member is required.
	SessionArn *string

	// The maximum number of sessions to return per response.
	MaxResult *int32

	// Pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListTestGridSessionActionsOutput struct {

	// The action taken by the session.
	Actions []types.TestGridSessionAction

	// Pagination token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestGridSessionActionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTestGridSessionActions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTestGridSessionActions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestGridSessionActions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTestGridSessionActionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestGridSessionActions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTestGridSessionActionsPaginatorOptions is the paginator options for
// ListTestGridSessionActions
type ListTestGridSessionActionsPaginatorOptions struct {
	// The maximum number of sessions to return per response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestGridSessionActionsPaginator is a paginator for
// ListTestGridSessionActions
type ListTestGridSessionActionsPaginator struct {
	options   ListTestGridSessionActionsPaginatorOptions
	client    ListTestGridSessionActionsAPIClient
	params    *ListTestGridSessionActionsInput
	nextToken *string
	firstPage bool
}

// NewListTestGridSessionActionsPaginator returns a new
// ListTestGridSessionActionsPaginator
func NewListTestGridSessionActionsPaginator(client ListTestGridSessionActionsAPIClient, params *ListTestGridSessionActionsInput, optFns ...func(*ListTestGridSessionActionsPaginatorOptions)) *ListTestGridSessionActionsPaginator {
	if params == nil {
		params = &ListTestGridSessionActionsInput{}
	}

	options := ListTestGridSessionActionsPaginatorOptions{}
	if params.MaxResult != nil {
		options.Limit = *params.MaxResult
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestGridSessionActionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestGridSessionActionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestGridSessionActions page.
func (p *ListTestGridSessionActionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestGridSessionActionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResult = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestGridSessionActions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestGridSessionActionsAPIClient is a client that implements the
// ListTestGridSessionActions operation.
type ListTestGridSessionActionsAPIClient interface {
	ListTestGridSessionActions(context.Context, *ListTestGridSessionActionsInput, ...func(*Options)) (*ListTestGridSessionActionsOutput, error)
}

var _ ListTestGridSessionActionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestGridSessionActions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestGridSessionActions",
	}
}
