// Code generated by smithy-go-codegen DO NOT EDIT.

package entityresolution

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/entityresolution/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a matching workflow that defines the configuration for a data
// processing job. The workflow name must be unique. To modify an existing
// workflow, use UpdateMatchingWorkflow .
//
// For workflows where resolutionType is ML_MATCHING or PROVIDER , incremental
// processing is not supported.
func (c *Client) CreateMatchingWorkflow(ctx context.Context, params *CreateMatchingWorkflowInput, optFns ...func(*Options)) (*CreateMatchingWorkflowOutput, error) {
	if params == nil {
		params = &CreateMatchingWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateMatchingWorkflow", params, optFns, c.addOperationCreateMatchingWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateMatchingWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateMatchingWorkflowInput struct {

	// A list of InputSource objects, which have the fields InputSourceARN and
	// SchemaName .
	//
	// This member is required.
	InputSourceConfig []types.InputSource

	// A list of OutputSource objects, each of which contains fields outputS3Path ,
	// applyNormalization , KMSArn , and output .
	//
	// This member is required.
	OutputSourceConfig []types.OutputSource

	// An object which defines the resolutionType and the ruleBasedProperties .
	//
	// This member is required.
	ResolutionTechniques *types.ResolutionTechniques

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this
	// role to create resources on your behalf as part of workflow execution.
	//
	// This member is required.
	RoleArn *string

	// The name of the workflow. There can't be multiple MatchingWorkflows with the
	// same name.
	//
	// This member is required.
	WorkflowName *string

	// A description of the workflow.
	Description *string

	// Optional. An object that defines the incremental run type. This object contains
	// only the incrementalRunType field, which appears as "Automatic" in the console.
	//
	// For workflows where resolutionType is ML_MATCHING or PROVIDER , incremental
	// processing is not supported.
	IncrementalRunConfig *types.IncrementalRunConfig

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateMatchingWorkflowOutput struct {

	// A list of InputSource objects, which have the fields InputSourceARN and
	// SchemaName .
	//
	// This member is required.
	InputSourceConfig []types.InputSource

	// A list of OutputSource objects, each of which contains fields outputS3Path ,
	// applyNormalization , KMSArn , and output .
	//
	// This member is required.
	OutputSourceConfig []types.OutputSource

	// An object which defines the resolutionType and the ruleBasedProperties .
	//
	// This member is required.
	ResolutionTechniques *types.ResolutionTechniques

	// The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this
	// role to create resources on your behalf as part of workflow execution.
	//
	// This member is required.
	RoleArn *string

	// The ARN (Amazon Resource Name) that Entity Resolution generated for the
	// MatchingWorkflow .
	//
	// This member is required.
	WorkflowArn *string

	// The name of the workflow.
	//
	// This member is required.
	WorkflowName *string

	// A description of the workflow.
	Description *string

	// An object which defines an incremental run type and has only incrementalRunType
	// as a field.
	IncrementalRunConfig *types.IncrementalRunConfig

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateMatchingWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateMatchingWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateMatchingWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateMatchingWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateMatchingWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateMatchingWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateMatchingWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateMatchingWorkflow",
	}
}
