// Code generated by smithy-go-codegen DO NOT EDIT.

package evs

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/evs/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateEipToVlan struct {
}

func (*validateOpAssociateEipToVlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateEipToVlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateEipToVlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateEipToVlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateEnvironmentHost struct {
}

func (*validateOpCreateEnvironmentHost) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateEnvironmentHost) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateEnvironmentHostInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateEnvironmentHostInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateEnvironment struct {
}

func (*validateOpCreateEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteEnvironmentHost struct {
}

func (*validateOpDeleteEnvironmentHost) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEnvironmentHost) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEnvironmentHostInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEnvironmentHostInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteEnvironment struct {
}

func (*validateOpDeleteEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateEipFromVlan struct {
}

func (*validateOpDisassociateEipFromVlan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateEipFromVlan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateEipFromVlanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateEipFromVlanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetEnvironment struct {
}

func (*validateOpGetEnvironment) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetEnvironment) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetEnvironmentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetEnvironmentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListEnvironmentHosts struct {
}

func (*validateOpListEnvironmentHosts) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListEnvironmentHosts) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListEnvironmentHostsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListEnvironmentHostsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListEnvironmentVlans struct {
}

func (*validateOpListEnvironmentVlans) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListEnvironmentVlans) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListEnvironmentVlansInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListEnvironmentVlansInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateEipToVlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateEipToVlan{}, middleware.After)
}

func addOpCreateEnvironmentHostValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateEnvironmentHost{}, middleware.After)
}

func addOpCreateEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateEnvironment{}, middleware.After)
}

func addOpDeleteEnvironmentHostValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEnvironmentHost{}, middleware.After)
}

func addOpDeleteEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteEnvironment{}, middleware.After)
}

func addOpDisassociateEipFromVlanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateEipFromVlan{}, middleware.After)
}

func addOpGetEnvironmentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetEnvironment{}, middleware.After)
}

func addOpListEnvironmentHostsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListEnvironmentHosts{}, middleware.After)
}

func addOpListEnvironmentVlansValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListEnvironmentVlans{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func validateConnectivityInfo(v *types.ConnectivityInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ConnectivityInfo"}
	if v.PrivateRouteServerPeerings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PrivateRouteServerPeerings"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHostInfoForCreate(v *types.HostInfoForCreate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HostInfoForCreate"}
	if v.HostName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HostName"))
	}
	if v.KeyName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyName"))
	}
	if len(v.InstanceType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("InstanceType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHostInfoForCreateList(v []types.HostInfoForCreate) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HostInfoForCreateList"}
	for i := range v {
		if err := validateHostInfoForCreate(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInitialVlanInfo(v *types.InitialVlanInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitialVlanInfo"}
	if v.Cidr == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Cidr"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateInitialVlans(v *types.InitialVlans) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitialVlans"}
	if v.VmkManagement == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VmkManagement"))
	} else if v.VmkManagement != nil {
		if err := validateInitialVlanInfo(v.VmkManagement); err != nil {
			invalidParams.AddNested("VmkManagement", err.(smithy.InvalidParamsError))
		}
	}
	if v.VmManagement == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VmManagement"))
	} else if v.VmManagement != nil {
		if err := validateInitialVlanInfo(v.VmManagement); err != nil {
			invalidParams.AddNested("VmManagement", err.(smithy.InvalidParamsError))
		}
	}
	if v.VMotion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VMotion"))
	} else if v.VMotion != nil {
		if err := validateInitialVlanInfo(v.VMotion); err != nil {
			invalidParams.AddNested("VMotion", err.(smithy.InvalidParamsError))
		}
	}
	if v.VSan == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VSan"))
	} else if v.VSan != nil {
		if err := validateInitialVlanInfo(v.VSan); err != nil {
			invalidParams.AddNested("VSan", err.(smithy.InvalidParamsError))
		}
	}
	if v.VTep == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VTep"))
	} else if v.VTep != nil {
		if err := validateInitialVlanInfo(v.VTep); err != nil {
			invalidParams.AddNested("VTep", err.(smithy.InvalidParamsError))
		}
	}
	if v.EdgeVTep == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EdgeVTep"))
	} else if v.EdgeVTep != nil {
		if err := validateInitialVlanInfo(v.EdgeVTep); err != nil {
			invalidParams.AddNested("EdgeVTep", err.(smithy.InvalidParamsError))
		}
	}
	if v.NsxUplink == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxUplink"))
	} else if v.NsxUplink != nil {
		if err := validateInitialVlanInfo(v.NsxUplink); err != nil {
			invalidParams.AddNested("NsxUplink", err.(smithy.InvalidParamsError))
		}
	}
	if v.Hcx == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Hcx"))
	} else if v.Hcx != nil {
		if err := validateInitialVlanInfo(v.Hcx); err != nil {
			invalidParams.AddNested("Hcx", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExpansionVlan1 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExpansionVlan1"))
	} else if v.ExpansionVlan1 != nil {
		if err := validateInitialVlanInfo(v.ExpansionVlan1); err != nil {
			invalidParams.AddNested("ExpansionVlan1", err.(smithy.InvalidParamsError))
		}
	}
	if v.ExpansionVlan2 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ExpansionVlan2"))
	} else if v.ExpansionVlan2 != nil {
		if err := validateInitialVlanInfo(v.ExpansionVlan2); err != nil {
			invalidParams.AddNested("ExpansionVlan2", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLicenseInfo(v *types.LicenseInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LicenseInfo"}
	if v.SolutionKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SolutionKey"))
	}
	if v.VsanKey == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VsanKey"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLicenseInfoList(v []types.LicenseInfo) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LicenseInfoList"}
	for i := range v {
		if err := validateLicenseInfo(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateVcfHostnames(v *types.VcfHostnames) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "VcfHostnames"}
	if v.VCenter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VCenter"))
	}
	if v.Nsx == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Nsx"))
	}
	if v.NsxManager1 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxManager1"))
	}
	if v.NsxManager2 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxManager2"))
	}
	if v.NsxManager3 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxManager3"))
	}
	if v.NsxEdge1 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxEdge1"))
	}
	if v.NsxEdge2 == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NsxEdge2"))
	}
	if v.SddcManager == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SddcManager"))
	}
	if v.CloudBuilder == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CloudBuilder"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateEipToVlanInput(v *AssociateEipToVlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateEipToVlanInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.VlanName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VlanName"))
	}
	if v.AllocationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllocationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateEnvironmentHostInput(v *CreateEnvironmentHostInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateEnvironmentHostInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.Host == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Host"))
	} else if v.Host != nil {
		if err := validateHostInfoForCreate(v.Host); err != nil {
			invalidParams.AddNested("Host", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateEnvironmentInput(v *CreateEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateEnvironmentInput"}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if v.ServiceAccessSubnetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ServiceAccessSubnetId"))
	}
	if len(v.VcfVersion) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("VcfVersion"))
	}
	if v.TermsAccepted == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TermsAccepted"))
	}
	if v.LicenseInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LicenseInfo"))
	} else if v.LicenseInfo != nil {
		if err := validateLicenseInfoList(v.LicenseInfo); err != nil {
			invalidParams.AddNested("LicenseInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.InitialVlans == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InitialVlans"))
	} else if v.InitialVlans != nil {
		if err := validateInitialVlans(v.InitialVlans); err != nil {
			invalidParams.AddNested("InitialVlans", err.(smithy.InvalidParamsError))
		}
	}
	if v.Hosts == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Hosts"))
	} else if v.Hosts != nil {
		if err := validateHostInfoForCreateList(v.Hosts); err != nil {
			invalidParams.AddNested("Hosts", err.(smithy.InvalidParamsError))
		}
	}
	if v.ConnectivityInfo == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ConnectivityInfo"))
	} else if v.ConnectivityInfo != nil {
		if err := validateConnectivityInfo(v.ConnectivityInfo); err != nil {
			invalidParams.AddNested("ConnectivityInfo", err.(smithy.InvalidParamsError))
		}
	}
	if v.VcfHostnames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VcfHostnames"))
	} else if v.VcfHostnames != nil {
		if err := validateVcfHostnames(v.VcfHostnames); err != nil {
			invalidParams.AddNested("VcfHostnames", err.(smithy.InvalidParamsError))
		}
	}
	if v.SiteId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SiteId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEnvironmentHostInput(v *DeleteEnvironmentHostInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEnvironmentHostInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.HostName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HostName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteEnvironmentInput(v *DeleteEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteEnvironmentInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateEipFromVlanInput(v *DisassociateEipFromVlanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateEipFromVlanInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if v.VlanName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VlanName"))
	}
	if v.AssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetEnvironmentInput(v *GetEnvironmentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetEnvironmentInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListEnvironmentHostsInput(v *ListEnvironmentHostsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListEnvironmentHostsInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListEnvironmentVlansInput(v *ListEnvironmentVlansInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListEnvironmentVlansInput"}
	if v.EnvironmentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EnvironmentId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
