// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This API works with the following fleet types: Container
//
// Retrieves all versions of a container group definition. Use the pagination
// parameters to retrieve results in a set of sequential pages.
//
// Request options:
//
//   - Get all versions of a specified container group definition. Specify the
//     container group definition name or ARN value. (If the ARN value has a version
//     number, it's ignored.)
//
// Results:
//
// If successful, this operation returns the complete properties of a set of
// container group definition versions that match the request.
//
// This operation returns the list of container group definitions in descending
// version order (latest first).
//
// # Learn more
//
// [Manage a container group definition]
//
// [Manage a container group definition]: https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html
func (c *Client) ListContainerGroupDefinitionVersions(ctx context.Context, params *ListContainerGroupDefinitionVersionsInput, optFns ...func(*Options)) (*ListContainerGroupDefinitionVersionsOutput, error) {
	if params == nil {
		params = &ListContainerGroupDefinitionVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListContainerGroupDefinitionVersions", params, optFns, c.addOperationListContainerGroupDefinitionVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListContainerGroupDefinitionVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListContainerGroupDefinitionVersionsInput struct {

	// The unique identifier for the container group definition to retrieve properties
	// for. You can use either the Name or ARN value.
	//
	// This member is required.
	Name *string

	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int32

	// A token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this operation. To start at
	// the beginning of the result set, do not specify a value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListContainerGroupDefinitionVersionsOutput struct {

	// A result set of container group definitions that match the request.
	ContainerGroupDefinitions []types.ContainerGroupDefinition

	// A token that indicates where to resume retrieving results on the next call to
	// this operation. If no token is returned, these results represent the end of the
	// list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListContainerGroupDefinitionVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListContainerGroupDefinitionVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListContainerGroupDefinitionVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListContainerGroupDefinitionVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListContainerGroupDefinitionVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListContainerGroupDefinitionVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListContainerGroupDefinitionVersionsPaginatorOptions is the paginator options
// for ListContainerGroupDefinitionVersions
type ListContainerGroupDefinitionVersionsPaginatorOptions struct {
	// The maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListContainerGroupDefinitionVersionsPaginator is a paginator for
// ListContainerGroupDefinitionVersions
type ListContainerGroupDefinitionVersionsPaginator struct {
	options   ListContainerGroupDefinitionVersionsPaginatorOptions
	client    ListContainerGroupDefinitionVersionsAPIClient
	params    *ListContainerGroupDefinitionVersionsInput
	nextToken *string
	firstPage bool
}

// NewListContainerGroupDefinitionVersionsPaginator returns a new
// ListContainerGroupDefinitionVersionsPaginator
func NewListContainerGroupDefinitionVersionsPaginator(client ListContainerGroupDefinitionVersionsAPIClient, params *ListContainerGroupDefinitionVersionsInput, optFns ...func(*ListContainerGroupDefinitionVersionsPaginatorOptions)) *ListContainerGroupDefinitionVersionsPaginator {
	if params == nil {
		params = &ListContainerGroupDefinitionVersionsInput{}
	}

	options := ListContainerGroupDefinitionVersionsPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListContainerGroupDefinitionVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListContainerGroupDefinitionVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListContainerGroupDefinitionVersions page.
func (p *ListContainerGroupDefinitionVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListContainerGroupDefinitionVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListContainerGroupDefinitionVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListContainerGroupDefinitionVersionsAPIClient is a client that implements the
// ListContainerGroupDefinitionVersions operation.
type ListContainerGroupDefinitionVersionsAPIClient interface {
	ListContainerGroupDefinitionVersions(context.Context, *ListContainerGroupDefinitionVersionsInput, ...func(*Options)) (*ListContainerGroupDefinitionVersionsOutput, error)
}

var _ ListContainerGroupDefinitionVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListContainerGroupDefinitionVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListContainerGroupDefinitionVersions",
	}
}
