// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This API works with the following fleet types: Container
//
// Updates properties in an existing container group definition. This operation
// doesn't replace the definition. Instead, it creates a new version of the
// definition and saves it separately. You can access all versions that you choose
// to retain.
//
// The only property you can't update is the container group type.
//
// Request options:
//
//   - Update based on the latest version of the container group definition.
//     Specify the container group definition name only, or use an ARN value without a
//     version number. Provide updated values for the properties that you want to
//     change only. All other values remain the same as the latest version.
//
//   - Update based on a specific version of the container group definition.
//     Specify the container group definition name and a source version number, or use
//     an ARN value with a version number. Provide updated values for the properties
//     that you want to change only. All other values remain the same as the source
//     version.
//
//   - Change a game server container definition. Provide the updated container
//     definition.
//
//   - Add or change a support container definition. Provide a complete set of
//     container definitions, including the updated definition.
//
//   - Remove a support container definition. Provide a complete set of container
//     definitions, excluding the definition to remove. If the container group has only
//     one support container definition, provide an empty set.
//
// Results:
//
// If successful, this operation returns the complete properties of the new
// container group definition version.
//
// If the container group definition version is used in an active fleets, the
// update automatically initiates a new fleet deployment of the new version. You
// can track a fleet's deployments using [ListFleetDeployments].
//
// [ListFleetDeployments]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleetDeployments.html
func (c *Client) UpdateContainerGroupDefinition(ctx context.Context, params *UpdateContainerGroupDefinitionInput, optFns ...func(*Options)) (*UpdateContainerGroupDefinitionOutput, error) {
	if params == nil {
		params = &UpdateContainerGroupDefinitionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateContainerGroupDefinition", params, optFns, c.addOperationUpdateContainerGroupDefinitionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateContainerGroupDefinitionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateContainerGroupDefinitionInput struct {

	// A descriptive identifier for the container group definition. The name value
	// must be unique in an Amazon Web Services Region.
	//
	// This member is required.
	Name *string

	// An updated definition for the game server container in this group. Define a
	// game server container only when the container group type is GAME_SERVER . You
	// can pass in your container definitions as a JSON file.
	GameServerContainerDefinition *types.GameServerContainerDefinitionInput

	// The platform that all containers in the group use. Containers in a group must
	// run on the same operating system.
	//
	// Amazon Linux 2 (AL2) will reach end of support on 6/30/2025. See more details
	// in the [Amazon Linux 2 FAQs]. For game servers that are hosted on AL2 and use server SDK version 4.x
	// for Amazon GameLift Servers, first update the game server build to server SDK
	// 5.x, and then deploy to AL2023 instances. See [Migrate to server SDK version 5.]
	//
	// [Migrate to server SDK version 5.]: https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk5-migration.html
	// [Amazon Linux 2 FAQs]: http://aws.amazon.com/amazon-linux-2/faqs/
	OperatingSystem types.ContainerOperatingSystem

	// The container group definition version to update. The new version starts with
	// values from the source version, and then updates values included in this
	// request.
	SourceVersionNumber *int32

	// One or more definitions for support containers in this group. You can define a
	// support container in any type of container group. You can pass in your container
	// definitions as a JSON file.
	SupportContainerDefinitions []types.SupportContainerDefinitionInput

	// The maximum amount of memory (in MiB) to allocate to the container group. All
	// containers in the group share this memory. If you specify memory limits for an
	// individual container, the total value must be greater than any individual
	// container's memory limit.
	TotalMemoryLimitMebibytes *int32

	// The maximum amount of vCPU units to allocate to the container group (1 vCPU is
	// equal to 1024 CPU units). All containers in the group share this memory. If you
	// specify vCPU limits for individual containers, the total value must be equal to
	// or greater than the sum of the CPU limits for all containers in the group.
	TotalVcpuLimit *float64

	// A description for this update to the container group definition.
	VersionDescription *string

	noSmithyDocumentSerde
}

type UpdateContainerGroupDefinitionOutput struct {

	// The properties of the updated container group definition version.
	ContainerGroupDefinition *types.ContainerGroupDefinition

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateContainerGroupDefinitionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateContainerGroupDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateContainerGroupDefinition{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateContainerGroupDefinition"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateContainerGroupDefinitionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateContainerGroupDefinition(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateContainerGroupDefinition(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateContainerGroupDefinition",
	}
}
