// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of Amazon GameLift Streams stream sessions that this user
// account has access to.
//
// In the returned list of stream sessions, the ExportFilesMetadata property only
// shows the Status value. To get the OutpurUri and StatusReason values, use [GetStreamSession].
//
// We don't recommend using this operation to regularly check stream session
// statuses because it's costly. Instead, to check status updates for a specific
// stream session, use [GetStreamSession].
//
// [GetStreamSession]: https://docs.aws.amazon.com/gameliftstreams/latest/apireference/API_GetStreamSession.html
func (c *Client) ListStreamSessionsByAccount(ctx context.Context, params *ListStreamSessionsByAccountInput, optFns ...func(*Options)) (*ListStreamSessionsByAccountOutput, error) {
	if params == nil {
		params = &ListStreamSessionsByAccountInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListStreamSessionsByAccount", params, optFns, c.addOperationListStreamSessionsByAccountMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListStreamSessionsByAccountOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListStreamSessionsByAccountInput struct {

	// Filter by the exported files status. You can specify one status in each request
	// to retrieve only sessions that currently have that exported files status.
	ExportFilesStatus types.ExportFilesStatus

	// The number of results to return. Use this parameter with NextToken to return
	// results in sequential pages. Default value is 25 .
	MaxResults *int32

	// The token that marks the start of the next set of results. Use this token when
	// you retrieve results as sequential pages. To get the first page of results, omit
	// a token value. To get the remaining pages, provide the token returned with the
	// previous result set.
	NextToken *string

	// Filter by the stream session status. You can specify one status in each request
	// to retrieve only sessions that are currently in that status.
	Status types.StreamSessionStatus

	noSmithyDocumentSerde
}

type ListStreamSessionsByAccountOutput struct {

	// A collection of Amazon GameLift Streams stream sessions that are associated
	// with a stream group and returned in response to a list request. Each item
	// includes stream session metadata and status.
	Items []types.StreamSessionSummary

	// A token that marks the start of the next sequential page of results. If an
	// operation doesn't return a token, you've reached the end of the list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListStreamSessionsByAccountMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListStreamSessionsByAccount{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListStreamSessionsByAccount{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListStreamSessionsByAccount"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListStreamSessionsByAccount(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListStreamSessionsByAccountPaginatorOptions is the paginator options for
// ListStreamSessionsByAccount
type ListStreamSessionsByAccountPaginatorOptions struct {
	// The number of results to return. Use this parameter with NextToken to return
	// results in sequential pages. Default value is 25 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListStreamSessionsByAccountPaginator is a paginator for
// ListStreamSessionsByAccount
type ListStreamSessionsByAccountPaginator struct {
	options   ListStreamSessionsByAccountPaginatorOptions
	client    ListStreamSessionsByAccountAPIClient
	params    *ListStreamSessionsByAccountInput
	nextToken *string
	firstPage bool
}

// NewListStreamSessionsByAccountPaginator returns a new
// ListStreamSessionsByAccountPaginator
func NewListStreamSessionsByAccountPaginator(client ListStreamSessionsByAccountAPIClient, params *ListStreamSessionsByAccountInput, optFns ...func(*ListStreamSessionsByAccountPaginatorOptions)) *ListStreamSessionsByAccountPaginator {
	if params == nil {
		params = &ListStreamSessionsByAccountInput{}
	}

	options := ListStreamSessionsByAccountPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListStreamSessionsByAccountPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListStreamSessionsByAccountPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListStreamSessionsByAccount page.
func (p *ListStreamSessionsByAccountPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListStreamSessionsByAccountOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListStreamSessionsByAccount(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListStreamSessionsByAccountAPIClient is a client that implements the
// ListStreamSessionsByAccount operation.
type ListStreamSessionsByAccountAPIClient interface {
	ListStreamSessionsByAccount(context.Context, *ListStreamSessionsByAccountInput, ...func(*Options)) (*ListStreamSessionsByAccountOutput, error)
}

var _ ListStreamSessionsByAccountAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListStreamSessionsByAccount(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListStreamSessionsByAccount",
	}
}
