// Code generated by smithy-go-codegen DO NOT EDIT.

package greengrassv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/greengrassv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the pre-signed URL to download a public or a Lambda component artifact.
// Core devices call this operation to identify the URL that they can use to
// download an artifact to install.
func (c *Client) GetComponentVersionArtifact(ctx context.Context, params *GetComponentVersionArtifactInput, optFns ...func(*Options)) (*GetComponentVersionArtifactOutput, error) {
	if params == nil {
		params = &GetComponentVersionArtifactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetComponentVersionArtifact", params, optFns, c.addOperationGetComponentVersionArtifactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetComponentVersionArtifactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetComponentVersionArtifactInput struct {

	// The [ARN] of the component version. Specify the ARN of a public or a Lambda
	// component version.
	//
	// [ARN]: https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html
	//
	// This member is required.
	Arn *string

	// The name of the artifact.
	//
	// You can use the [GetComponent] operation to download the component recipe, which includes the
	// URI of the artifact. The artifact name is the section of the URI after the
	// scheme. For example, in the artifact URI greengrass:SomeArtifact.zip , the
	// artifact name is SomeArtifact.zip .
	//
	// [GetComponent]: https://docs.aws.amazon.com/greengrass/v2/APIReference/API_GetComponent.html
	//
	// This member is required.
	ArtifactName *string

	// Determines if the Amazon S3 URL returned is a FIPS pre-signed URL endpoint.
	// Specify fips if you want the returned Amazon S3 pre-signed URL to point to an
	// Amazon S3 FIPS endpoint. If you don't specify a value, the default is standard .
	IotEndpointType types.IotEndpointType

	// Specifies the endpoint to use when getting Amazon S3 pre-signed URLs.
	//
	// All Amazon Web Services Regions except US East (N. Virginia) use REGIONAL in
	// all cases. In the US East (N. Virginia) Region the default is GLOBAL , but you
	// can change it to REGIONAL with this parameter.
	S3EndpointType types.S3EndpointType

	noSmithyDocumentSerde
}

type GetComponentVersionArtifactOutput struct {

	// The URL of the artifact.
	//
	// This member is required.
	PreSignedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetComponentVersionArtifactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetComponentVersionArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetComponentVersionArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetComponentVersionArtifact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetComponentVersionArtifactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetComponentVersionArtifact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetComponentVersionArtifact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetComponentVersionArtifact",
	}
}
