// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the trusted entity set associated with the specified
// trustedEntitySetId .
func (c *Client) GetTrustedEntitySet(ctx context.Context, params *GetTrustedEntitySetInput, optFns ...func(*Options)) (*GetTrustedEntitySetOutput, error) {
	if params == nil {
		params = &GetTrustedEntitySetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetTrustedEntitySet", params, optFns, c.addOperationGetTrustedEntitySetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetTrustedEntitySetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetTrustedEntitySetInput struct {

	// The unique ID of the GuardDuty detector associated with this trusted entity set.
	//
	// This member is required.
	DetectorId *string

	// The unique ID that helps GuardDuty identify the trusted entity set.
	//
	// This member is required.
	TrustedEntitySetId *string

	noSmithyDocumentSerde
}

type GetTrustedEntitySetOutput struct {

	// The format of the file that contains the trusted entity set.
	//
	// This member is required.
	Format types.TrustedEntitySetFormat

	// The URI of the file that contains the trusted entity set.
	//
	// This member is required.
	Location *string

	// The name of the threat entity set associated with the specified
	// trustedEntitySetId .
	//
	// This member is required.
	Name *string

	// The status of the associated trusted entity set.
	//
	// This member is required.
	Status types.TrustedEntitySetStatus

	// The timestamp when the associated trusted entity set was created.
	CreatedAt *time.Time

	// The error details when the status is shown as ERROR .
	ErrorDetails *string

	// The Amazon Web Services account ID that owns the Amazon S3 bucket specified in
	// the location parameter.
	ExpectedBucketOwner *string

	// The tags associated with trusted entity set resource.
	Tags map[string]string

	// The timestamp when the associated trusted entity set was updated.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetTrustedEntitySetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetTrustedEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetTrustedEntitySet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetTrustedEntitySet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetTrustedEntitySetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetTrustedEntitySet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetTrustedEntitySet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetTrustedEntitySet",
	}
}
