// Code generated by smithy-go-codegen DO NOT EDIT.

package iot

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iot/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all command executions.
//
//   - You must provide only the startedTimeFilter or the completedTimeFilter
//     information. If you provide both time filters, the API will generate an error.
//     You can use this information to retrieve a list of command executions within a
//     specific timeframe.
//
//   - You must provide only the commandArn or the thingArn information depending
//     on whether you want to list executions for a specific command or an IoT thing.
//     If you provide both fields, the API will generate an error.
//
// For more information about considerations for using this API, see [List command executions in your account (CLI)].
//
// [List command executions in your account (CLI)]: https://docs.aws.amazon.com/iot/latest/developerguide/iot-remote-command-execution-start-monitor.html#iot-remote-command-execution-list-cli
func (c *Client) ListCommandExecutions(ctx context.Context, params *ListCommandExecutionsInput, optFns ...func(*Options)) (*ListCommandExecutionsOutput, error) {
	if params == nil {
		params = &ListCommandExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCommandExecutions", params, optFns, c.addOperationListCommandExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCommandExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCommandExecutionsInput struct {

	// The Amazon Resource Number (ARN) of the command. You can use this information
	// to list all command executions for a particular command.
	CommandArn *string

	// List all command executions that completed any time before or after the date
	// and time that you specify. The date and time uses the format yyyy-MM-dd'T'HH:mm .
	CompletedTimeFilter *types.TimeFilter

	// The maximum number of results to return in this operation.
	MaxResults *int32

	// The namespace of the command.
	Namespace types.CommandNamespace

	// To retrieve the next set of results, the nextToken value from a previous
	// response; otherwise null to receive the first set of results.
	NextToken *string

	// Specify whether to list the command executions that were created in the
	// ascending or descending order. By default, the API returns all commands in the
	// descending order based on the start time or completion time of the executions,
	// that are determined by the startTimeFilter and completeTimeFilter parameters.
	SortOrder types.SortOrder

	// List all command executions that started any time before or after the date and
	// time that you specify. The date and time uses the format yyyy-MM-dd'T'HH:mm .
	StartedTimeFilter *types.TimeFilter

	// List all command executions for the device that have a particular status. For
	// example, you can filter the list to display only command executions that have
	// failed or timed out.
	Status types.CommandExecutionStatus

	// The Amazon Resource Number (ARN) of the target device. You can use this
	// information to list all command executions for a particular device.
	TargetArn *string

	noSmithyDocumentSerde
}

type ListCommandExecutionsOutput struct {

	// The list of command executions.
	CommandExecutions []types.CommandExecutionSummary

	// The token to use to get the next set of results, or null if there are no
	// additional results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCommandExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCommandExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCommandExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCommandExecutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCommandExecutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCommandExecutionsPaginatorOptions is the paginator options for
// ListCommandExecutions
type ListCommandExecutionsPaginatorOptions struct {
	// The maximum number of results to return in this operation.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCommandExecutionsPaginator is a paginator for ListCommandExecutions
type ListCommandExecutionsPaginator struct {
	options   ListCommandExecutionsPaginatorOptions
	client    ListCommandExecutionsAPIClient
	params    *ListCommandExecutionsInput
	nextToken *string
	firstPage bool
}

// NewListCommandExecutionsPaginator returns a new ListCommandExecutionsPaginator
func NewListCommandExecutionsPaginator(client ListCommandExecutionsAPIClient, params *ListCommandExecutionsInput, optFns ...func(*ListCommandExecutionsPaginatorOptions)) *ListCommandExecutionsPaginator {
	if params == nil {
		params = &ListCommandExecutionsInput{}
	}

	options := ListCommandExecutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCommandExecutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCommandExecutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCommandExecutions page.
func (p *ListCommandExecutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCommandExecutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCommandExecutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCommandExecutionsAPIClient is a client that implements the
// ListCommandExecutions operation.
type ListCommandExecutionsAPIClient interface {
	ListCommandExecutions(context.Context, *ListCommandExecutionsInput, ...func(*Options)) (*ListCommandExecutionsOutput, error)
}

var _ ListCommandExecutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCommandExecutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCommandExecutions",
	}
}
