// Code generated by smithy-go-codegen DO NOT EDIT.

package iotsitewise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/iotsitewise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an asset model and all of the assets that were created from the model.
// Each asset created from the model inherits the updated asset model's property
// and hierarchy definitions. For more information, see [Updating assets and models]in the IoT SiteWise User
// Guide.
//
// If you remove a property from an asset model, IoT SiteWise deletes all previous
// data for that property. You can’t change the type or data type of an existing
// property.
//
// To replace an existing asset model property with a new one with the same name ,
// do the following:
//
//   - Submit an UpdateAssetModel request with the entire existing property removed.
//
//   - Submit a second UpdateAssetModel request that includes the new property. The
//     new asset property will have the same name as the previous one and IoT
//     SiteWise will generate a new unique id .
//
// [Updating assets and models]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html
func (c *Client) UpdateAssetModel(ctx context.Context, params *UpdateAssetModelInput, optFns ...func(*Options)) (*UpdateAssetModelOutput, error) {
	if params == nil {
		params = &UpdateAssetModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAssetModel", params, optFns, c.addOperationUpdateAssetModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAssetModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAssetModelInput struct {

	// The ID of the asset model to update. This can be either the actual ID in UUID
	// format, or else externalId: followed by the external ID, if it has one. For
	// more information, see [Referencing objects with external IDs]in the IoT SiteWise User Guide.
	//
	// [Referencing objects with external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references
	//
	// This member is required.
	AssetModelId *string

	// A unique name for the asset model.
	//
	// This member is required.
	AssetModelName *string

	// The composite models that are part of this asset model. It groups properties
	// (such as attributes, measurements, transforms, and metrics) and child composite
	// models that model parts of your industrial equipment. Each composite model has a
	// type that defines the properties that the composite model supports. Use
	// composite models to define alarms on this asset model.
	//
	// When creating custom composite models, you need to use [CreateAssetModelCompositeModel]. For more information,
	// see [Creating custom composite models (Components)]in the IoT SiteWise User Guide.
	//
	// [CreateAssetModelCompositeModel]: https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html
	// [Creating custom composite models (Components)]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html
	AssetModelCompositeModels []types.AssetModelCompositeModel

	// A description for the asset model.
	AssetModelDescription *string

	// An external ID to assign to the asset model. The asset model must not already
	// have an external ID. The external ID must be unique within your Amazon Web
	// Services account. For more information, see [Using external IDs]in the IoT SiteWise User Guide.
	//
	// [Using external IDs]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids
	AssetModelExternalId *string

	// The updated hierarchy definitions of the asset model. Each hierarchy specifies
	// an asset model whose assets can be children of any other assets created from
	// this asset model. For more information, see [Asset hierarchies]in the IoT SiteWise User Guide.
	//
	// You can specify up to 10 hierarchies per asset model. For more information, see [Quotas]
	// in the IoT SiteWise User Guide.
	//
	// [Asset hierarchies]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html
	// [Quotas]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html
	AssetModelHierarchies []types.AssetModelHierarchy

	// The updated property definitions of the asset model. For more information, see [Asset properties]
	// in the IoT SiteWise User Guide.
	//
	// You can specify up to 200 properties per asset model. For more information, see [Quotas]
	// in the IoT SiteWise User Guide.
	//
	// [Asset properties]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html
	// [Quotas]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html
	AssetModelProperties []types.AssetModelProperty

	// A unique case-sensitive identifier that you can provide to ensure the
	// idempotency of the request. Don't reuse this client token if a new idempotent
	// request is required.
	ClientToken *string

	// The expected current entity tag (ETag) for the asset model’s latest or active
	// version (specified using matchForVersionType ). The update request is rejected
	// if the tag does not match the latest or active version's current entity tag. See
	// [Optimistic locking for asset model writes]in the IoT SiteWise User Guide.
	//
	// [Optimistic locking for asset model writes]: https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html
	IfMatch *string

	// Accepts * to reject the update request if an active version (specified using
	// matchForVersionType as ACTIVE ) already exists for the asset model.
	IfNoneMatch *string

	// Specifies the asset model version type ( LATEST or ACTIVE ) used in conjunction
	// with If-Match or If-None-Match headers to determine the target ETag for the
	// update operation.
	MatchForVersionType types.AssetModelVersionType

	noSmithyDocumentSerde
}

type UpdateAssetModelOutput struct {

	// The status of the asset model, which contains a state ( UPDATING after
	// successfully calling this operation) and any error message.
	//
	// This member is required.
	AssetModelStatus *types.AssetModelStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAssetModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAssetModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAssetModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAssetModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opUpdateAssetModelMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateAssetModelMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAssetModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAssetModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opUpdateAssetModelMiddleware struct {
}

func (*endpointPrefix_opUpdateAssetModelMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opUpdateAssetModelMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "api." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opUpdateAssetModelMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opUpdateAssetModelMiddleware{}, "ResolveEndpointV2", middleware.After)
}

type idempotencyToken_initializeOpUpdateAssetModel struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateAssetModel) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateAssetModel) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateAssetModelInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateAssetModelInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateAssetModelMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateAssetModel{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateAssetModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAssetModel",
	}
}
