// Code generated by smithy-go-codegen DO NOT EDIT.

package lambda

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/lambda/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of function versions that are configured to use a specific
// capacity provider.
func (c *Client) ListFunctionVersionsByCapacityProvider(ctx context.Context, params *ListFunctionVersionsByCapacityProviderInput, optFns ...func(*Options)) (*ListFunctionVersionsByCapacityProviderOutput, error) {
	if params == nil {
		params = &ListFunctionVersionsByCapacityProviderInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFunctionVersionsByCapacityProvider", params, optFns, c.addOperationListFunctionVersionsByCapacityProviderMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFunctionVersionsByCapacityProviderOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFunctionVersionsByCapacityProviderInput struct {

	// The name of the capacity provider to list function versions for.
	//
	// This member is required.
	CapacityProviderName *string

	// Specify the pagination token that's returned by a previous request to retrieve
	// the next page of results.
	Marker *string

	// The maximum number of function versions to return in the response.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListFunctionVersionsByCapacityProviderOutput struct {

	// The Amazon Resource Name (ARN) of the capacity provider.
	//
	// This member is required.
	CapacityProviderArn *string

	// A list of function versions that use the specified capacity provider.
	//
	// This member is required.
	FunctionVersions []types.FunctionVersionsByCapacityProviderListItem

	// The pagination token that's included if more results are available.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFunctionVersionsByCapacityProviderMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListFunctionVersionsByCapacityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListFunctionVersionsByCapacityProvider{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFunctionVersionsByCapacityProvider"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFunctionVersionsByCapacityProviderValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFunctionVersionsByCapacityProvider(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFunctionVersionsByCapacityProviderPaginatorOptions is the paginator options
// for ListFunctionVersionsByCapacityProvider
type ListFunctionVersionsByCapacityProviderPaginatorOptions struct {
	// The maximum number of function versions to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFunctionVersionsByCapacityProviderPaginator is a paginator for
// ListFunctionVersionsByCapacityProvider
type ListFunctionVersionsByCapacityProviderPaginator struct {
	options   ListFunctionVersionsByCapacityProviderPaginatorOptions
	client    ListFunctionVersionsByCapacityProviderAPIClient
	params    *ListFunctionVersionsByCapacityProviderInput
	nextToken *string
	firstPage bool
}

// NewListFunctionVersionsByCapacityProviderPaginator returns a new
// ListFunctionVersionsByCapacityProviderPaginator
func NewListFunctionVersionsByCapacityProviderPaginator(client ListFunctionVersionsByCapacityProviderAPIClient, params *ListFunctionVersionsByCapacityProviderInput, optFns ...func(*ListFunctionVersionsByCapacityProviderPaginatorOptions)) *ListFunctionVersionsByCapacityProviderPaginator {
	if params == nil {
		params = &ListFunctionVersionsByCapacityProviderInput{}
	}

	options := ListFunctionVersionsByCapacityProviderPaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFunctionVersionsByCapacityProviderPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFunctionVersionsByCapacityProviderPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFunctionVersionsByCapacityProvider page.
func (p *ListFunctionVersionsByCapacityProviderPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFunctionVersionsByCapacityProviderOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFunctionVersionsByCapacityProvider(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFunctionVersionsByCapacityProviderAPIClient is a client that implements the
// ListFunctionVersionsByCapacityProvider operation.
type ListFunctionVersionsByCapacityProviderAPIClient interface {
	ListFunctionVersionsByCapacityProvider(context.Context, *ListFunctionVersionsByCapacityProviderInput, ...func(*Options)) (*ListFunctionVersionsByCapacityProviderOutput, error)
}

var _ ListFunctionVersionsByCapacityProviderAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFunctionVersionsByCapacityProvider(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFunctionVersionsByCapacityProvider",
	}
}
