// Code generated by smithy-go-codegen DO NOT EDIT.

package location

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This operation is no longer current and may be deprecated in the future. We
// recommend upgrading to [GetStyleDescriptor]GetStyleDescriptor unless you require Grab data.
//
//   - GetMapStyleDescriptor is part of a previous Amazon Location Service Maps API
//     (version 1) which has been superseded by a more intuitive, powerful, and
//     complete API (version 2).
//
//   - The version 2 GetStyleDescriptor operation gives a better user experience
//     and is compatible with the remainder of the V2 Maps API.
//
//   - If you are using an AWS SDK or the AWS CLI, note that the Maps API version
//     2 is found under geo-maps or geo_maps , not under location .
//
//   - Since Grab is not yet fully supported in Maps API version 2, we recommend
//     you continue using API version 1 when using Grab .
//
//   - Start your version 2 API journey with the [Maps V2 API Reference]or the [Developer Guide].
//
// Retrieves the map style descriptor from a map resource.
//
// The style descriptor contains speciﬁcations on how features render on a map.
// For example, what data to display, what order to display the data in, and the
// style for the data. Style descriptors follow the Mapbox Style Specification.
//
// [Maps V2 API Reference]: https://docs.aws.amazon.com/location/latest/APIReference/API_Operations_Amazon_Location_Service_Maps_V2.html
// [Developer Guide]: https://docs.aws.amazon.com/location/latest/developerguide/maps.html
// [GetStyleDescriptor]: https://docs.aws.amazon.com/location/latest/APIReference/API_geomaps_GetStyleDescriptor.html
func (c *Client) GetMapStyleDescriptor(ctx context.Context, params *GetMapStyleDescriptorInput, optFns ...func(*Options)) (*GetMapStyleDescriptorOutput, error) {
	if params == nil {
		params = &GetMapStyleDescriptorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMapStyleDescriptor", params, optFns, c.addOperationGetMapStyleDescriptorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMapStyleDescriptorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMapStyleDescriptorInput struct {

	// The map resource to retrieve the style descriptor from.
	//
	// This member is required.
	MapName *string

	// The optional [API key] to authorize the request.
	//
	// [API key]: https://docs.aws.amazon.com/location/previous/developerguide/using-apikeys.html
	Key *string

	noSmithyDocumentSerde
}

type GetMapStyleDescriptorOutput struct {

	// Contains the body of the style descriptor.
	Blob []byte

	// The HTTP Cache-Control directive for the value.
	CacheControl *string

	// The style descriptor's content type. For example, application/json .
	ContentType *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMapStyleDescriptorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMapStyleDescriptor{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMapStyleDescriptor{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMapStyleDescriptor"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetMapStyleDescriptorMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetMapStyleDescriptorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMapStyleDescriptor(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opGetMapStyleDescriptorMiddleware struct {
}

func (*endpointPrefix_opGetMapStyleDescriptorMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetMapStyleDescriptorMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "maps." + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetMapStyleDescriptorMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetMapStyleDescriptorMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opGetMapStyleDescriptor(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMapStyleDescriptor",
	}
}
