// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of router inputs in AWS Elemental MediaConnect.
func (c *Client) ListRouterInputs(ctx context.Context, params *ListRouterInputsInput, optFns ...func(*Options)) (*ListRouterInputsOutput, error) {
	if params == nil {
		params = &ListRouterInputsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRouterInputs", params, optFns, c.addOperationListRouterInputsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRouterInputsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRouterInputsInput struct {

	// The filters to apply when retrieving the list of router inputs.
	Filters []types.RouterInputFilter

	// The maximum number of router inputs to return in the response.
	MaxResults *int32

	// A token used to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRouterInputsOutput struct {

	// The summary information for the retrieved router inputs.
	//
	// This member is required.
	RouterInputs []types.ListedRouterInput

	// The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRouterInputsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRouterInputs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRouterInputs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRouterInputs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRouterInputs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRouterInputsPaginatorOptions is the paginator options for ListRouterInputs
type ListRouterInputsPaginatorOptions struct {
	// The maximum number of router inputs to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRouterInputsPaginator is a paginator for ListRouterInputs
type ListRouterInputsPaginator struct {
	options   ListRouterInputsPaginatorOptions
	client    ListRouterInputsAPIClient
	params    *ListRouterInputsInput
	nextToken *string
	firstPage bool
}

// NewListRouterInputsPaginator returns a new ListRouterInputsPaginator
func NewListRouterInputsPaginator(client ListRouterInputsAPIClient, params *ListRouterInputsInput, optFns ...func(*ListRouterInputsPaginatorOptions)) *ListRouterInputsPaginator {
	if params == nil {
		params = &ListRouterInputsInput{}
	}

	options := ListRouterInputsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRouterInputsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRouterInputsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRouterInputs page.
func (p *ListRouterInputsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRouterInputsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRouterInputs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRouterInputsAPIClient is a client that implements the ListRouterInputs
// operation.
type ListRouterInputsAPIClient interface {
	ListRouterInputs(context.Context, *ListRouterInputsInput, ...func(*Options)) (*ListRouterInputsOutput, error)
}

var _ ListRouterInputsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRouterInputs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRouterInputs",
	}
}
