// Code generated by smithy-go-codegen DO NOT EDIT.

package mediaconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mediaconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of router outputs in AWS Elemental MediaConnect.
func (c *Client) ListRouterOutputs(ctx context.Context, params *ListRouterOutputsInput, optFns ...func(*Options)) (*ListRouterOutputsOutput, error) {
	if params == nil {
		params = &ListRouterOutputsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRouterOutputs", params, optFns, c.addOperationListRouterOutputsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRouterOutputsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRouterOutputsInput struct {

	// The filters to apply when retrieving the list of router outputs.
	Filters []types.RouterOutputFilter

	// The maximum number of router outputs to return in the response.
	MaxResults *int32

	// A token used to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRouterOutputsOutput struct {

	// The summary information for the retrieved router outputs.
	//
	// This member is required.
	RouterOutputs []types.ListedRouterOutput

	// The token to use to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRouterOutputsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRouterOutputs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRouterOutputs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRouterOutputs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRouterOutputs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRouterOutputsPaginatorOptions is the paginator options for ListRouterOutputs
type ListRouterOutputsPaginatorOptions struct {
	// The maximum number of router outputs to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRouterOutputsPaginator is a paginator for ListRouterOutputs
type ListRouterOutputsPaginator struct {
	options   ListRouterOutputsPaginatorOptions
	client    ListRouterOutputsAPIClient
	params    *ListRouterOutputsInput
	nextToken *string
	firstPage bool
}

// NewListRouterOutputsPaginator returns a new ListRouterOutputsPaginator
func NewListRouterOutputsPaginator(client ListRouterOutputsAPIClient, params *ListRouterOutputsInput, optFns ...func(*ListRouterOutputsPaginatorOptions)) *ListRouterOutputsPaginator {
	if params == nil {
		params = &ListRouterOutputsInput{}
	}

	options := ListRouterOutputsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRouterOutputsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRouterOutputsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRouterOutputs page.
func (p *ListRouterOutputsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRouterOutputsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRouterOutputs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRouterOutputsAPIClient is a client that implements the ListRouterOutputs
// operation.
type ListRouterOutputsAPIClient interface {
	ListRouterOutputs(context.Context, *ListRouterOutputsInput, ...func(*Options)) (*ListRouterOutputsOutput, error)
}

var _ ListRouterOutputsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRouterOutputs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRouterOutputs",
	}
}
