// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the alerts for a multiplex with optional filtering based on alert state.
func (c *Client) ListMultiplexAlerts(ctx context.Context, params *ListMultiplexAlertsInput, optFns ...func(*Options)) (*ListMultiplexAlertsOutput, error) {
	if params == nil {
		params = &ListMultiplexAlertsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMultiplexAlerts", params, optFns, c.addOperationListMultiplexAlertsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMultiplexAlertsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Placeholder documentation for ListMultiplexAlertsRequest
type ListMultiplexAlertsInput struct {

	// The unique ID of the multiplex
	//
	// This member is required.
	MultiplexId *string

	// The maximum number of items to return
	MaxResults *int32

	// The next pagination token
	NextToken *string

	// Specifies the set of alerts to return based on their state. SET - Return only
	// alerts with SET state. CLEARED - Return only alerts with CLEARED state. ALL -
	// Return all alerts.
	StateFilter *string

	noSmithyDocumentSerde
}

// Placeholder documentation for ListMultiplexAlertsResponse
type ListMultiplexAlertsOutput struct {

	// The alerts found for this multiplex
	Alerts []types.MultiplexAlert

	// The token to use to retrieve the next page of results
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMultiplexAlertsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMultiplexAlerts{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMultiplexAlerts{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMultiplexAlerts"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListMultiplexAlertsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMultiplexAlerts(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMultiplexAlertsPaginatorOptions is the paginator options for
// ListMultiplexAlerts
type ListMultiplexAlertsPaginatorOptions struct {
	// The maximum number of items to return
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMultiplexAlertsPaginator is a paginator for ListMultiplexAlerts
type ListMultiplexAlertsPaginator struct {
	options   ListMultiplexAlertsPaginatorOptions
	client    ListMultiplexAlertsAPIClient
	params    *ListMultiplexAlertsInput
	nextToken *string
	firstPage bool
}

// NewListMultiplexAlertsPaginator returns a new ListMultiplexAlertsPaginator
func NewListMultiplexAlertsPaginator(client ListMultiplexAlertsAPIClient, params *ListMultiplexAlertsInput, optFns ...func(*ListMultiplexAlertsPaginatorOptions)) *ListMultiplexAlertsPaginator {
	if params == nil {
		params = &ListMultiplexAlertsInput{}
	}

	options := ListMultiplexAlertsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMultiplexAlertsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMultiplexAlertsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMultiplexAlerts page.
func (p *ListMultiplexAlertsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMultiplexAlertsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMultiplexAlerts(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMultiplexAlertsAPIClient is a client that implements the
// ListMultiplexAlerts operation.
type ListMultiplexAlertsAPIClient interface {
	ListMultiplexAlerts(context.Context, *ListMultiplexAlertsInput, ...func(*Options)) (*ListMultiplexAlertsOutput, error)
}

var _ ListMultiplexAlertsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMultiplexAlerts(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMultiplexAlerts",
	}
}
