// Code generated by smithy-go-codegen DO NOT EDIT.

package medialive

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/medialive/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an input.
func (c *Client) UpdateInput(ctx context.Context, params *UpdateInputInput, optFns ...func(*Options)) (*UpdateInputOutput, error) {
	if params == nil {
		params = &UpdateInputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateInput", params, optFns, c.addOperationUpdateInputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateInputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// A request to update an input.
type UpdateInputInput struct {

	// Unique ID of the input.
	//
	// This member is required.
	InputId *string

	// Destination settings for PUSH type inputs.
	Destinations []types.InputDestinationRequest

	// Settings for the devices.
	InputDevices []types.InputDeviceRequest

	// A list of security groups referenced by IDs to attach to the input.
	InputSecurityGroups []string

	// A list of the MediaConnect Flow ARNs that you want to use as the source of the
	// input. You can specify as few as one Flow and presently, as many as two. The
	// only requirement is when you have more than one is that each Flow is in a
	// separate Availability Zone as this ensures your EML input is redundant to AZ
	// issues.
	MediaConnectFlows []types.MediaConnectFlowRequest

	// Multicast Input settings.
	MulticastSettings *types.MulticastSettingsUpdateRequest

	// Name of the input.
	Name *string

	// The Amazon Resource Name (ARN) of the role this input assumes during and after
	// creation.
	RoleArn *string

	// SDI Sources for this Input.
	SdiSources []string

	// Include this parameter if the input is a SMPTE 2110 input, to identify the
	// stream sources for this input.
	Smpte2110ReceiverGroupSettings *types.Smpte2110ReceiverGroupSettings

	// The source URLs for a PULL-type input. Every PULL type input needs exactly two
	// source URLs for redundancy. Only specify sources for PULL type Inputs. Leave
	// Destinations empty.
	Sources []types.InputSourceRequest

	// When using MediaConnect Router as the source of a MediaLive input there's a
	// special handoff that occurs when a router output is created. This group of
	// settings is set on your behalf by the MediaConnect Router service using this set
	// of settings. This setting object can only by used by that service.
	SpecialRouterSettings *types.SpecialRouterSettings

	// The settings associated with an SRT input.
	SrtSettings *types.SrtSettingsRequest

	noSmithyDocumentSerde
}

// Placeholder documentation for UpdateInputResponse
type UpdateInputOutput struct {

	// Placeholder documentation for Input
	Input *types.Input

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateInputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateInput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateInput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateInput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateInputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateInput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateInput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateInput",
	}
}
