// Code generated by smithy-go-codegen DO NOT EDIT.

package mwaaserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/mwaaserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new workflow in Amazon Managed Workflows for Apache Airflow
// Serverless. This operation initializes a workflow with the specified
// configuration including the workflow definition, execution role, and optional
// settings for encryption, logging, and networking. You must provide the workflow
// definition as a YAML file stored in Amazon S3 that defines the DAG structure
// using supported Amazon Web Services operators. Amazon Managed Workflows for
// Apache Airflow Serverless automatically creates the first version of the
// workflow and sets up the necessary execution environment with multi-tenant
// isolation and security controls.
func (c *Client) CreateWorkflow(ctx context.Context, params *CreateWorkflowInput, optFns ...func(*Options)) (*CreateWorkflowOutput, error) {
	if params == nil {
		params = &CreateWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkflow", params, optFns, c.addOperationCreateWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkflowInput struct {

	// The Amazon S3 location where the workflow definition file is stored. This must
	// point to a valid YAML file that defines the workflow structure using supported
	// Amazon Web Services operators and tasks. Amazon Managed Workflows for Apache
	// Airflow Serverless takes a snapshot of the definition at creation time, so
	// subsequent changes to the Amazon S3 object will not affect the workflow unless
	// you create a new version. In your YAML definition, include task dependencies,
	// scheduling information, and operator configurations that are compatible with the
	// Amazon Managed Workflows for Apache Airflow Serverless execution environment.
	//
	// This member is required.
	DefinitionS3Location *types.DefinitionS3Location

	// The name of the workflow. You must use unique workflow names within your Amazon
	// Web Services account. The service generates a unique identifier that is appended
	// to ensure temporal uniqueness across the account lifecycle.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the IAM role that Amazon Managed Workflows
	// for Apache Airflow Serverless assumes when executing the workflow. This role
	// must have the necessary permissions to access the required Amazon Web Services
	// services and resources that your workflow tasks will interact with. The role is
	// used for task execution in the isolated, multi-tenant environment and should
	// follow the principle of least privilege. Amazon Managed Workflows for Apache
	// Airflow Serverless validates role access during workflow creation but runtime
	// permission checks are performed by the target services.
	//
	// This member is required.
	RoleArn *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. This token prevents duplicate workflow creation requests.
	ClientToken *string

	// An optional description of the workflow that you can use to provide additional
	// context about the workflow's purpose and functionality.
	Description *string

	// The configuration for encrypting workflow data at rest and in transit.
	// Specifies the encryption type and optional KMS key for customer-managed
	// encryption.
	EncryptionConfiguration *types.EncryptionConfiguration

	// The version of the Amazon Managed Workflows for Apache Airflow Serverless
	// engine that you want to use for this workflow. This determines the feature set,
	// supported operators, and execution environment capabilities available to your
	// workflow. Amazon Managed Workflows for Apache Airflow Serverless maintains
	// backward compatibility across versions while introducing new features and
	// improvements. Currently supports version 1 with plans for additional versions as
	// the service evolves.
	EngineVersion types.EngineVersion

	// The configuration for workflow logging. Specifies the CloudWatch log group
	// where workflow execution logs are stored. Amazon Managed Workflows for Apache
	// Airflow Serverless automatically exports worker logs and task-level information
	// to the specified log group in your account using remote logging functionality.
	// This provides comprehensive observability for debugging and monitoring workflow
	// execution across the distributed, serverless environment.
	LoggingConfiguration *types.LoggingConfiguration

	// Network configuration for the workflow execution environment, including VPC
	// security groups and subnets for secure network access. When specified, Amazon
	// Managed Workflows for Apache Airflow Serverless deploys ECS worker tasks in your
	// customer VPC to provide secure connectivity to your resources. If not specified,
	// tasks run in the service's default worker VPC with network isolation from other
	// customers. This configuration enables secure access to VPC-only resources like
	// RDS databases or private endpoints.
	NetworkConfiguration *types.NetworkConfiguration

	// A map of tags to assign to the workflow resource. Tags are key-value pairs that
	// are used for resource organization and cost allocation.
	Tags map[string]string

	// The trigger mode for the workflow execution.
	TriggerMode *string

	noSmithyDocumentSerde
}

type CreateWorkflowOutput struct {

	// The Amazon Resource Name (ARN) of the newly created workflow. This ARN uniquely
	// identifies the workflow resource.
	//
	// This member is required.
	WorkflowArn *string

	// The timestamp when the workflow was created, in ISO 8601 date-time format.
	CreatedAt *time.Time

	// A Boolean flag that indicates whether this workflow version is the latest
	// version of the workflow.
	IsLatestVersion *bool

	// A unique identifier for this revision of the workflow configuration. This ID
	// changes when the workflow is updated and you can use it for optimistic
	// concurrency control in update operations. The revision ID helps prevent
	// conflicting updates and ensures that updates are applied to the expected version
	// of the workflow configuration.
	RevisionId *string

	// Warning messages generated during workflow creation.
	Warnings []string

	// The current status of the workflow. Possible values are READY (workflow is
	// ready to run) and DELETING (workflow is being deleted).
	WorkflowStatus types.WorkflowStatus

	// The version identifier of the workflow. This is a service-generated
	// alphanumeric string that uniquely identifies this version of the workflow.
	// Amazon Managed Workflows for Apache Airflow Serverless uses a version-first
	// approach where each workflow can have multiple immutable versions, which allows
	// you to maintain different configurations and roll back to previous versions as
	// needed. The version identifier is used in ARNs and API operations to reference
	// specific workflow versions.
	WorkflowVersion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateWorkflowMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateWorkflow struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateWorkflow) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateWorkflow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateWorkflowInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateWorkflowInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateWorkflowMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateWorkflow{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkflow",
	}
}
