// Code generated by smithy-go-codegen DO NOT EDIT.

package networkmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/networkmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists routing information for a core network, including routes and their
// attributes.
func (c *Client) ListCoreNetworkRoutingInformation(ctx context.Context, params *ListCoreNetworkRoutingInformationInput, optFns ...func(*Options)) (*ListCoreNetworkRoutingInformationOutput, error) {
	if params == nil {
		params = &ListCoreNetworkRoutingInformationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCoreNetworkRoutingInformation", params, optFns, c.addOperationListCoreNetworkRoutingInformationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCoreNetworkRoutingInformationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCoreNetworkRoutingInformationInput struct {

	// The ID of the core network to retrieve routing information for.
	//
	// This member is required.
	CoreNetworkId *string

	// The edge location to filter routing information by.
	//
	// This member is required.
	EdgeLocation *string

	// The name of the segment to filter routing information by.
	//
	// This member is required.
	SegmentName *string

	// BGP community values to match when filtering routing information.
	CommunityMatches []string

	// Exact AS path values to match when filtering routing information.
	ExactAsPathMatches []string

	// Local preference values to match when filtering routing information.
	LocalPreferenceMatches []string

	// The maximum number of routing information entries to return in a single page.
	MaxResults *int32

	// Multi-Exit Discriminator (MED) values to match when filtering routing
	// information.
	MedMatches []string

	// Filters to apply based on next hop information.
	NextHopFilters map[string][]string

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCoreNetworkRoutingInformationOutput struct {

	// The list of routing information for the core network.
	CoreNetworkRoutingInformation []types.CoreNetworkRoutingInformation

	// The token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCoreNetworkRoutingInformationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCoreNetworkRoutingInformation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCoreNetworkRoutingInformation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCoreNetworkRoutingInformation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListCoreNetworkRoutingInformationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCoreNetworkRoutingInformation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListCoreNetworkRoutingInformationPaginatorOptions is the paginator options for
// ListCoreNetworkRoutingInformation
type ListCoreNetworkRoutingInformationPaginatorOptions struct {
	// The maximum number of routing information entries to return in a single page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCoreNetworkRoutingInformationPaginator is a paginator for
// ListCoreNetworkRoutingInformation
type ListCoreNetworkRoutingInformationPaginator struct {
	options   ListCoreNetworkRoutingInformationPaginatorOptions
	client    ListCoreNetworkRoutingInformationAPIClient
	params    *ListCoreNetworkRoutingInformationInput
	nextToken *string
	firstPage bool
}

// NewListCoreNetworkRoutingInformationPaginator returns a new
// ListCoreNetworkRoutingInformationPaginator
func NewListCoreNetworkRoutingInformationPaginator(client ListCoreNetworkRoutingInformationAPIClient, params *ListCoreNetworkRoutingInformationInput, optFns ...func(*ListCoreNetworkRoutingInformationPaginatorOptions)) *ListCoreNetworkRoutingInformationPaginator {
	if params == nil {
		params = &ListCoreNetworkRoutingInformationInput{}
	}

	options := ListCoreNetworkRoutingInformationPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCoreNetworkRoutingInformationPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCoreNetworkRoutingInformationPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCoreNetworkRoutingInformation page.
func (p *ListCoreNetworkRoutingInformationPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCoreNetworkRoutingInformationOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCoreNetworkRoutingInformation(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCoreNetworkRoutingInformationAPIClient is a client that implements the
// ListCoreNetworkRoutingInformation operation.
type ListCoreNetworkRoutingInformationAPIClient interface {
	ListCoreNetworkRoutingInformation(context.Context, *ListCoreNetworkRoutingInformationInput, ...func(*Options)) (*ListCoreNetworkRoutingInformationOutput, error)
}

var _ ListCoreNetworkRoutingInformationAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCoreNetworkRoutingInformation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCoreNetworkRoutingInformation",
	}
}
