// Code generated by smithy-go-codegen DO NOT EDIT.

package notifications

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of organizational units associated with a notification
// configuration.
func (c *Client) ListOrganizationalUnits(ctx context.Context, params *ListOrganizationalUnitsInput, optFns ...func(*Options)) (*ListOrganizationalUnitsOutput, error) {
	if params == nil {
		params = &ListOrganizationalUnitsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListOrganizationalUnits", params, optFns, c.addOperationListOrganizationalUnitsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListOrganizationalUnitsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListOrganizationalUnitsInput struct {

	// The Amazon Resource Name (ARN) of the notification configuration used to filter
	// the organizational units.
	//
	// This member is required.
	NotificationConfigurationArn *string

	// The maximum number of organizational units to return in a single call. Valid
	// values are 1-100.
	MaxResults *int32

	// The token for the next page of results. Use the value returned in the previous
	// response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListOrganizationalUnitsOutput struct {

	// The list of organizational units that match the specified criteria.
	//
	// This member is required.
	OrganizationalUnits []string

	// The token to use for the next page of results. If there are no additional
	// results, this value is null.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListOrganizationalUnitsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListOrganizationalUnits{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListOrganizationalUnits{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListOrganizationalUnits"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListOrganizationalUnitsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListOrganizationalUnits(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListOrganizationalUnitsPaginatorOptions is the paginator options for
// ListOrganizationalUnits
type ListOrganizationalUnitsPaginatorOptions struct {
	// The maximum number of organizational units to return in a single call. Valid
	// values are 1-100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListOrganizationalUnitsPaginator is a paginator for ListOrganizationalUnits
type ListOrganizationalUnitsPaginator struct {
	options   ListOrganizationalUnitsPaginatorOptions
	client    ListOrganizationalUnitsAPIClient
	params    *ListOrganizationalUnitsInput
	nextToken *string
	firstPage bool
}

// NewListOrganizationalUnitsPaginator returns a new
// ListOrganizationalUnitsPaginator
func NewListOrganizationalUnitsPaginator(client ListOrganizationalUnitsAPIClient, params *ListOrganizationalUnitsInput, optFns ...func(*ListOrganizationalUnitsPaginatorOptions)) *ListOrganizationalUnitsPaginator {
	if params == nil {
		params = &ListOrganizationalUnitsInput{}
	}

	options := ListOrganizationalUnitsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListOrganizationalUnitsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListOrganizationalUnitsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListOrganizationalUnits page.
func (p *ListOrganizationalUnitsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListOrganizationalUnitsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListOrganizationalUnits(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListOrganizationalUnitsAPIClient is a client that implements the
// ListOrganizationalUnits operation.
type ListOrganizationalUnitsAPIClient interface {
	ListOrganizationalUnits(context.Context, *ListOrganizationalUnitsInput, ...func(*Options)) (*ListOrganizationalUnitsOutput, error)
}

var _ ListOrganizationalUnitsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListOrganizationalUnits(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListOrganizationalUnits",
	}
}
