// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/novaact/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Error information when an act fails to execute successfully.
type ActError struct {

	// A human-readable description of the error that occurred.
	//
	// This member is required.
	Message *string

	// The type or category of error that occurred.
	Type *string

	noSmithyDocumentSerde
}

// Summary information about an act, including its status and execution timing.
type ActSummary struct {

	// The unique identifier of the act.
	//
	// This member is required.
	ActId *string

	// The unique identifier of the session containing this act.
	//
	// This member is required.
	SessionId *string

	// The timestamp when the act started execution.
	//
	// This member is required.
	StartedAt *time.Time

	// The current execution status of the act.
	//
	// This member is required.
	Status ActStatus

	// The unique identifier of the workflow run containing this act.
	//
	// This member is required.
	WorkflowRunId *string

	// The timestamp when the act completed execution, if applicable.
	EndedAt *time.Time

	// The location where trace information for this act is stored.
	TraceLocation *TraceLocation

	noSmithyDocumentSerde
}

// A request for the client to execute a specific tool with given parameters.
type Call struct {

	// A unique identifier for this tool call, used to match results back to requests.
	//
	// This member is required.
	CallId *string

	// The input parameters for the tool call, formatted according to the tool's
	// schema.
	//
	// This member is required.
	Input document.Interface

	// The name of the tool to invoke, following the pattern 'tool.{toolName}' or
	// 'browser.{browserAction}'.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The result returned from executing a tool call.
type CallResult struct {

	// The content returned by the tool execution, which can include text or other
	// media types.
	//
	// This member is required.
	Content []CallResultContent

	// The identifier of the tool call that this result corresponds to.
	CallId *string

	noSmithyDocumentSerde
}

// Content returned from a tool call execution.
//
// The following types satisfy this interface:
//
//	CallResultContentMemberText
type CallResultContent interface {
	isCallResultContent()
}

// Text content returned from the tool execution.
type CallResultContentMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*CallResultContentMemberText) isCallResultContent() {}

// Information about the client making API requests, used for compatibility
// checking.
type ClientInfo struct {

	// The compatibility version of the client, used to ensure API compatibility.
	//
	// This member is required.
	CompatibilityVersion *int32

	// The version of the SDK being used by the client.
	SdkVersion *string

	noSmithyDocumentSerde
}

// Information about client compatibility and supported model versions.
type CompatibilityInformation struct {

	// The client compatibility version that was requested.
	//
	// This member is required.
	ClientCompatibilityVersion *int32

	// A list of model IDs that are supported for the client compatibility version.
	//
	// This member is required.
	SupportedModelIds []string

	// Additional information about compatibility requirements or recommendations.
	Message *string

	noSmithyDocumentSerde
}

// An alias that provides a stable reference to a model version.
type ModelAlias struct {

	// The name of the model alias.
	//
	// This member is required.
	AliasName *string

	// The model ID that this alias currently points to.
	//
	// This member is required.
	LatestModelId *string

	// The resolved model ID after alias resolution.
	ResolvedModelId *string

	noSmithyDocumentSerde
}

// Lifecycle information for an AI model.
type ModelLifecycle struct {

	// The current lifecycle status of the model.
	//
	// This member is required.
	Status ModelStatus

	noSmithyDocumentSerde
}

// Summary information about an available AI model.
type ModelSummary struct {

	// The minimum client compatibility version required to use this model.
	//
	// This member is required.
	MinimumCompatibilityVersion *int32

	// The unique identifier of the model.
	//
	// This member is required.
	ModelId *string

	// The lifecycle information for the model.
	//
	// This member is required.
	ModelLifecycle *ModelLifecycle

	noSmithyDocumentSerde
}

// Summary information about a session within a workflow run.
type SessionSummary struct {

	// The unique identifier of the session.
	//
	// This member is required.
	SessionId *string

	noSmithyDocumentSerde
}

// The schema definition for tool input parameters.
//
// The following types satisfy this interface:
//
//	ToolInputSchemaMemberJson
type ToolInputSchema interface {
	isToolInputSchema()
}

// The JSON schema that defines the expected input format for the tool.
type ToolInputSchemaMemberJson struct {
	Value document.Interface

	noSmithyDocumentSerde
}

func (*ToolInputSchemaMemberJson) isToolInputSchema() {}

// Specification for a tool that acts can invoke, including its name, description,
// and input schema.
type ToolSpec struct {

	// A description of what the tool does and how it should be used.
	//
	// This member is required.
	Description *string

	// The JSON schema that defines the expected input format for the tool.
	//
	// This member is required.
	InputSchema ToolInputSchema

	// The unique name of the tool that acts will use to invoke it.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about where trace data is stored for debugging and monitoring.
type TraceLocation struct {

	// The specific location where the trace data is stored.
	//
	// This member is required.
	Location *string

	// The type of storage location for the trace data.
	//
	// This member is required.
	LocationType TraceLocationType

	noSmithyDocumentSerde
}

// Information about a field that failed validation.
type ValidationExceptionField struct {

	// A description of the validation error for this field.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Summary information about a workflow definition, used in list operations.
type WorkflowDefinitionSummary struct {

	// The timestamp when the workflow definition was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the workflow definition.
	//
	// This member is required.
	Status WorkflowDefinitionStatus

	// The Amazon Resource Name (ARN) of the workflow definition.
	//
	// This member is required.
	WorkflowDefinitionArn *string

	// The name of the workflow definition.
	//
	// This member is required.
	WorkflowDefinitionName *string

	noSmithyDocumentSerde
}

// Configuration settings for exporting workflow execution data and logs to Amazon
// Simple Storage Service (Amazon S3).
type WorkflowExportConfig struct {

	// The name of your Amazon S3 bucket, that Nova Act uses to export your workflow
	// data. Note that the IAM role used to access Nova Act must also have write
	// permissions to this bucket.
	//
	// This member is required.
	S3BucketName *string

	// An optional prefix for Amazon S3 object keys to organize exported data.
	S3KeyPrefix *string

	noSmithyDocumentSerde
}

// Summary information about a workflow run, including execution status and timing.
type WorkflowRunSummary struct {

	// The timestamp when the workflow run started execution.
	//
	// This member is required.
	StartedAt *time.Time

	// The current execution status of the workflow run.
	//
	// This member is required.
	Status WorkflowRunStatus

	// The Amazon Resource Name (ARN) of the workflow run.
	//
	// This member is required.
	WorkflowRunArn *string

	// The unique identifier of the workflow run.
	//
	// This member is required.
	WorkflowRunId *string

	// The timestamp when the workflow run completed execution, if applicable.
	EndedAt *time.Time

	// The location where trace information for this workflow run is stored.
	TraceLocation *TraceLocation

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCallResultContent() {}
func (*UnknownUnionMember) isToolInputSchema()   {}
