// Code generated by smithy-go-codegen DO NOT EDIT.

package odb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/odb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about unallocated resources in a specified Cloud Exadata
// Infrastructure.
func (c *Client) GetCloudExadataInfrastructureUnallocatedResources(ctx context.Context, params *GetCloudExadataInfrastructureUnallocatedResourcesInput, optFns ...func(*Options)) (*GetCloudExadataInfrastructureUnallocatedResourcesOutput, error) {
	if params == nil {
		params = &GetCloudExadataInfrastructureUnallocatedResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCloudExadataInfrastructureUnallocatedResources", params, optFns, c.addOperationGetCloudExadataInfrastructureUnallocatedResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCloudExadataInfrastructureUnallocatedResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCloudExadataInfrastructureUnallocatedResourcesInput struct {

	// The unique identifier of the Cloud Exadata infrastructure for which to retrieve
	// unallocated resources.
	//
	// This member is required.
	CloudExadataInfrastructureId *string

	// The database servers to include in the unallocated resources query.
	DbServers []string

	noSmithyDocumentSerde
}

type GetCloudExadataInfrastructureUnallocatedResourcesOutput struct {

	// Details about the unallocated resources in the specified Cloud Exadata
	// infrastructure.
	CloudExadataInfrastructureUnallocatedResources *types.CloudExadataInfrastructureUnallocatedResources

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCloudExadataInfrastructureUnallocatedResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetCloudExadataInfrastructureUnallocatedResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetCloudExadataInfrastructureUnallocatedResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCloudExadataInfrastructureUnallocatedResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCloudExadataInfrastructureUnallocatedResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCloudExadataInfrastructureUnallocatedResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCloudExadataInfrastructureUnallocatedResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCloudExadataInfrastructureUnallocatedResources",
	}
}
