// Code generated by smithy-go-codegen DO NOT EDIT.

package organizations

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/organizations/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Sends an invitation to another organization's management account to designate
// your account with the specified responsibilities for their organization. The
// invitation is implemented as a Handshakewhose details are in the response.
//
// You can only call this operation from the management account.
func (c *Client) InviteOrganizationToTransferResponsibility(ctx context.Context, params *InviteOrganizationToTransferResponsibilityInput, optFns ...func(*Options)) (*InviteOrganizationToTransferResponsibilityOutput, error) {
	if params == nil {
		params = &InviteOrganizationToTransferResponsibilityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InviteOrganizationToTransferResponsibility", params, optFns, c.addOperationInviteOrganizationToTransferResponsibilityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InviteOrganizationToTransferResponsibilityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type InviteOrganizationToTransferResponsibilityInput struct {

	// Name you want to assign to the transfer.
	//
	// This member is required.
	SourceName *string

	// Timestamp when the recipient will begin managing the specified responsibilities.
	//
	// This member is required.
	StartTimestamp *time.Time

	// A HandshakeParty object. Contains details for the account you want to invite.
	// Currently, only ACCOUNT and EMAIL are supported.
	//
	// This member is required.
	Target *types.HandshakeParty

	// The type of responsibility you want to designate to your organization.
	// Currently, only BILLING is supported.
	//
	// This member is required.
	Type types.ResponsibilityTransferType

	// Additional information that you want to include in the invitation.
	Notes *string

	// A list of tags that you want to attach to the transfer. For each tag in the
	// list, you must specify both a tag key and a value. You can set the value to an
	// empty string, but you can't set it to null . For more information about tagging,
	// see [Tagging Organizations resources]in the Organizations User Guide.
	//
	// Any tags in the request are checked for compliance with any applicable tag
	// policies when the request is made. The request is rejected if the tags in the
	// request don't match the requirements of the policy at that time. Tag policy
	// compliance is not checked again when the invitation is accepted and the tags are
	// actually attached to the transfer. That means that if the tag policy changes
	// between the invitation and the acceptance, then that tags could potentially be
	// non-compliant.
	//
	// If any one of the tags is not valid or if you exceed the allowed number of tags
	// for a transfer, then the entire request fails and invitations are not sent.
	//
	// [Tagging Organizations resources]: https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html
	Tags []types.Tag

	noSmithyDocumentSerde
}

type InviteOrganizationToTransferResponsibilityOutput struct {

	// Contains details for a handshake. A handshake is the secure exchange of
	// information between two Amazon Web Services accounts: a sender and a recipient.
	//
	// Note: Handshakes that are CANCELED , ACCEPTED , DECLINED , or EXPIRED show up
	// in lists for only 30 days after entering that state After that they are deleted.
	Handshake *types.Handshake

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationInviteOrganizationToTransferResponsibilityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpInviteOrganizationToTransferResponsibility{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpInviteOrganizationToTransferResponsibility{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InviteOrganizationToTransferResponsibility"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpInviteOrganizationToTransferResponsibilityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInviteOrganizationToTransferResponsibility(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInviteOrganizationToTransferResponsibility(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InviteOrganizationToTransferResponsibility",
	}
}
