// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralaccount

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralaccount/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves detailed information about a specific connection invitation.
func (c *Client) GetConnectionInvitation(ctx context.Context, params *GetConnectionInvitationInput, optFns ...func(*Options)) (*GetConnectionInvitationOutput, error) {
	if params == nil {
		params = &GetConnectionInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetConnectionInvitation", params, optFns, c.addOperationGetConnectionInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetConnectionInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetConnectionInvitationInput struct {

	// The catalog identifier where the connection invitation exists.
	//
	// This member is required.
	Catalog *string

	// The unique identifier of the connection invitation to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetConnectionInvitationOutput struct {

	// The Amazon Resource Name (ARN) of the connection invitation.
	//
	// This member is required.
	Arn *string

	// The catalog identifier where the connection invitation exists.
	//
	// This member is required.
	Catalog *string

	// The type of connection being requested in the invitation.
	//
	// This member is required.
	ConnectionType types.ConnectionType

	// The timestamp when the connection invitation was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the connection invitation.
	//
	// This member is required.
	Id *string

	// The custom message included with the connection invitation.
	//
	// This member is required.
	InvitationMessage *string

	// The email address of the person who sent the connection invitation.
	//
	// This member is required.
	InviterEmail *string

	// The name of the person who sent the connection invitation.
	//
	// This member is required.
	InviterName *string

	// The identifier of the other participant in the connection invitation.
	//
	// This member is required.
	OtherParticipantIdentifier *string

	// The type of participant (inviter or invitee) in the connection invitation.
	//
	// This member is required.
	ParticipantType types.ParticipantType

	// The current status of the connection invitation.
	//
	// This member is required.
	Status types.InvitationStatus

	// The timestamp when the connection invitation was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the connection associated with this invitation.
	ConnectionId *string

	// The timestamp when the connection invitation will expire.
	ExpiresAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetConnectionInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetConnectionInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetConnectionInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetConnectionInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetConnectionInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetConnectionInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetConnectionInvitation",
	}
}
