// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains details about an accepted channel handshake.
type AcceptChannelHandshakeDetail struct {

	// The Amazon Resource Name (ARN) of the accepted handshake.
	Arn *string

	// The unique identifier of the accepted handshake.
	Id *string

	// The current status of the accepted handshake.
	Status HandshakeStatus

	noSmithyDocumentSerde
}

// Contains details about a canceled channel handshake.
type CancelChannelHandshakeDetail struct {

	// The Amazon Resource Name (ARN) of the canceled handshake.
	Arn *string

	// The unique identifier of the canceled handshake.
	Id *string

	// The current status of the canceled handshake.
	Status HandshakeStatus

	noSmithyDocumentSerde
}

// Contains the payload data for different types of channel handshakes.
//
// The following types satisfy this interface:
//
//	ChannelHandshakePayloadMemberRevokeServicePeriodPayload
//	ChannelHandshakePayloadMemberStartServicePeriodPayload
type ChannelHandshakePayload interface {
	isChannelHandshakePayload()
}

// Payload for revoking a service period handshake.
type ChannelHandshakePayloadMemberRevokeServicePeriodPayload struct {
	Value RevokeServicePeriodPayload

	noSmithyDocumentSerde
}

func (*ChannelHandshakePayloadMemberRevokeServicePeriodPayload) isChannelHandshakePayload() {}

// Payload for starting a service period handshake.
type ChannelHandshakePayloadMemberStartServicePeriodPayload struct {
	Value StartServicePeriodPayload

	noSmithyDocumentSerde
}

func (*ChannelHandshakePayloadMemberStartServicePeriodPayload) isChannelHandshakePayload() {}

// Summary information about a channel handshake.
type ChannelHandshakeSummary struct {

	// The Amazon Resource Name (ARN) of the handshake.
	Arn *string

	// The identifier of the resource associated with the handshake.
	AssociatedResourceId *string

	// The catalog identifier associated with the handshake.
	Catalog *string

	// The timestamp when the handshake was created.
	CreatedAt *time.Time

	// Detailed information about the handshake.
	Detail HandshakeDetail

	// The type of the handshake.
	HandshakeType HandshakeType

	// The unique identifier of the handshake.
	Id *string

	// The AWS account ID of the handshake owner.
	OwnerAccountId *string

	// The AWS account ID of the handshake receiver.
	ReceiverAccountId *string

	// The AWS account ID of the handshake sender.
	SenderAccountId *string

	// The display name of the handshake sender.
	SenderDisplayName *string

	// The current status of the handshake.
	Status HandshakeStatus

	// The timestamp when the handshake was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains details about a newly created channel handshake.
type CreateChannelHandshakeDetail struct {

	// The Amazon Resource Name (ARN) of the created handshake.
	Arn *string

	// The unique identifier of the created handshake.
	Id *string

	noSmithyDocumentSerde
}

// Contains details about a newly created program management account.
type CreateProgramManagementAccountDetail struct {

	// The Amazon Resource Name (ARN) of the created program management account.
	Arn *string

	// The unique identifier of the created program management account.
	Id *string

	noSmithyDocumentSerde
}

// Contains details about a newly created relationship.
type CreateRelationshipDetail struct {

	// The Amazon Resource Name (ARN) of the created relationship.
	Arn *string

	// The unique identifier of the created relationship.
	Id *string

	noSmithyDocumentSerde
}

// Contains detailed information about different types of handshakes.
//
// The following types satisfy this interface:
//
//	HandshakeDetailMemberProgramManagementAccountHandshakeDetail
//	HandshakeDetailMemberRevokeServicePeriodHandshakeDetail
//	HandshakeDetailMemberStartServicePeriodHandshakeDetail
type HandshakeDetail interface {
	isHandshakeDetail()
}

// Details for a program management account handshake.
type HandshakeDetailMemberProgramManagementAccountHandshakeDetail struct {
	Value ProgramManagementAccountHandshakeDetail

	noSmithyDocumentSerde
}

func (*HandshakeDetailMemberProgramManagementAccountHandshakeDetail) isHandshakeDetail() {}

// Details for a revoke service period handshake.
type HandshakeDetailMemberRevokeServicePeriodHandshakeDetail struct {
	Value RevokeServicePeriodHandshakeDetail

	noSmithyDocumentSerde
}

func (*HandshakeDetailMemberRevokeServicePeriodHandshakeDetail) isHandshakeDetail() {}

// Details for a start service period handshake.
type HandshakeDetailMemberStartServicePeriodHandshakeDetail struct {
	Value StartServicePeriodHandshakeDetail

	noSmithyDocumentSerde
}

func (*HandshakeDetailMemberStartServicePeriodHandshakeDetail) isHandshakeDetail() {}

// Type-specific filters for listing channel handshakes.
//
// The following types satisfy this interface:
//
//	ListChannelHandshakesTypeFiltersMemberProgramManagementAccountTypeFilters
//	ListChannelHandshakesTypeFiltersMemberRevokeServicePeriodTypeFilters
//	ListChannelHandshakesTypeFiltersMemberStartServicePeriodTypeFilters
type ListChannelHandshakesTypeFilters interface {
	isListChannelHandshakesTypeFilters()
}

// Filters specific to program management account handshakes.
type ListChannelHandshakesTypeFiltersMemberProgramManagementAccountTypeFilters struct {
	Value ProgramManagementAccountTypeFilters

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeFiltersMemberProgramManagementAccountTypeFilters) isListChannelHandshakesTypeFilters() {
}

// Filters specific to revoke service period handshakes.
type ListChannelHandshakesTypeFiltersMemberRevokeServicePeriodTypeFilters struct {
	Value RevokeServicePeriodTypeFilters

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeFiltersMemberRevokeServicePeriodTypeFilters) isListChannelHandshakesTypeFilters() {
}

// Filters specific to start service period handshakes.
type ListChannelHandshakesTypeFiltersMemberStartServicePeriodTypeFilters struct {
	Value StartServicePeriodTypeFilters

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeFiltersMemberStartServicePeriodTypeFilters) isListChannelHandshakesTypeFilters() {
}

// Type-specific sorting options for listing channel handshakes.
//
// The following types satisfy this interface:
//
//	ListChannelHandshakesTypeSortMemberProgramManagementAccountTypeSort
//	ListChannelHandshakesTypeSortMemberRevokeServicePeriodTypeSort
//	ListChannelHandshakesTypeSortMemberStartServicePeriodTypeSort
type ListChannelHandshakesTypeSort interface {
	isListChannelHandshakesTypeSort()
}

// Sorting options specific to program management account handshakes.
type ListChannelHandshakesTypeSortMemberProgramManagementAccountTypeSort struct {
	Value ProgramManagementAccountTypeSort

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeSortMemberProgramManagementAccountTypeSort) isListChannelHandshakesTypeSort() {
}

// Sorting options specific to revoke service period handshakes.
type ListChannelHandshakesTypeSortMemberRevokeServicePeriodTypeSort struct {
	Value RevokeServicePeriodTypeSort

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeSortMemberRevokeServicePeriodTypeSort) isListChannelHandshakesTypeSort() {
}

// Sorting options specific to start service period handshakes.
type ListChannelHandshakesTypeSortMemberStartServicePeriodTypeSort struct {
	Value StartServicePeriodTypeSort

	noSmithyDocumentSerde
}

func (*ListChannelHandshakesTypeSortMemberStartServicePeriodTypeSort) isListChannelHandshakesTypeSort() {
}

// Base sorting configuration for program management accounts.
type ListProgramManagementAccountsSortBase struct {

	// The field to sort by.
	//
	// This member is required.
	SortBy ListProgramManagementAccountsSortName

	// The sort order (ascending or descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Base sorting configuration for relationships.
type ListRelationshipsSortBase struct {

	// The field to sort by.
	//
	// This member is required.
	SortBy ListRelationshipsSortName

	// The sort order (ascending or descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Configuration for partner-led support plans.
type PartnerLedSupport struct {

	// The coverage level for partner-led support.
	//
	// This member is required.
	Coverage Coverage

	// The location of the Technical Account Manager (TAM).
	//
	// This member is required.
	TamLocation *string

	// The provider of the partner-led support.
	Provider Provider

	noSmithyDocumentSerde
}

// Details specific to program management account handshakes.
type ProgramManagementAccountHandshakeDetail struct {

	// The program associated with the handshake.
	Program Program

	noSmithyDocumentSerde
}

// Summary information about a program management account.
type ProgramManagementAccountSummary struct {

	// The AWS account ID associated with the program management account.
	AccountId *string

	// The Amazon Resource Name (ARN) of the program management account.
	Arn *string

	// The catalog identifier associated with the account.
	Catalog *string

	// The timestamp when the account was created.
	CreatedAt *time.Time

	// The display name of the program management account.
	DisplayName *string

	// The unique identifier of the program management account.
	Id *string

	// The program type for the management account.
	Program Program

	// The current revision number of the program management account.
	Revision *string

	// The start date of the program management account.
	StartDate *time.Time

	// The current status of the program management account.
	Status ProgramManagementAccountStatus

	// The timestamp when the account was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Type-specific filters for program management accounts.
type ProgramManagementAccountTypeFilters struct {

	// Filter by program types.
	Programs []Program

	noSmithyDocumentSerde
}

// Type-specific sorting options for program management accounts.
type ProgramManagementAccountTypeSort struct {

	// The field to sort by.
	//
	// This member is required.
	SortBy ProgramManagementAccountTypeSortName

	// The sort order (ascending or descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Contains details about a rejected channel handshake.
type RejectChannelHandshakeDetail struct {

	// The Amazon Resource Name (ARN) of the rejected handshake.
	Arn *string

	// The unique identifier of the rejected handshake.
	Id *string

	// The current status of the rejected handshake.
	Status HandshakeStatus

	noSmithyDocumentSerde
}

// Detailed information about a partner relationship.
type RelationshipDetail struct {

	// The Amazon Resource Name (ARN) of the relationship.
	Arn *string

	// The AWS account ID associated in this relationship.
	AssociatedAccountId *string

	// The type of association for the relationship.
	AssociationType AssociationType

	// The catalog identifier associated with the relationship.
	Catalog *string

	// The timestamp when the relationship was created.
	CreatedAt *time.Time

	// The display name of the relationship.
	DisplayName *string

	// The unique identifier of the relationship.
	Id *string

	// The identifier of the program management account.
	ProgramManagementAccountId *string

	// The resale account model for the relationship.
	ResaleAccountModel ResaleAccountModel

	// The current revision number of the relationship.
	Revision *string

	// The business sector for the relationship.
	Sector Sector

	// The start date of the relationship.
	StartDate *time.Time

	// The timestamp when the relationship was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary information about a partner relationship.
type RelationshipSummary struct {

	// The Amazon Resource Name (ARN) of the relationship.
	Arn *string

	// The AWS account ID associated in this relationship.
	AssociatedAccountId *string

	// The type of association for the relationship.
	AssociationType AssociationType

	// The catalog identifier associated with the relationship.
	Catalog *string

	// The timestamp when the relationship was created.
	CreatedAt *time.Time

	// The display name of the relationship.
	DisplayName *string

	// The unique identifier of the relationship.
	Id *string

	// The identifier of the program management account.
	ProgramManagementAccountId *string

	// The current revision number of the relationship.
	Revision *string

	// The business sector for the relationship.
	Sector Sector

	// The start date of the relationship.
	StartDate *time.Time

	// The timestamp when the relationship was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Configuration for resold business support plans.
type ResoldBusiness struct {

	// The coverage level for resold business support.
	//
	// This member is required.
	Coverage Coverage

	noSmithyDocumentSerde
}

// Configuration for resold enterprise support plans.
type ResoldEnterprise struct {

	// The coverage level for resold enterprise support.
	//
	// This member is required.
	Coverage Coverage

	// The location of the Technical Account Manager (TAM).
	//
	// This member is required.
	TamLocation *string

	// The AWS account ID to charge for the support plan.
	ChargeAccountId *string

	noSmithyDocumentSerde
}

// Details specific to revoke service period handshakes.
type RevokeServicePeriodHandshakeDetail struct {

	// The end date of the service period being revoked.
	EndDate *time.Time

	// The minimum number of days notice required for revocation.
	MinimumNoticeDays *string

	// A note explaining the reason for revoking the service period.
	Note *string

	// The type of service period being revoked.
	ServicePeriodType ServicePeriodType

	// The start date of the service period being revoked.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Payload for revoke service period handshake requests.
type RevokeServicePeriodPayload struct {

	// The identifier of the program management account.
	//
	// This member is required.
	ProgramManagementAccountIdentifier *string

	// A note explaining the reason for revoking the service period.
	Note *string

	noSmithyDocumentSerde
}

// Filters specific to revoke service period handshakes.
type RevokeServicePeriodTypeFilters struct {

	// Filter by service period types.
	ServicePeriodTypes []ServicePeriodType

	noSmithyDocumentSerde
}

// Sorting options specific to revoke service period handshakes.
type RevokeServicePeriodTypeSort struct {

	// The field to sort by.
	//
	// This member is required.
	SortBy RevokeServicePeriodTypeSortName

	// The sort order (ascending or descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Details specific to start service period handshakes.
type StartServicePeriodHandshakeDetail struct {

	// The end date of the service period.
	EndDate *time.Time

	// The minimum number of days notice required for changes.
	MinimumNoticeDays *string

	// A note providing additional information about the service period.
	Note *string

	// The type of service period being started.
	ServicePeriodType ServicePeriodType

	// The start date of the service period.
	StartDate *time.Time

	noSmithyDocumentSerde
}

// Payload for start service period handshake requests.
type StartServicePeriodPayload struct {

	// The identifier of the program management account.
	//
	// This member is required.
	ProgramManagementAccountIdentifier *string

	// The type of service period being started.
	//
	// This member is required.
	ServicePeriodType ServicePeriodType

	// The end date of the service period.
	EndDate *time.Time

	// The minimum number of days notice required for changes.
	MinimumNoticeDays *string

	// A note providing additional information about the service period.
	Note *string

	noSmithyDocumentSerde
}

// Filters specific to start service period handshakes.
type StartServicePeriodTypeFilters struct {

	// Filter by service period types.
	ServicePeriodTypes []ServicePeriodType

	noSmithyDocumentSerde
}

// Sorting options specific to start service period handshakes.
type StartServicePeriodTypeSort struct {

	// The field to sort by.
	//
	// This member is required.
	SortBy StartServicePeriodTypeSortName

	// The sort order (ascending or descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Configuration for different types of support plans.
//
// The following types satisfy this interface:
//
//	SupportPlanMemberPartnerLedSupport
//	SupportPlanMemberResoldBusiness
//	SupportPlanMemberResoldEnterprise
type SupportPlan interface {
	isSupportPlan()
}

// Configuration for partner-led support plans.
type SupportPlanMemberPartnerLedSupport struct {
	Value PartnerLedSupport

	noSmithyDocumentSerde
}

func (*SupportPlanMemberPartnerLedSupport) isSupportPlan() {}

// Configuration for resold business support plans.
type SupportPlanMemberResoldBusiness struct {
	Value ResoldBusiness

	noSmithyDocumentSerde
}

func (*SupportPlanMemberResoldBusiness) isSupportPlan() {}

// Configuration for resold enterprise support plans.
type SupportPlanMemberResoldEnterprise struct {
	Value ResoldEnterprise

	noSmithyDocumentSerde
}

func (*SupportPlanMemberResoldEnterprise) isSupportPlan() {}

// A key-value pair that can be associated with a resource.
type Tag struct {

	// The key of the tag.
	//
	// This member is required.
	Key *string

	// The value of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Contains details about an updated program management account.
type UpdateProgramManagementAccountDetail struct {

	// The Amazon Resource Name (ARN) of the updated program management account.
	Arn *string

	// The updated display name of the program management account.
	DisplayName *string

	// The unique identifier of the updated program management account.
	Id *string

	// The new revision number of the program management account.
	Revision *string

	noSmithyDocumentSerde
}

// Contains details about an updated relationship.
type UpdateRelationshipDetail struct {

	// The Amazon Resource Name (ARN) of the updated relationship.
	Arn *string

	// The updated display name of the relationship.
	DisplayName *string

	// The unique identifier of the updated relationship.
	Id *string

	// The new revision number of the relationship.
	Revision *string

	noSmithyDocumentSerde
}

// Information about a field that failed validation.
type ValidationExceptionField struct {

	// The validation error code for the field.
	//
	// This member is required.
	Code *string

	// A descriptive message about the validation error.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isChannelHandshakePayload()          {}
func (*UnknownUnionMember) isHandshakeDetail()                  {}
func (*UnknownUnionMember) isListChannelHandshakesTypeFilters() {}
func (*UnknownUnionMember) isListChannelHandshakesTypeSort()    {}
func (*UnknownUnionMember) isSupportPlan()                      {}
