// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of Partner Solutions that the partner registered on Partner
// Central. This API is used to generate a list of solutions that an end user
// selects from for association with an opportunity.
func (c *Client) ListSolutions(ctx context.Context, params *ListSolutionsInput, optFns ...func(*Options)) (*ListSolutionsOutput, error) {
	if params == nil {
		params = &ListSolutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSolutions", params, optFns, c.addOperationListSolutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSolutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSolutionsInput struct {

	// Specifies the catalog associated with the request. This field takes a string
	// value from a predefined list: AWS or Sandbox . The catalog determines which
	// environment the solutions are listed in. Use AWS to list solutions in the
	// Amazon Web Services catalog, and Sandbox to list solutions in a secure and
	// isolated testing environment.
	//
	// This member is required.
	Catalog *string

	// Filters the solutions based on the category to which they belong. This allows
	// partners to search for solutions within specific categories, such as Software ,
	// Consulting , or Managed Services .
	Category []string

	// Filters the solutions based on their unique identifier. Use this filter to
	// retrieve specific solutions by providing the solution's identifier for accurate
	// results.
	Identifier []string

	// The maximum number of results returned by a single call. This value must be
	// provided in the next call to retrieve the next set of results.
	//
	// Default: 20
	MaxResults *int32

	// A pagination token used to retrieve the next set of results in subsequent
	// calls. This token is included in the response only if there are additional
	// result pages available.
	NextToken *string

	// Object that configures sorting done on the response. Default Sort.SortBy is
	// Identifier .
	Sort *types.SolutionSort

	// Filters solutions based on their status. This filter helps partners manage
	// their solution portfolios effectively.
	Status []types.SolutionStatus

	noSmithyDocumentSerde
}

type ListSolutionsOutput struct {

	// An array with minimal details for solutions matching the request criteria.
	//
	// This member is required.
	SolutionSummaries []types.SolutionBase

	// A pagination token used to retrieve the next set of results in subsequent
	// calls. This token is included in the response only if there are additional
	// result pages available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSolutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListSolutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListSolutions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListSolutions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListSolutionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSolutions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSolutionsPaginatorOptions is the paginator options for ListSolutions
type ListSolutionsPaginatorOptions struct {
	// The maximum number of results returned by a single call. This value must be
	// provided in the next call to retrieve the next set of results.
	//
	// Default: 20
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSolutionsPaginator is a paginator for ListSolutions
type ListSolutionsPaginator struct {
	options   ListSolutionsPaginatorOptions
	client    ListSolutionsAPIClient
	params    *ListSolutionsInput
	nextToken *string
	firstPage bool
}

// NewListSolutionsPaginator returns a new ListSolutionsPaginator
func NewListSolutionsPaginator(client ListSolutionsAPIClient, params *ListSolutionsInput, optFns ...func(*ListSolutionsPaginatorOptions)) *ListSolutionsPaginator {
	if params == nil {
		params = &ListSolutionsInput{}
	}

	options := ListSolutionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSolutionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSolutionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSolutions page.
func (p *ListSolutionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSolutionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListSolutions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListSolutionsAPIClient is a client that implements the ListSolutions operation.
type ListSolutionsAPIClient interface {
	ListSolutions(context.Context, *ListSolutionsInput, ...func(*Options)) (*ListSolutionsOutput, error)
}

var _ ListSolutionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListSolutions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListSolutions",
	}
}
