// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the Customer 's account details associated with the Opportunity .
type Account struct {

	// Specifies the end Customer 's company name associated with the Opportunity .
	//
	// This member is required.
	CompanyName *string

	// Specifies the end Customer 's address details associated with the Opportunity .
	Address *Address

	// Specifies the Customer Amazon Web Services account ID associated with the
	// Opportunity .
	AwsAccountId *string

	// Indicates the Customer DUNS number, if available.
	Duns *string

	// Specifies the industry the end Customer belongs to that's associated with the
	// Opportunity . It refers to the category or sector where the customer's business
	// operates. This is a required field.
	Industry Industry

	// Specifies the end Customer 's industry associated with the Opportunity , when
	// the selected value in the Industry field is Other .
	OtherIndustry *string

	// Specifies the end customer's company website URL associated with the Opportunity
	// . This value is crucial to map the customer within the Amazon Web Services CRM
	// system. This field is required in all cases except when the opportunity is
	// related to national security.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Contains the account details of the partner who received the Engagement
// Invitation, including the AWS account ID and company name.
type AccountReceiver struct {

	// Indicates the AWS account ID of the partner who received the Engagement
	// Invitation. This is a unique identifier for managing engagements with specific
	// AWS accounts.
	//
	// This member is required.
	AwsAccountId *string

	// Represents the alias of the partner account receiving the Engagement
	// Invitation, making it easier to identify and track the recipient in reports or
	// logs.
	Alias *string

	noSmithyDocumentSerde
}

// An object that contains an Account 's subset of fields.
type AccountSummary struct {

	// Specifies the end Customer 's company name associated with the Opportunity .
	//
	// This member is required.
	CompanyName *string

	// Specifies the end Customer 's address details associated with the Opportunity .
	Address *AddressSummary

	// Specifies which industry the end Customer belongs to associated with the
	// Opportunity . It refers to the category or sector that the customer's business
	// operates in.
	//
	// To submit a value outside the picklist, use Other .
	//
	// Conditionally mandatory if Other is selected for Industry Vertical in LOVs.
	Industry Industry

	// Specifies the end Customer 's industry associated with the  Opportunity , when
	// the selected value in the Industry field is Other . This field is relevant when
	// the customer's industry doesn't fall under the predefined picklist values and
	// requires a custom description.
	OtherIndustry *string

	// Specifies the end customer's company website URL associated with the Opportunity
	// . This value is crucial to map the customer within the Amazon Web Services CRM
	// system.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Specifies the end Customer 's address details associated with the Opportunity .
type Address struct {

	// Specifies the end Customer 's city associated with the Opportunity .
	City *string

	// Specifies the end Customer 's country associated with the Opportunity .
	CountryCode CountryCode

	// Specifies the end Customer 's postal code associated with the Opportunity .
	PostalCode *string

	// Specifies the end Customer 's state or region associated with the Opportunity .
	//
	// Valid values: Alabama | Alaska | American Samoa | Arizona | Arkansas |
	// California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated
	// States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois |
	// Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands |
	// Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri |
	// Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York
	// | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma |
	// Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina |
	// South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands |
	// Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP
	StateOrRegion *string

	// Specifies the end Customer 's street address associated with the Opportunity .
	StreetAddress *string

	noSmithyDocumentSerde
}

// An object that contains an Address object's subset of fields.
type AddressSummary struct {

	// Specifies the end Customer 's city associated with the Opportunity .
	City *string

	// Specifies the end Customer 's country associated with the Opportunity .
	CountryCode CountryCode

	// Specifies the end Customer 's postal code associated with the Opportunity .
	PostalCode *string

	// Specifies the end Customer 's state or region associated with the Opportunity .
	//
	// Valid values: Alabama | Alaska | American Samoa | Arizona | Arkansas |
	// California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated
	// States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois |
	// Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands |
	// Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri |
	// Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York
	// | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma |
	// Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina |
	// South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands |
	// Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP
	StateOrRegion *string

	noSmithyDocumentSerde
}

// Represents the contact details of the individual assigned to manage the
// opportunity within the partner organization. This helps to ensure that there is
// a point of contact for the opportunity's progress.
type AssigneeContact struct {

	// Specifies the business title of the assignee managing the opportunity. This
	// helps clarify the individual's role and responsibilities within the
	// organization. Use the value PartnerAccountManager to update details of the
	// opportunity owner.
	//
	// This member is required.
	BusinessTitle *string

	// Provides the email address of the assignee. This email is used for
	// communications and notifications related to the opportunity.
	//
	// This member is required.
	Email *string

	// Specifies the first name of the assignee managing the opportunity. The system
	// automatically retrieves this value from the user profile by referencing the
	// associated email address.
	//
	// This member is required.
	FirstName *string

	// Specifies the last name of the assignee managing the opportunity. The system
	// automatically retrieves this value from the user profile by referencing the
	// associated email address.
	//
	// This member is required.
	LastName *string

	// Specifies the contact phone number of the assignee responsible for the
	// opportunity or engagement. This field enables direct communication for
	// time-sensitive matters and facilitates coordination between AWS and partner
	// teams.
	Phone *string

	noSmithyDocumentSerde
}

// Represents the customer associated with the AWS opportunity. This field
// captures key details about the customer that are necessary for managing the
// opportunity.
type AwsOpportunityCustomer struct {

	// Provides a list of customer contacts involved in the opportunity. These
	// contacts may include decision makers, influencers, and other stakeholders within
	// the customer's organization.
	Contacts []Contact

	noSmithyDocumentSerde
}

// Contains insights provided by AWS for the opportunity, offering recommendations
// and analysis that can help the partner optimize their engagement and strategy.
type AwsOpportunityInsights struct {

	// Represents a score assigned by AWS to indicate the level of engagement and
	// potential success for the opportunity. This score helps partners prioritize
	// their efforts.
	EngagementScore EngagementScore

	// Provides recommendations from AWS on the next best actions to take in order to
	// move the opportunity forward and increase the likelihood of success.
	NextBestActions *string

	noSmithyDocumentSerde
}

// Tracks the lifecycle of the AWS opportunity, including stages such as
// qualification, validation, and closure. This field helps partners understand the
// current status and progression of the opportunity.
type AwsOpportunityLifeCycle struct {

	// Indicates the reason why an opportunity was marked as Closed Lost . This helps
	// in understanding the context behind the lost opportunity and aids in refining
	// future strategies.
	ClosedLostReason AwsClosedLostReason

	// Specifies the immediate next steps required to progress the opportunity. These
	// steps are based on AWS guidance and the current stage of the opportunity.
	NextSteps *string

	// Provides a historical log of previous next steps that were taken to move the
	// opportunity forward. This helps in tracking the decision-making process and
	// identifying any delays or obstacles encountered.
	NextStepsHistory []ProfileNextStepsHistory

	// Represents the current stage of the opportunity in its lifecycle, such as
	// Qualification , Validation , or Closed Won . This helps in understanding the
	// opportunity's progress.
	Stage AwsOpportunityStage

	// Indicates the expected date by which the opportunity is projected to close.
	// This field helps in planning resources and timelines for both the partner and
	// AWS.
	TargetCloseDate *string

	noSmithyDocumentSerde
}

// Captures details about the project associated with the opportunity, including
// objectives, scope, and customer requirements.
type AwsOpportunityProject struct {

	// Indicates the expected spending by the customer over the course of the project.
	// This value helps partners and AWS estimate the financial impact of the
	// opportunity. Use the [AWS Pricing Calculator]to create an estimate of the customer’s total spend. If
	// only annual recurring revenue (ARR) is available, distribute it across 12 months
	// to provide an average monthly value.
	//
	// [AWS Pricing Calculator]: https://calculator.aws/#/
	ExpectedCustomerSpend []ExpectedCustomerSpend

	noSmithyDocumentSerde
}

// Represents other entities related to the AWS opportunity, such as AWS products,
// partner solutions, and marketplace offers. These associations help build a
// complete picture of the solution being sold.
type AwsOpportunityRelatedEntities struct {

	// Specifies the AWS products associated with the opportunity. This field helps
	// track the specific products that are part of the proposed solution.
	AwsProducts []string

	// Specifies the partner solutions related to the opportunity. These solutions
	// represent the partner's offerings that are being positioned as part of the
	// overall AWS opportunity.
	Solutions []string

	noSmithyDocumentSerde
}

// Indicates the level of AWS involvement in the opportunity. This field helps
// track AWS participation throughout the engagement, such as providing technical
// support, deal assistance, and sales support.
type AwsSubmission struct {

	// Specifies the type of AWS involvement in the opportunity, such as coselling,
	// deal support, or technical consultation. This helps categorize the nature of AWS
	// participation.
	//
	// This member is required.
	InvolvementType SalesInvolvementType

	// Determines who can view AWS involvement in the opportunity. Typically, this
	// field is set to Full for most cases, but it may be restricted based on special
	// program requirements or confidentiality needs.
	Visibility Visibility

	noSmithyDocumentSerde
}

// Represents an Amazon Web Services team member for the engagement. This
// structure includes details such as name, email, and business title.
type AwsTeamMember struct {

	// Specifies the Amazon Web Services team member's business title and indicates
	// their organizational role.
	BusinessTitle AwsMemberBusinessTitle

	// Provides the Amazon Web Services team member's email address.
	Email *string

	// Provides the Amazon Web Services team member's first name.
	FirstName *string

	// Provides the Amazon Web Services team member's last name.
	LastName *string

	noSmithyDocumentSerde
}

// An object that contains a Customer Partner 's contact details.
type Contact struct {

	// The partner contact's title (job title or role) associated with the Opportunity
	// . BusinessTitle supports either PartnerAccountManager or OpportunityOwner .
	BusinessTitle *string

	// The contact's email address associated with the Opportunity .
	Email *string

	// The contact's first name associated with the Opportunity .
	FirstName *string

	// The contact's last name associated with the Opportunity .
	LastName *string

	// The contact's phone number associated with the Opportunity .
	Phone *string

	noSmithyDocumentSerde
}

// An object that contains the customer's Account and Contact .
type Customer struct {

	// An object that contains the customer's account details.
	Account *Account

	// Represents the contact details for individuals associated with the customer of
	// the Opportunity . This field captures relevant contacts, including
	// decision-makers, influencers, and technical stakeholders within the customer
	// organization. These contacts are key to progressing the opportunity.
	Contacts []Contact

	noSmithyDocumentSerde
}

// The CustomerProjects structure in Engagements offers a flexible framework for
// managing customer-project relationships. It supports multiple customers per
// Engagement and multiple projects per customer, while also allowing for customers
// without projects and projects without specific customers.
//
// All Engagement members have full visibility of customers and their associated
// projects, enabling the capture of relevant context even when project details are
// not fully defined. This structure also facilitates targeted invitations,
// allowing partners to focus on specific customers and their business problems
// when sending Engagement invitations.
type CustomerProjectsContext struct {

	// Contains details about the customer associated with the Engagement Invitation,
	// including company information and industry.
	Customer *EngagementCustomer

	// Information about the customer project associated with the Engagement.
	Project *EngagementCustomerProjectDetails

	noSmithyDocumentSerde
}

// An object that contains a Customer object's subset of fields.
type CustomerSummary struct {

	// An object that contains a customer's account details.
	Account *AccountSummary

	noSmithyDocumentSerde
}

// Provides detailed context information for an Engagement. This structure allows
// for specifying the type of context and its associated payload.
type EngagementContextDetails struct {

	// Specifies the type of Engagement context. Valid values are "CustomerProject" or
	// "Document", indicating whether the context relates to a customer project or a
	// document respectively.
	//
	// This member is required.
	Type EngagementContextType

	// The unique identifier of the engagement context. This ID is used to reference
	// and manage the specific context within the engagement.
	Id *string

	// Contains the specific details of the Engagement context. The structure of this
	// payload varies depending on the Type field.
	Payload EngagementContextPayload

	noSmithyDocumentSerde
}

// Represents the payload of an Engagement context. The structure of this payload
// varies based on the context type specified in the EngagementContextDetails.
//
// The following types satisfy this interface:
//
//	EngagementContextPayloadMemberCustomerProject
//	EngagementContextPayloadMemberLead
type EngagementContextPayload interface {
	isEngagementContextPayload()
}

// Contains detailed information about a customer project when the context type is
// "CustomerProject". This field is present only when the Type in
// EngagementContextDetails is set to "CustomerProject".
type EngagementContextPayloadMemberCustomerProject struct {
	Value CustomerProjectsContext

	noSmithyDocumentSerde
}

func (*EngagementContextPayloadMemberCustomerProject) isEngagementContextPayload() {}

// Contains detailed information about a lead when the context type is "Lead".
// This field is present only when the Type in EngagementContextDetails is set to
// "Lead".
type EngagementContextPayloadMemberLead struct {
	Value LeadContext

	noSmithyDocumentSerde
}

func (*EngagementContextPayloadMemberLead) isEngagementContextPayload() {}

// Contains details about the customer associated with the Engagement Invitation,
// including company information and industry.
type EngagementCustomer struct {

	// Represents the name of the customer’s company associated with the Engagement
	// Invitation. This field is used to identify the customer.
	//
	// This member is required.
	CompanyName *string

	// Indicates the country in which the customer’s company operates. This field is
	// useful for understanding regional requirements or compliance needs.
	//
	// This member is required.
	CountryCode CountryCode

	// Specifies the industry to which the customer’s company belongs. This field
	// helps categorize the opportunity based on the customer’s business sector.
	//
	// This member is required.
	Industry Industry

	// Provides the website URL of the customer’s company. This field helps partners
	// verify the legitimacy and size of the customer organization.
	//
	// This member is required.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Provides comprehensive details about a customer project associated with an
// Engagement. This may include information such as project goals, timelines, and
// specific customer requirements.
type EngagementCustomerProjectDetails struct {

	// A description of the business problem the project aims to solve.
	//
	// This member is required.
	BusinessProblem *string

	// The target completion date for the customer's project.
	//
	// This member is required.
	TargetCompletionDate *string

	// The title of the project.
	//
	// This member is required.
	Title *string

	noSmithyDocumentSerde
}

// Provides a summarized view of the Engagement Invitation, including details like
// the identifier, status, and sender. This summary helps partners track and manage
// AWS originated opportunities.
type EngagementInvitationSummary struct {

	// Specifies the catalog in which the Engagement Invitation resides. This can be
	// either the AWS or Sandbox catalog, indicating whether the opportunity is live
	// or being tested.
	//
	// This member is required.
	Catalog *string

	// Represents the unique identifier of the Engagement Invitation. This identifier
	// is used to track the invitation and to manage responses like acceptance or
	// rejection.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the Engagement Invitation. The ARN is a
	// unique identifier that allows partners to reference the invitation in their
	// system and manage its lifecycle.
	Arn *string

	//  The identifier of the Engagement associated with this invitation. This links
	// the invitation to its parent Engagement.
	EngagementId *string

	// Provides a short title or description of the Engagement Invitation. This title
	// helps partners quickly identify and differentiate between multiple engagement
	// opportunities.
	EngagementTitle *string

	// Indicates the date and time when the Engagement Invitation will expire. After
	// this date, the invitation can no longer be accepted, and the opportunity will be
	// unavailable to the partner.
	ExpirationDate *time.Time

	// Indicates the date when the Engagement Invitation was sent to the partner. This
	// provides context for when the opportunity was shared and helps in tracking the
	// timeline for engagement.
	InvitationDate *time.Time

	// Identifies the role of the caller in the engagement invitation.
	ParticipantType ParticipantType

	// Describes the type of payload associated with the Engagement Invitation, such
	// as Opportunity or MarketplaceOffer . This helps partners understand the nature
	// of the engagement request from AWS.
	PayloadType EngagementInvitationPayloadType

	// Specifies the partner company or individual that received the Engagement
	// Invitation. This field is important for tracking who the invitation was sent to
	// within the partner organization.
	Receiver Receiver

	// Specifies the AWS account ID of the sender who initiated the Engagement
	// Invitation. This allows the partner to identify the AWS entity or representative
	// responsible for sharing the opportunity.
	SenderAwsAccountId *string

	// Indicates the name of the company or AWS division that sent the Engagement
	// Invitation. This information is useful for partners to know which part of AWS is
	// requesting engagement.
	SenderCompanyName *string

	// Represents the current status of the Engagement Invitation, such as Pending ,
	// Accepted , or Rejected . The status helps track the progress and response to the
	// invitation.
	Status InvitationStatus

	noSmithyDocumentSerde
}

// Engagement members are the participants in an Engagement, which is likely a
// collaborative project or business opportunity within the AWS partner network.
// Members can be different partner organizations or AWS accounts that are working
// together on a specific engagement.
//
// Each member is represented by their AWS Account ID, Company Name, and
// associated details. Members have a status within the Engagement (PENDING,
// ACCEPTED, REJECTED, or WITHDRAWN), indicating their current state of
// participation. Only existing members of an Engagement can view the list of other
// members. This implies a level of privacy and access control within the
// Engagement structure.
type EngagementMember struct {

	// This is the unique identifier for the AWS account associated with the member
	// organization. It's used for AWS-related operations and identity verification.
	AccountId *string

	// The official name of the member's company or organization.
	CompanyName *string

	// The URL of the member company's website. This offers a way to find more
	// information about the member organization and serves as an additional
	// identifier.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// The EngagementMemberSummary provides a snapshot of essential information about
// participants in an AWS Partner Central Engagement. This compact data structure
// encapsulates key details of each member, facilitating efficient collaboration
// and management within the Engagement.
type EngagementMemberSummary struct {

	// The official name of the member's company or organization.
	CompanyName *string

	// The URL of the member company's website. This offers a way to find more
	// information about the member organization and serves as an additional
	// identifier.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

//	This provide a streamlined view of the relationships between engagements and
//
// resources. These summaries offer a crucial link between collaborative
// engagements and the specific resources involved, such as opportunities.These
// summaries are particularly valuable for partners navigating complex engagements
// with multiple resources. They enable quick insights into resource distribution
// across engagements, support efficient resource management, and help maintain a
// clear overview of collaborative activities.
type EngagementResourceAssociationSummary struct {

	//  Indicates the environment in which the resource and engagement exist.
	//
	// This member is required.
	Catalog *string

	// The AWS account ID of the entity that owns the resource. Identifies the account
	// responsible for or having primary control over the resource.
	CreatedBy *string

	//  A unique identifier for the engagement associated with the resource.
	EngagementId *string

	//  A unique identifier for the specific resource. Varies depending on the
	// resource type.
	ResourceId *string

	//  Categorizes the type of resource associated with the engagement.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Specifies the sorting parameters for listing Engagements.
type EngagementSort struct {

	// The field by which to sort the results.
	//
	// This member is required.
	SortBy EngagementSortName

	// The order in which to sort the results.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An object that contains an Engagement 's subset of fields.
type EngagementSummary struct {

	// The Amazon Resource Name (ARN) of the created Engagement.
	Arn *string

	// An array of context types associated with the engagement, such as
	// "CustomerProject" or "Lead". This provides a quick overview of the types of
	// contexts included in the engagement.
	ContextTypes []EngagementContextType

	// The date and time when the Engagement was created.
	CreatedAt *time.Time

	// The AWS Account ID of the Engagement creator.
	CreatedBy *string

	// The unique identifier for the Engagement.
	Id *string

	// The number of members in the Engagement.
	MemberCount *int32

	// The timestamp indicating when the engagement was last modified, in ISO 8601
	// format (UTC). Example: "2023-05-01T20:37:46Z".
	ModifiedAt *time.Time

	// The AWS account ID of the user who last modified the engagement. This field
	// helps track who made the most recent changes to the engagement.
	ModifiedBy *string

	// The title of the Engagement.
	Title *string

	noSmithyDocumentSerde
}

// Provides an estimate of the revenue that the partner is expected to generate
// from the opportunity. This information helps partners assess the financial value
// of the project.
type ExpectedCustomerSpend struct {

	// Represents the estimated monthly revenue that the partner expects to earn from
	// the opportunity. This helps in forecasting financial returns.
	//
	// This member is required.
	Amount *string

	// Indicates the currency in which the revenue estimate is provided. This helps in
	// understanding the financial impact across different markets.
	//
	// This member is required.
	CurrencyCode CurrencyCode

	// Indicates how frequently the customer is expected to spend the projected
	// amount. Only the value Monthly is allowed for the Frequency field, representing
	// recurring monthly spend.
	//
	// This member is required.
	Frequency PaymentFrequency

	// Specifies the name of the partner company that is expected to generate revenue
	// from the opportunity. This field helps track the partner’s involvement in the
	// opportunity. This field only accepts the value AWS . If any other value is
	// provided, the system will automatically set it to AWS .
	//
	// This member is required.
	TargetCompany *string

	// A URL providing additional information or context about the spend estimation.
	EstimationUrl *string

	noSmithyDocumentSerde
}

//	The Invitation structure represents an invitation exchanged between partners
//
// and AWS. It includes a message, receiver information, and a payload providing
// context for the invitation.
type Invitation struct {

	//  A message accompanying the invitation.
	//
	// This member is required.
	Message *string

	// Contains the data payload associated with the Engagement Invitation. This
	// payload includes essential details related to the AWS opportunity and is used by
	// partners to evaluate whether to accept or reject the engagement.
	//
	// This member is required.
	Payload Payload

	// Represents the entity that received the Engagement Invitation, including
	// account and company details. This field is essential for tracking the partner
	// who is being invited to collaborate.
	//
	// This member is required.
	Receiver Receiver

	noSmithyDocumentSerde
}

// Defines a filter to retrieve opportunities based on the last modified date.
// This filter is useful for tracking changes or updates to opportunities over
// time.
type LastModifiedDate struct {

	// Specifies the date after which the opportunities were modified. Use this filter
	// to retrieve only those opportunities that were modified after a given timestamp.
	AfterLastModifiedDate *time.Time

	// Specifies the date before which the opportunities were modified. Use this
	// filter to retrieve only those opportunities that were modified before a given
	// timestamp.
	BeforeLastModifiedDate *time.Time

	noSmithyDocumentSerde
}

// An object that contains a lead contact's details associated with the
// engagement. This provides contact information for individuals involved in
// lead-related activities.
type LeadContact struct {

	// The lead contact's business title or job role associated with the engagement.
	//
	// This member is required.
	BusinessTitle *string

	// The lead contact's email address associated with the engagement.
	//
	// This member is required.
	Email *string

	// The lead contact's first name associated with the engagement.
	//
	// This member is required.
	FirstName *string

	// The lead contact's last name associated with the engagement.
	//
	// This member is required.
	LastName *string

	// The lead contact's phone number associated with the engagement.
	Phone *string

	noSmithyDocumentSerde
}

// Provides comprehensive details about a lead associated with an engagement. This
// structure contains information about lead qualification status, customer
// details, and interaction history to facilitate lead management and tracking
// within the engagement.
type LeadContext struct {

	// Contains detailed information about the customer associated with the lead,
	// including company information, contact details, and other relevant customer
	// data.
	//
	// This member is required.
	Customer *LeadCustomer

	// An array of interactions that have occurred with the lead, providing a history
	// of communications, meetings, and other engagement activities related to the
	// lead.
	//
	// This member is required.
	Interactions []LeadInteraction

	// Indicates the current qualification status of the lead, such as whether it has
	// been qualified, disqualified, or is still under evaluation. This helps track the
	// lead's progression through the qualification process.
	QualificationStatus *string

	noSmithyDocumentSerde
}

// Contains detailed information about the customer associated with the lead,
// including company details, industry classification, and AWS maturity level. This
// information helps qualify and categorize the lead for appropriate engagement
// strategies.
type LeadCustomer struct {

	// An object that contains an Address object's subset of fields.
	//
	// This member is required.
	Address *AddressSummary

	// The name of the lead customer's company. This field is essential for
	// identifying and tracking the customer organization associated with the lead.
	//
	// This member is required.
	CompanyName *string

	// Indicates the customer's level of experience and adoption with AWS services.
	// This assessment helps determine the appropriate engagement approach and solution
	// complexity.
	AwsMaturity *string

	// Specifies the industry sector to which the lead customer's company belongs.
	// This categorization helps in understanding the customer's business context and
	// tailoring appropriate solutions.
	Industry Industry

	// Specifies the market segment classification of the lead customer, such as
	// enterprise, mid-market, or small business. This segmentation helps in targeting
	// appropriate solutions and engagement strategies.
	MarketSegment MarketSegment

	// The website URL of the lead customer's company. This provides additional
	// context about the customer organization and helps verify company legitimacy and
	// size.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Represents a specific interaction or touchpoint with a lead customer. This
// structure captures details about communications, meetings, or other engagement
// activities that help track the lead's progression and engagement history.
type LeadInteraction struct {

	// Contains contact information for the customer representative involved in the
	// lead interaction, including their name, title, and contact details.
	//
	// This member is required.
	Contact *LeadContact

	// Describes the action taken by the customer during or as a result of the
	// interaction, such as requesting information, scheduling a meeting, or expressing
	// interest in a solution.
	//
	// This member is required.
	CustomerAction *string

	// The unique identifier of the specific source that generated the lead
	// interaction. This ID provides traceability back to the original lead generation
	// activity.
	//
	// This member is required.
	SourceId *string

	// The descriptive name of the source that generated the lead interaction,
	// providing a human-readable identifier for the lead generation channel or
	// activity.
	//
	// This member is required.
	SourceName *string

	// Specifies the type of source that generated the lead interaction, such as
	// "Event", "Website", "Referral", or "Campaign". This categorization helps track
	// lead generation effectiveness across different channels.
	//
	// This member is required.
	SourceType *string

	// Describes the business problem or challenge that the customer discussed during
	// the interaction. This information helps qualify the lead and identify
	// appropriate solutions.
	BusinessProblem *string

	// The date and time when the lead interaction occurred, in ISO 8601 format (UTC).
	// This timestamp helps track the chronology of lead engagement activities.
	InteractionDate *time.Time

	// Describes the specific use case or business scenario discussed during the lead
	// interaction. This helps categorize the customer's interests and potential
	// solutions.
	Usecase *string

	noSmithyDocumentSerde
}

// Contains customer information included in a lead invitation payload. This
// structure provides essential details about the customer to help partners
// evaluate the lead opportunity and determine their interest in engagement.
type LeadInvitationCustomer struct {

	// The name of the customer company associated with the lead invitation. This
	// field identifies the target organization for the lead engagement opportunity.
	//
	// This member is required.
	CompanyName *string

	// The country code indicating the geographic location of the customer company.
	// This information helps partners understand regional requirements and assess
	// their ability to serve the customer effectively.
	//
	// This member is required.
	CountryCode CountryCode

	// Indicates the customer's level of experience and adoption with AWS services.
	// This assessment helps partners understand the customer's cloud maturity and
	// tailor their engagement approach accordingly.
	AwsMaturity *string

	// Specifies the industry sector of the customer company associated with the lead
	// invitation. This categorization helps partners understand the customer's
	// business context and assess solution fit.
	Industry Industry

	// Specifies the market segment classification of the customer, such as
	// enterprise, mid-market, or small business. This segmentation helps partners
	// determine the appropriate solution complexity and engagement strategy.
	MarketSegment MarketSegment

	// The website URL of the customer company. This provides additional context about
	// the customer organization and helps partners verify company details and assess
	// business size and legitimacy.
	WebsiteUrl *string

	noSmithyDocumentSerde
}

// Represents interaction details included in a lead invitation payload. This
// structure provides context about how the lead was generated and the customer's
// engagement history to help partners assess the opportunity quality.
type LeadInvitationInteraction struct {

	// The business title or job role of the customer contact involved in the lead
	// interaction. This helps partners identify the decision-making level and
	// engagement approach for the lead.
	//
	// This member is required.
	ContactBusinessTitle *string

	// The unique identifier of the specific source that generated the lead
	// interaction. This provides traceability to the original lead generation activity
	// for reference and follow-up purposes.
	//
	// This member is required.
	SourceId *string

	// The descriptive name of the source that generated the lead interaction. This
	// human-readable identifier helps partners understand the specific lead generation
	// channel or campaign that created the opportunity.
	//
	// This member is required.
	SourceName *string

	// Specifies the type of source that generated the lead interaction, such as
	// "Event", "Website", or "Campaign". This helps partners understand the lead
	// generation channel and assess lead quality based on the source type.
	//
	// This member is required.
	SourceType *string

	// Describes the specific use case or business scenario associated with the lead
	// interaction. This information helps partners understand the customer's interests
	// and potential solution requirements.
	Usecase *string

	noSmithyDocumentSerde
}

// Represents the data payload of an engagement invitation for a lead opportunity.
// This contains detailed information about the customer and interaction history
// that partners use to evaluate whether to accept the lead engagement invitation.
type LeadInvitationPayload struct {

	// Contains information about the customer associated with the lead invitation.
	// This data helps partners understand the customer's profile, industry, and
	// business context to assess the lead opportunity.
	//
	// This member is required.
	Customer *LeadInvitationCustomer

	// Describes the interaction details associated with the lead, including the
	// source of the lead generation and customer engagement information. This context
	// helps partners evaluate the lead quality and engagement approach.
	//
	// This member is required.
	Interaction *LeadInvitationInteraction

	noSmithyDocumentSerde
}

// An object that contains the Opportunity lifecycle's details.
type LifeCycle struct {

	// Specifies the reason code when an opportunity is marked as Closed Lost. When
	// you select an appropriate reason code, you communicate the context for closing
	// the Opportunity , and aid in accurate reports and analysis of opportunity
	// outcomes. The possible values are:
	//
	//   - Customer Deficiency: The customer lacked necessary resources or
	//   capabilities.
	//
	//   - Delay/Cancellation of Project: The project was delayed or canceled.
	//
	//   - Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
	//
	//   - Lost to Competitor—Google: The opportunity was lost to Google.
	//
	//   - Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
	//
	//   - Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
	//
	//   - Lost to Competitor—VMWare: The opportunity was lost to VMWare.
	//
	//   - Lost to Competitor—Other: The opportunity was lost to a competitor not
	//   listed above.
	//
	//   - No Opportunity: There was no opportunity to pursue.
	//
	//   - On Premises Deployment: The customer chose an on-premises solution.
	//
	//   - Partner Gap: The partner lacked necessary resources or capabilities.
	//
	//   - Price: The price was not competitive or acceptable to the customer.
	//
	//   - Security/Compliance: Security or compliance issues prevented progress.
	//
	//   - Technical Limitations: Technical limitations prevented progress.
	//
	//   - Customer Experience: Issues related to the customer's experience impacted
	//   the decision.
	//
	//   - Other: Any reason not covered by the other values.
	//
	//   - People/Relationship/Governance: Issues related to people, relationships, or
	//   governance.
	//
	//   - Product/Technology: Issues related to the product or technology.
	//
	//   - Financial/Commercial: Financial or commercial issues impacted the decision.
	ClosedLostReason ClosedLostReason

	// Specifies the upcoming actions or tasks for the Opportunity . Use this field to
	// communicate with Amazon Web Services about the next actions required for the
	// Opportunity .
	NextSteps *string

	// Captures a chronological record of the next steps or actions planned or taken
	// for the current opportunity, along with the timestamp.
	NextStepsHistory []NextStepsHistory

	// Contains detailed feedback from Amazon Web Services when requesting additional
	// information from partners. Provides specific guidance on what partners need to
	// provide or clarify for opportunity validation, complementing the
	// ReviewStatusReason field.
	ReviewComments *string

	// Indicates the review status of an opportunity referred by a partner. This field
	// is read-only and only applicable for partner referrals. The possible values are:
	//
	//   - Pending Submission: Not submitted for validation (editable).
	//
	//   - Submitted: Submitted for validation, and Amazon Web Services hasn't
	//   reviewed it (read-only).
	//
	//   - In Review: Amazon Web Services is validating (read-only).
	//
	//   - Action Required: Issues that Amazon Web Services highlights need to be
	//   addressed. Partners should use the UpdateOpportunity API action to update the
	//   opportunity and helps to ensure that all required changes are made. Only the
	//   following fields are editable when the Lifecycle.ReviewStatus is Action
	//   Required :
	//
	//   - Customer.Account.Address.City
	//
	//   - Customer.Account.Address.CountryCode
	//
	//   - Customer.Account.Address.PostalCode
	//
	//   - Customer.Account.Address.StateOrRegion
	//
	//   - Customer.Account.Address.StreetAddress
	//
	//   - Customer.Account.WebsiteUrl
	//
	//   - LifeCycle.TargetCloseDate
	//
	//   - Project.ExpectedMonthlyAWSRevenue.Amount
	//
	//   - Project.ExpectedMonthlyAWSRevenue.CurrencyCode
	//
	//   - Project.CustomerBusinessProblem
	//
	//   - PartnerOpportunityIdentifier
	//
	// After updates, the opportunity re-enters the validation phase. This process
	//   repeats until all issues are resolved, and the opportunity's
	//   Lifecycle.ReviewStatus is set to Approved or Rejected .
	//
	//   - Approved: Validated and converted into the Amazon Web Services seller's
	//   pipeline (editable).
	//
	//   - Rejected: Disqualified (read-only).
	ReviewStatus ReviewStatus

	// Code indicating the validation decision during the Amazon Web Services
	// opportunity review. Applies when status is Rejected or Action Required . Used to
	// document validation results for AWS Partner Referrals and indicate when
	// additional information is needed from partners as part of the APN Customer
	// Engagement (ACE) program.
	ReviewStatusReason *string

	// Specifies the current stage of the Opportunity 's lifecycle as it maps to Amazon
	// Web Services stages from the current stage in the partner CRM. This field
	// provides a translated value of the stage, and offers insight into the
	// Opportunity 's progression in the sales cycle, according to Amazon Web Services
	// definitions.
	//
	// A lead and a prospect must be further matured to a Qualified opportunity before
	// submission. Opportunities that were closed/lost before submission aren't
	// suitable for submission.
	//
	// The descriptions of each sales stage are:
	//
	//   - Prospect: Amazon Web Services identifies the opportunity. It can be active
	//   (Comes directly from the end customer through a lead) or latent (Your account
	//   team believes it exists based on research, account plans, sales plays).
	//
	//   - Qualified: Your account team engaged with the customer to discuss viability
	//   and requirements. The customer agreed that the opportunity is real, of interest,
	//   and may solve business/technical needs.
	//
	//   - Technical Validation: All parties understand the implementation plan.
	//
	//   - Business Validation: Pricing was proposed, and all parties agree to the
	//   steps to close.
	//
	//   - Committed: The customer signed the contract, but Amazon Web Services hasn't
	//   started billing.
	//
	//   - Launched: The workload is complete, and Amazon Web Services has started
	//   billing.
	//
	//   - Closed Lost: The opportunity is lost, and there are no steps to move
	//   forward.
	Stage Stage

	// Specifies the date when Amazon Web Services expects to start significant
	// billing, when the project finishes, and when it moves into production. This
	// field informs the Amazon Web Services seller about when the opportunity launches
	// and starts to incur Amazon Web Services usage.
	//
	// Ensure the Target Close Date isn't in the past.
	TargetCloseDate *string

	noSmithyDocumentSerde
}

//	Provides the lifecycle view of an opportunity resource shared through a
//
// snapshot.
type LifeCycleForView struct {

	//  Describes the next steps for the opportunity shared through a snapshot.
	NextSteps *string

	//  Defines the approval status of the opportunity shared through a snapshot.
	ReviewStatus ReviewStatus

	//  Defines the current stage of the opportunity shared through a snapshot.
	Stage Stage

	//  The projected launch date of the opportunity shared through a snapshot.
	TargetCloseDate *string

	noSmithyDocumentSerde
}

// An object that contains a LifeCycle object's subset of fields.
type LifeCycleSummary struct {

	// Specifies the reason code when an opportunity is marked as Closed Lost. When
	// you select an appropriate reason code, you communicate the context for closing
	// the Opportunity , and aid in accurate reports and analysis of opportunity
	// outcomes.
	ClosedLostReason ClosedLostReason

	// Specifies the upcoming actions or tasks for the Opportunity . This field is
	// utilized to communicate to Amazon Web Services the next actions required for the
	// Opportunity .
	NextSteps *string

	// Indicates why an opportunity was sent back for further details. Partners must
	// take corrective action based on the ReviewComments .
	ReviewComments *string

	// Indicates the review status of a partner referred opportunity. This field is
	// read-only and only applicable for partner referrals. Valid values:
	//
	//   - Pending Submission: Not submitted for validation (editable).
	//
	//   - Submitted: Submitted for validation and not yet Amazon Web Services
	//   reviewed (read-only).
	//
	//   - In Review: Undergoing Amazon Web Services validation (read-only).
	//
	//   - Action Required: Address any issues Amazon Web Services highlights. Use the
	//   UpdateOpportunity API action to update the opportunity, and ensure you make
	//   all required changes. Only these fields are editable when the
	//   Lifecycle.ReviewStatus is Action Required :
	//
	//   - Customer.Account.Address.City
	//
	//   - Customer.Account.Address.CountryCode
	//
	//   - Customer.Account.Address.PostalCode
	//
	//   - Customer.Account.Address.StateOrRegion
	//
	//   - Customer.Account.Address.StreetAddress
	//
	//   - Customer.Account.WebsiteUrl
	//
	//   - LifeCycle.TargetCloseDate
	//
	//   - Project.ExpectedCustomerSpend.Amount
	//
	//   - Project.ExpectedCustomerSpend.CurrencyCode
	//
	//   - Project.CustomerBusinessProblem
	//
	//   - PartnerOpportunityIdentifier
	//
	// After updates, the opportunity re-enters the validation phase. This process
	//   repeats until all issues are resolved, and the opportunity's
	//   Lifecycle.ReviewStatus is set to Approved or Rejected .
	//
	//   - Approved: Validated and converted into the Amazon Web Services seller's
	//   pipeline (editable).
	//
	//   - Rejected: Disqualified (read-only).
	ReviewStatus ReviewStatus

	// Indicates the reason a specific decision was taken during the opportunity
	// review process. This field combines the reasons for both disqualified and action
	// required statuses, and provides clarity for why an opportunity was disqualified
	// or required further action.
	ReviewStatusReason *string

	// Specifies the current stage of the Opportunity 's lifecycle as it maps to Amazon
	// Web Services stages from the current stage in the partner CRM. This field
	// provides a translated value of the stage, and offers insight into the
	// Opportunity 's progression in the sales cycle, according to Amazon Web Services
	// definitions.
	//
	// A lead and a prospect must be further matured to a Qualified opportunity before
	// submission. Opportunities that were closed/lost before submission aren't
	// suitable for submission.
	//
	// The descriptions of each sales stage are:
	//
	//   - Prospect: Amazon Web Services identifies the opportunity. It can be active
	//   (Comes directly from the end customer through a lead) or latent (Your account
	//   team believes it exists based on research, account plans, sales plays).
	//
	//   - Qualified: Your account team engaged with the customer to discuss viability
	//   and understand requirements. The customer agreed that the opportunity is real,
	//   of interest, and may solve business/technical needs.
	//
	//   - Technical Validation: All parties understand the implementation plan.
	//
	//   - Business Validation: Pricing was proposed, and all parties agree to the
	//   steps to close.
	//
	//   - Committed: The customer signed the contract, but Amazon Web Services hasn't
	//   started billing.
	//
	//   - Launched: The workload is complete, and Amazon Web Services has started
	//   billing.
	//
	//   - Closed Lost: The opportunity is lost, and there are no steps to move
	//   forward.
	Stage Stage

	// Specifies the date when Amazon Web Services expects to start significant
	// billing, when the project finishes, and when it moves into production. This
	// field informs the Amazon Web Services seller about when the opportunity launches
	// and starts to incur Amazon Web Services usage.
	//
	// Ensure the Target Close Date isn't in the past.
	TargetCloseDate *string

	noSmithyDocumentSerde
}

//	Specifies a subset of fields associated with tasks related to accepting an
//
// engagement invitation.
type ListEngagementByAcceptingInvitationTaskSummary struct {

	//  The unique identifier of the engagement invitation that was accepted.
	EngagementInvitationId *string

	//  Detailed message describing the failure and possible recovery steps.
	Message *string

	//  Unique identifier of opportunity that was created.
	OpportunityId *string

	//  A code pointing to the specific reason for the failure.
	ReasonCode ReasonCode

	//  Unique identifier of the resource snapshot job that was created.
	ResourceSnapshotJobId *string

	//  Task start timestamp.
	StartTime *time.Time

	//  The Amazon Resource Name (ARN) that uniquely identifies the task.
	TaskArn *string

	//  Unique identifier of the task.
	TaskId *string

	//  Status of the task.
	TaskStatus TaskStatus

	noSmithyDocumentSerde
}

//	Provides a summary of a task related to creating an engagement from an
//
// opportunity. This structure contains key information about the task's status,
// associated identifiers, and any failure details.
type ListEngagementFromOpportunityTaskSummary struct {

	//  The unique identifier of the engagement created as a result of the task. This
	// field is populated when the task is completed successfully.
	EngagementId *string

	// The unique identifier of the Engagement Invitation.
	EngagementInvitationId *string

	//  A detailed message providing additional information about the task, especially
	// useful in case of failures. This field may contain error details or other
	// relevant information about the task's execution
	Message *string

	//  The unique identifier of the original Opportunity from which the Engagement is
	// being created. This field helps track the source of the Engagement creation
	// task.
	OpportunityId *string

	//  A code indicating the specific reason for a task failure. This field is
	// populated when the task status is FAILED and provides a categorized reason for
	// the failure.
	ReasonCode ReasonCode

	//  The identifier of the resource snapshot job associated with this task, if a
	// snapshot was created as part of the Engagement creation process.
	ResourceSnapshotJobId *string

	//  The timestamp indicating when the task was initiated, in RFC 3339 5.6
	// date-time format.
	StartTime *time.Time

	//  The Amazon Resource Name (ARN) uniquely identifying this task within AWS. This
	// ARN can be used for referencing the task in other AWS services or APIs.
	TaskArn *string

	//  A unique identifier for a specific task.
	TaskId *string

	//  The current status of the task.
	TaskStatus TaskStatus

	noSmithyDocumentSerde
}

// Provides a summary of a task related to creating an opportunity from an
// engagement. This structure contains key information about the task's status,
// associated identifiers, and any failure details for opportunity creation
// processes.
type ListOpportunityFromEngagementTaskSummary struct {

	// The unique identifier of the engagement context associated with the opportunity
	// creation task. This links the task to specific contextual information within the
	// engagement.
	ContextId *string

	// The unique identifier of the engagement from which the opportunity is being
	// created. This field helps track the source of the opportunity creation task.
	EngagementId *string

	// A detailed message providing additional information about the task, especially
	// useful in case of failures. This field may contain error details or other
	// relevant information about the task's execution.
	Message *string

	// The unique identifier of the opportunity created as a result of the task. This
	// field is populated when the task is completed successfully.
	OpportunityId *string

	// A code indicating the specific reason for a task failure. This field is
	// populated when the task status is FAILED and provides a categorized reason for
	// the failure.
	ReasonCode ReasonCode

	// The identifier of the resource snapshot job associated with this task, if a
	// snapshot was created as part of the opportunity creation process.
	ResourceSnapshotJobId *string

	// The timestamp indicating when the task was initiated, in RFC 3339 format.
	StartTime *time.Time

	// The Amazon Resource Name (ARN) that uniquely identifies the task within AWS.
	// This ARN can be used for referencing the task in other AWS services or APIs.
	TaskArn *string

	// The unique identifier of the task for creating an opportunity from an
	// engagement.
	TaskId *string

	// The current status of the task. Valid values are COMPLETE, INPROGRESS, or
	// FAILED.
	TaskStatus TaskStatus

	noSmithyDocumentSerde
}

//	Defines the sorting parameters for listing tasks. This structure allows for
//
// specifying the field to sort by and the order of sorting.
type ListTasksSortBase struct {

	//  Specifies the field by which the task list should be sorted.
	//
	// This member is required.
	SortBy ListTasksSortName

	//  Determines the order in which the sorted results are presented.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An object that contains marketing details for the Opportunity .
type Marketing struct {

	// Indicates if the Opportunity is a marketing development fund (MDF) funded
	// activity.
	AwsFundingUsed AwsFundingUsed

	// Specifies the Opportunity marketing campaign code. The Amazon Web Services
	// campaign code is a reference to specific marketing initiatives, promotions, or
	// activities. This field captures the identifier used to track and categorize the
	// Opportunity within marketing campaigns. If you don't have a campaign code,
	// contact your Amazon Web Services point of contact to obtain one.
	CampaignName *string

	// Specifies the Opportunity 's channel that the marketing activity is associated
	// with or was contacted through. This field provides information about the
	// specific marketing channel that contributed to the generation of the lead or
	// contact.
	Channels []Channel

	// Indicates if the Opportunity was sourced from an Amazon Web Services marketing
	// activity. Use the value Marketing Activity . Use None if it's not associated
	// with an Amazon Web Services marketing activity. This field helps Amazon Web
	// Services track the return on marketing investments and enables better
	// distribution of marketing budgets among partners.
	Source MarketingSource

	// Specifies the marketing activity use case or purpose that led to the Opportunity
	// 's creation or contact. This field captures the context or marketing activity's
	// execution's intention and the direct correlation to the generated opportunity or
	// contact. Must be empty when Marketing.AWSFundingUsed = No .
	//
	// Valid values: AI/ML | Analytics | Application Integration | Blockchain |
	// Business Applications | Cloud Financial Management | Compute | Containers |
	// Customer Engagement | Databases | Developer Tools | End User Computing | Front
	// End Web & Mobile | Game Tech | IoT | Management & Governance | Media Services |
	// Migration & Transfer | Networking & Content Delivery | Quantum Technologies |
	// Robotics | Satellite | Security | Serverless | Storage | VR & AR
	UseCases []string

	noSmithyDocumentSerde
}

// Specifies payments details.
type MonetaryValue struct {

	// Specifies the payment amount.
	//
	// This member is required.
	Amount *string

	// Specifies the payment currency.
	//
	// This member is required.
	CurrencyCode CurrencyCode

	noSmithyDocumentSerde
}

// Read-only; shows the last 50 values and change dates for the NextSteps field.
type NextStepsHistory struct {

	// Indicates the step execution time.
	//
	// This member is required.
	Time *time.Time

	// Indicates the step's execution details.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Defines sorting options for retrieving Engagement Invitations. Sorting can be
// done based on various criteria like the invitation date or status.
type OpportunityEngagementInvitationSort struct {

	// Specifies the field by which the Engagement Invitations are sorted. Common
	// values include InvitationDate and Status .
	//
	// This member is required.
	SortBy OpportunityEngagementInvitationSortName

	// Defines the order in which the Engagement Invitations are sorted. The values
	// can be ASC (ascending) or DESC (descending).
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Represents the data payload of an Engagement Invitation for a specific
// opportunity. This contains detailed information that partners use to evaluate
// the engagement.
type OpportunityInvitationPayload struct {

	// Contains information about the customer related to the opportunity in the
	// Engagement Invitation. This data helps partners understand the customer’s
	// profile and requirements.
	//
	// This member is required.
	Customer *EngagementCustomer

	// Describes the project details associated with the opportunity, including the
	// customer’s needs and the scope of work expected to be performed.
	//
	// This member is required.
	Project *ProjectDetails

	// Outlines the responsibilities or expectations of the receiver in the context of
	// the invitation.
	//
	// This member is required.
	ReceiverResponsibilities []ReceiverResponsibility

	// Represents the contact details of the AWS representatives involved in sending
	// the Engagement Invitation. These contacts are opportunity stakeholders.
	SenderContacts []SenderContact

	noSmithyDocumentSerde
}

// Object that configures response sorting.
type OpportunitySort struct {

	// Field name to sort by.
	//
	// This member is required.
	SortBy OpportunitySortName

	// Sort order.
	//
	// Default: Descending
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// An object that contains an Opportunity 's subset of fields.
type OpportunitySummary struct {

	// Specifies the catalog associated with the opportunity, either AWS or Sandbox .
	// This indicates the environment in which the opportunity is managed.
	//
	// This member is required.
	Catalog *string

	//  The Amazon Resource Name (ARN) for the opportunity. This globally unique
	// identifier can be used for IAM policies and cross-service references.
	Arn *string

	// DateTime when the Opportunity was last created.
	CreatedDate *time.Time

	// An object that contains the Opportunity 's customer details.
	Customer *CustomerSummary

	// Read-only, system-generated Opportunity unique identifier.
	Id *string

	// DateTime when the Opportunity was last modified.
	LastModifiedDate *time.Time

	// An object that contains the Opportunity 's lifecycle details.
	LifeCycle *LifeCycleSummary

	// Specifies opportunity type as a renewal, new, or expansion.
	//
	// Opportunity types:
	//
	//   - New Opportunity: Represents a new business opportunity with a potential
	//   customer that's not previously engaged with your solutions or services.
	//
	//   - Renewal Opportunity: Represents an opportunity to renew an existing
	//   contract or subscription with a current customer, ensuring continuity of
	//   service.
	//
	//   - Expansion Opportunity: Represents an opportunity to expand the scope of an
	//   existing contract or subscription, either by adding new services or increasing
	//   the volume of existing services for a current customer.
	OpportunityType OpportunityType

	// Specifies the Opportunity 's unique identifier in the partner's CRM system. This
	// value is essential to track and reconcile because it's included in the outbound
	// payload sent back to the partner. It allows partners to link an opportunity to
	// their CRM.
	PartnerOpportunityIdentifier *string

	// An object that contains the Opportunity 's project details summary.
	Project *ProjectSummary

	noSmithyDocumentSerde
}

//	Provides a comprehensive view of an opportunity summary, including lifecycle
//
// information, team details, opportunity type, primary needs from AWS, and
// associated project information.
type OpportunitySummaryView struct {

	// An object that contains the customer's Account and Contact .
	Customer *Customer

	//  Contains information about the opportunity's lifecycle, including its current
	// stage, status, and important dates such as creation and last modification times.
	Lifecycle *LifeCycleForView

	//  Represents the internal team handling the opportunity. Specify the members
	// involved in collaborating on an opportunity within the partner's organization.
	OpportunityTeam []Contact

	//  Specifies the opportunity type.
	OpportunityType OpportunityType

	//  Identifies the type of support the partner needs from AWS.
	PrimaryNeedsFromAws []PrimaryNeedFromAws

	//  Contains summary information about the project associated with the
	// opportunity, including project name, description, timeline, and other relevant
	// details.
	Project *ProjectView

	// This field provides the associations' information for other entities with the
	// opportunity. These entities include identifiers for AWSProducts , Partner
	// Solutions , and AWSMarketplaceOffers .
	RelatedEntityIdentifiers *RelatedEntityIdentifiers

	noSmithyDocumentSerde
}

// Contains the data payload associated with the Engagement Invitation. This
// payload includes essential details related to the AWS opportunity and is used by
// partners to evaluate whether to accept or reject the engagement.
//
// The following types satisfy this interface:
//
//	PayloadMemberLeadInvitation
//	PayloadMemberOpportunityInvitation
type Payload interface {
	isPayload()
}

// Specifies the details of the lead invitation within the Engagement Invitation
// payload. This data helps partners understand the lead context, customer
// information, and interaction history for the lead opportunity from AWS.
type PayloadMemberLeadInvitation struct {
	Value LeadInvitationPayload

	noSmithyDocumentSerde
}

func (*PayloadMemberLeadInvitation) isPayload() {}

// Specifies the details of the opportunity invitation within the Engagement
// Invitation payload. This data helps partners understand the context, scope, and
// expected involvement for the opportunity from AWS.
type PayloadMemberOpportunityInvitation struct {
	Value OpportunityInvitationPayload

	noSmithyDocumentSerde
}

func (*PayloadMemberOpportunityInvitation) isPayload() {}

// Tracks the history of next steps associated with the opportunity. This field
// captures the actions planned for the future and their timeline.
type ProfileNextStepsHistory struct {

	// Indicates the date and time when a particular next step was recorded or
	// planned. This helps in managing the timeline for the opportunity.
	//
	// This member is required.
	Time *time.Time

	// Represents the details of the next step recorded, such as follow-up actions or
	// decisions made. This field helps in tracking progress and ensuring alignment
	// with project goals.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An object that contains the Opportunity 's project details.
type Project struct {

	// Captures additional comments or information for the Opportunity that weren't
	// captured in other fields.
	AdditionalComments *string

	// Specifies the Amazon Partner Network (APN) program that influenced the
	// Opportunity . APN programs refer to specific partner programs or initiatives
	// that can impact the Opportunity .
	//
	// Valid values: APN Immersion Days | APN Solution Space | ATO (Authority to
	// Operate) | AWS Marketplace Campaign | IS Immersion Day SFID Program | ISV
	// Workload Migration | Migration Acceleration Program | P3 | Partner Launch
	// Initiative | Partner Opportunity Acceleration Funded | The Next Smart | VMware
	// Cloud on AWS | Well-Architected | Windows | Workspaces/AppStream Accelerator
	// Program | WWPS NDPP
	ApnPrograms []string

	// Name of the Opportunity 's competitor (if any). Use Other to submit a value not
	// in the picklist.
	CompetitorName CompetitorName

	// Describes the problem the end customer has, and how the partner is helping.
	// Utilize this field to provide a concise narrative that outlines the customer's
	// business challenge or issue. Elaborate on how the partner's solution or
	// offerings align to resolve the customer's business problem. Include relevant
	// information about the partner's value proposition, unique selling points, and
	// expertise to tackle the issue. Offer insights on how the proposed solution meets
	// the customer's needs and provides value. Use concise language and precise
	// descriptions to convey the context and significance of the Opportunity . The
	// content in this field helps Amazon Web Services understand the nature of the
	// Opportunity and the strategic fit of the partner's solution.
	CustomerBusinessProblem *string

	// Specifies the proposed solution focus or type of workload for the Opportunity.
	// This field captures the primary use case or objective of the proposed solution,
	// and provides context and clarity to the addressed workload.
	//
	// Valid values: AI Machine Learning and Analytics | Archiving | Big Data: Data
	// Warehouse/Data Integration/ETL/Data Lake/BI | Blockchain | Business
	// Applications: Mainframe Modernization | Business Applications & Contact Center |
	// Business Applications & SAP Production | Centralized Operations Management |
	// Cloud Management Tools | Cloud Management Tools & DevOps with Continuous
	// Integration & Continuous Delivery (CICD) | Configuration, Compliance & Auditing
	// | Connected Services | Containers & Serverless | Content Delivery & Edge
	// Services | Database | Edge Computing/End User Computing | Energy | Enterprise
	// Governance & Controls | Enterprise Resource Planning | Financial Services |
	// Healthcare and Life Sciences | High Performance Computing | Hybrid Application
	// Platform | Industrial Software | IOT | Manufacturing, Supply Chain and
	// Operations | Media & High performance computing (HPC) | Migration/Database
	// Migration | Monitoring, logging and performance | Monitoring & Observability |
	// Networking | Outpost | SAP | Security & Compliance | Storage & Backup | Training
	// | VMC | VMWare | Web development & DevOps
	CustomerUseCase *string

	// Specifies the deployment or consumption model for your solution or service in
	// the Opportunity 's context. You can select multiple options.
	//
	// Options' descriptions from the Delivery Model field are:
	//
	//   - SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or
	//   PaaS in your Amazon Web Services environment.
	//
	//   - BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or
	//   AMI in the end customer's Amazon Web Services environment.
	//
	//   - Managed Services: The end customer's Amazon Web Services business
	//   management (For example: Consulting, design, implementation, billing support,
	//   cost optimization, technical support).
	//
	//   - Professional Services: Offerings to help enterprise end customers achieve
	//   specific business outcomes for enterprise cloud adoption (For example: Advisory
	//   or transformation planning).
	//
	//   - Resell: Amazon Web Services accounts and billing management for your
	//   customers.
	//
	//   - Other: Delivery model not described above.
	DeliveryModels []DeliveryModel

	// Represents the estimated amount that the customer is expected to spend on AWS
	// services related to the opportunity. This helps in evaluating the potential
	// financial value of the opportunity for AWS.
	ExpectedCustomerSpend []ExpectedCustomerSpend

	// Only allowed when CompetitorNames has Other selected.
	OtherCompetitorNames *string

	// Specifies the offered solution for the customer's business problem when the
	// RelatedEntityIdentifiers.Solutions field value is Other .
	OtherSolutionDescription *string

	// Specifies the current opportunity's parent opportunity identifier.
	RelatedOpportunityIdentifier *string

	// Specifies the Opportunity 's sales activities conducted with the end customer.
	// These activities help drive Amazon Web Services assignment priority.
	//
	// Valid values:
	//
	//   - Initialized discussions with customer: Initial conversations with the
	//   customer to understand their needs and introduce your solution.
	//
	//   - Customer has shown interest in solution: After initial discussions, the
	//   customer is interested in your solution.
	//
	//   - Conducted POC/demo: You conducted a proof of concept (POC) or demonstration
	//   of the solution for the customer.
	//
	//   - In evaluation/planning stage: The customer is evaluating the solution and
	//   planning potential implementation.
	//
	//   - Agreed on solution to Business Problem: Both parties agree on how the
	//   solution addresses the customer's business problem.
	//
	//   - Completed Action Plan: A detailed action plan is complete and outlines the
	//   steps for implementation.
	//
	//   - Finalized Deployment Need: Both parties agree with and finalized the
	//   deployment needs.
	//
	//   - SOW Signed: Both parties signed a statement of work (SOW), and formalize
	//   the agreement and detail the project scope and deliverables.
	SalesActivities []SalesActivity

	// Specifies the Opportunity 's title or name.
	Title *string

	noSmithyDocumentSerde
}

// Contains details about the project associated with the Engagement Invitation,
// including the business problem and expected outcomes.
type ProjectDetails struct {

	// Describes the business problem that the project aims to solve. This information
	// is crucial for understanding the project’s goals and objectives.
	//
	// This member is required.
	BusinessProblem *string

	// Contains revenue estimates for the partner related to the project. This field
	// provides an idea of the financial potential of the opportunity for the partner.
	//
	// This member is required.
	ExpectedCustomerSpend []ExpectedCustomerSpend

	// Specifies the estimated date of project completion. This field helps track the
	// project timeline and manage expectations.
	//
	// This member is required.
	TargetCompletionDate *string

	// Specifies the title of the project. This title helps partners quickly identify
	// and understand the focus of the project.
	//
	// This member is required.
	Title *string

	noSmithyDocumentSerde
}

// An object that contains a Project object's subset of fields.
type ProjectSummary struct {

	// Specifies your solution or service's deployment or consumption model in the
	// Opportunity 's context. You can select multiple options.
	//
	// Options' descriptions from the Delivery Model field are:
	//
	//   - SaaS or PaaS: Your Amazon Web Services based solution deployed as SaaS or
	//   PaaS in your Amazon Web Services environment.
	//
	//   - BYOL or AMI: Your Amazon Web Services based solution deployed as BYOL or
	//   AMI in the end customer's Amazon Web Services environment.
	//
	//   - Managed Services: The end customer's Amazon Web Services business
	//   management (For example: Consulting, design, implementation, billing support,
	//   cost optimization, technical support).
	//
	//   - Professional Services: Offerings to help enterprise end customers achieve
	//   specific business outcomes for enterprise cloud adoption (For example: Advisory
	//   or transformation planning).
	//
	//   - Resell: Amazon Web Services accounts and billing management for your
	//   customers.
	//
	//   - Other: Delivery model not described above.
	DeliveryModels []DeliveryModel

	// Provides a summary of the expected customer spend for the project, offering a
	// high-level view of the potential financial impact.
	ExpectedCustomerSpend []ExpectedCustomerSpend

	noSmithyDocumentSerde
}

//	Provides the project view of an opportunity resource shared through a
//
// snapshot.
type ProjectView struct {

	//  Specifies the proposed solution focus or type of workload for the project.
	CustomerUseCase *string

	//  Describes the deployment or consumption model for the partner solution or
	// offering. This field indicates how the project's solution will be delivered or
	// implemented for the customer.
	DeliveryModels []DeliveryModel

	//  Provides information about the anticipated customer spend related to this
	// project. This may include details such as amount, frequency, and currency of
	// expected expenditure.
	ExpectedCustomerSpend []ExpectedCustomerSpend

	//  Offers a description of other solutions if the standard solutions do not
	// adequately cover the project's scope.
	OtherSolutionDescription *string

	//  Lists the pre-sales activities that have occurred with the end-customer
	// related to the opportunity. This field is conditionally mandatory when the
	// project is qualified for Co-Sell and helps drive assignment priority on the AWS
	// side. It provides insight into the engagement level with the customer.
	SalesActivities []SalesActivity

	noSmithyDocumentSerde
}

// Represents the entity that received the Engagement Invitation, including
// account and company details. This field is essential for tracking the partner
// who is being invited to collaborate.
//
// The following types satisfy this interface:
//
//	ReceiverMemberAccount
type Receiver interface {
	isReceiver()
}

// Specifies the AWS account of the partner who received the Engagement
// Invitation. This field is used to track the invitation recipient within the AWS
// ecosystem.
type ReceiverMemberAccount struct {
	Value AccountReceiver

	noSmithyDocumentSerde
}

func (*ReceiverMemberAccount) isReceiver() {}

// This field provides the associations' information for other entities with the
// opportunity. These entities include identifiers for AWSProducts , Partner
// Solutions , and AWSMarketplaceOffers .
type RelatedEntityIdentifiers struct {

	// Enables the association of AWS Marketplace offer sets with the Opportunity .
	// Offer sets allow grouping multiple related marketplace offers together for
	// comprehensive solution packaging. Each value is an Amazon Resource Name (ARN) in
	// this format:
	// arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/OfferSet/offerset-sampleOfferSet32
	// .
	AwsMarketplaceOfferSets []string

	// Takes one value per opportunity. Each value is an Amazon Resource Name (ARN),
	// in this format: "offers":
	// ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]
	// .
	//
	// Use the [ListEntities] action in the Marketplace Catalog APIs for a list of offers in the
	// associated Marketplace seller account.
	//
	// [ListEntities]: https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html
	AwsMarketplaceOffers []string

	// Enables the association of specific Amazon Web Services products with the
	// Opportunity . Partners can indicate the relevant Amazon Web Services products
	// for the Opportunity 's solution and align with the customer's needs. Returns
	// multiple values separated by commas. For example, "AWSProducts" :
	// ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"] .
	//
	// Use the file with the list of Amazon Web Services products hosted on GitHub: [Amazon Web Services products].
	//
	// [Amazon Web Services products]: https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json
	AwsProducts []string

	// Enables partner solutions or offerings' association with an opportunity. To
	// associate a solution, provide the solution's unique identifier, which you can
	// obtain with the ListSolutions operation.
	//
	// If the specific solution identifier is not available, you can use the value
	// Other and provide details about the solution in the otherSolutionOffered field.
	// But when the opportunity reaches the Committed stage or beyond, the Other value
	// cannot be used, and a valid solution identifier must be provided.
	//
	// By associating the relevant solutions with the opportunity, you can communicate
	// the offerings that are being considered or implemented to address the customer's
	// business problem.
	Solutions []string

	noSmithyDocumentSerde
}

// An object that contains a Resource Snapshot Job 's subset of fields.
type ResourceSnapshotJobSummary struct {

	//  The Amazon Resource Name (ARN) for the resource snapshot job.
	Arn *string

	// The unique identifier of the Engagement.
	EngagementId *string

	//  The unique identifier for the resource snapshot job within the AWS Partner
	// Central system. This ID is used for direct references to the job within the
	// service.
	Id *string

	// The current status of the snapshot job.
	//
	// Valid values:
	//
	//   - STOPPED: The job is not currently running.
	//
	//   - RUNNING: The job is actively executing.
	Status ResourceSnapshotJobStatus

	noSmithyDocumentSerde
}

//	Represents the payload of a resource snapshot. This structure is designed to
//
// accommodate different types of resource snapshots, currently supporting
// opportunity summaries.
//
// The following types satisfy this interface:
//
//	ResourceSnapshotPayloadMemberOpportunitySummary
type ResourceSnapshotPayload interface {
	isResourceSnapshotPayload()
}

// An object that contains an opportunity 's subset of fields.
type ResourceSnapshotPayloadMemberOpportunitySummary struct {
	Value OpportunitySummaryView

	noSmithyDocumentSerde
}

func (*ResourceSnapshotPayloadMemberOpportunitySummary) isResourceSnapshotPayload() {}

//	Provides a concise summary of a resource snapshot, including its unique
//
// identifier and version information. This structure is used to quickly reference
// and identify specific versions of resource snapshots.
type ResourceSnapshotSummary struct {

	//  The Amazon Resource Name (ARN) of the snapshot. This globally unique
	// identifier can be used for cross-service references and in IAM policies.
	Arn *string

	// The AWS account ID of the entity that owns the resource from which the snapshot
	// was created.
	CreatedBy *string

	// The identifier of the specific resource snapshotted. The format might vary
	// depending on the ResourceType.
	ResourceId *string

	// The name of the template used to create the snapshot.
	ResourceSnapshotTemplateName *string

	// The type of resource snapshotted.
	ResourceType ResourceType

	// The revision number of the snapshot. This integer value is incremented each
	// time the snapshot is updated, allowing for version tracking of the resource
	// snapshot.
	Revision *int32

	noSmithyDocumentSerde
}

// An object that contains the details of the sender-provided contact person for
// the EngagementInvitation .
type SenderContact struct {

	// The sender-provided contact's email address associated with the
	// EngagementInvitation .
	//
	// This member is required.
	Email *string

	// The sender-provided contact's title (job title or role) associated with the
	// EngagementInvitation .
	BusinessTitle *string

	// The sender-provided contact's last name associated with the EngagementInvitation
	// .
	FirstName *string

	// The sender-provided contact's first name associated with the
	// EngagementInvitation .
	LastName *string

	// The sender-provided contact's phone number associated with the
	// EngagementInvitation .
	Phone *string

	noSmithyDocumentSerde
}

// Specifies a customer's procurement terms details. Required only for partners in
// eligible programs.
type SoftwareRevenue struct {

	// Specifies the customer's intended payment type agreement or procurement method
	// to acquire the solution or service outlined in the Opportunity .
	DeliveryModel RevenueModel

	// Specifies the Opportunity 's customer engagement start date for the contract's
	// effectiveness.
	EffectiveDate *string

	// Specifies the expiration date for the contract between the customer and Amazon
	// Web Services partner. It signifies the termination date of the agreed-upon
	// engagement period between both parties.
	ExpirationDate *string

	// Specifies the payment value (amount and currency).
	Value *MonetaryValue

	noSmithyDocumentSerde
}

// Specifies minimal information for the solution offered to solve the customer's
// business problem.
type SolutionBase struct {

	// Specifies the catalog in which the solution is hosted, either AWS or Sandbox .
	// This helps partners differentiate between live solutions and those in testing
	// environments.
	//
	// This member is required.
	Catalog *string

	// Specifies the solution category, which helps to categorize and organize the
	// solutions partners offer. Valid values: Software Product | Consulting Service |
	// Hardware Product | Communications Product | Professional Service | Managed
	// Service | Value-Added Resale Amazon Web Services Service | Distribution Service
	// | Training Service | Merger and Acquisition Advising Service .
	//
	// This member is required.
	Category *string

	// Indicates the solution creation date. This is useful to track and audit.
	//
	// This member is required.
	CreatedDate *time.Time

	// Enables the association of solutions (offerings) to opportunities.
	//
	// This member is required.
	Id *string

	// Specifies the solution name.
	//
	// This member is required.
	Name *string

	// Specifies the solution's current status, which indicates its state in the
	// system. Valid values: Active | Inactive | Draft . The status helps partners and
	// Amazon Web Services track the solution's lifecycle and availability. Filter for
	// Active solutions for association to an opportunity.
	//
	// This member is required.
	Status SolutionStatus

	//  The SolutionBase structure provides essential information about a solution.
	Arn *string

	noSmithyDocumentSerde
}

// Configures the solutions' response sorting that enables partners to order
// solutions based on specified attributes.
type SolutionSort struct {

	// Specifies the attribute to sort by, such as Name , CreatedDate , or Status .
	//
	// This member is required.
	SortBy SolutionSortName

	// Specifies the sorting order, either Ascending or Descending . The default is
	// Descending .
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

//	Defines the sorting parameters for listing resource snapshot jobs. This
//
// structure allows you to specify the field to sort by and the order of sorting.
type SortObject struct {

	//  Specifies the field by which to sort the resource snapshot jobs.
	SortBy SortBy

	//  Determines the order in which the sorted results are presented.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// The key-value pair assigned to a specified resource.
type Tag struct {

	// The key in the tag.
	//
	// This member is required.
	Key *string

	// The value in the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Represents the updated payload of an engagement context. The structure of this
// payload varies based on the context type being updated.
//
// The following types satisfy this interface:
//
//	UpdateEngagementContextPayloadMemberCustomerProject
//	UpdateEngagementContextPayloadMemberLead
type UpdateEngagementContextPayload interface {
	isUpdateEngagementContextPayload()
}

// The CustomerProjects structure in Engagements offers a flexible framework for
// managing customer-project relationships. It supports multiple customers per
// Engagement and multiple projects per customer, while also allowing for customers
// without projects and projects without specific customers.
//
// All Engagement members have full visibility of customers and their associated
// projects, enabling the capture of relevant context even when project details are
// not fully defined. This structure also facilitates targeted invitations,
// allowing partners to focus on specific customers and their business problems
// when sending Engagement invitations.
type UpdateEngagementContextPayloadMemberCustomerProject struct {
	Value CustomerProjectsContext

	noSmithyDocumentSerde
}

func (*UpdateEngagementContextPayloadMemberCustomerProject) isUpdateEngagementContextPayload() {}

// Contains updated information about a lead when the context type is "Lead". This
// field is present only when updating a lead context within the engagement.
type UpdateEngagementContextPayloadMemberLead struct {
	Value UpdateLeadContext

	noSmithyDocumentSerde
}

func (*UpdateEngagementContextPayloadMemberLead) isUpdateEngagementContextPayload() {}

// Updates the context information for a lead with qualification status, customer
// details, and interaction data.
type UpdateLeadContext struct {

	// Updated customer information associated with the lead.
	//
	// This member is required.
	Customer *LeadCustomer

	// Updated interaction details for the lead context.
	Interaction *LeadInteraction

	// The updated qualification status of the lead.
	QualificationStatus *string

	noSmithyDocumentSerde
}

// Indicates an invalid value for a field.
//
//   - REQUIRED_FIELD_MISSING: The request is missing a required field.
//
// Fix: Verify your request payload includes all required fields.
//
//   - INVALID_ENUM_VALUE: The enum field value isn't an accepted values.
//
// Fix: Check the documentation for the list of valid enum values, and update your
//
//	request with a valid value.
//
//	- INVALID_STRING_FORMAT: The string format is invalid.
//
// Fix: Confirm that the string is in the expected format (For example: email
//
//	address, date).
//
//	- INVALID_VALUE: The value isn't valid.
//
// Fix: Confirm that the value meets the expected criteria and is within the
//
//	allowable range or set.
//
//	- TOO_MANY_VALUES: There are too many values in a field that expects fewer
//	entries.
//
// Fix: Reduce the number of values to match the expected limit.
//
//   - NOT_ENOUGH_VALUES: There are not enough values in a field that expects more
//     entries.
//
// Fix: Increase the number of values to match the expected threshold.
//
//   - ACTION_NOT_PERMITTED: The action isn't permitted due to current state or
//     permissions.
//
// Fix: Verify that the action is appropriate for the current state, and that you
//
//	have the necessary permissions to perform it.
//
//	- DUPLICATE_KEY_VALUE: The value in a field duplicates a value that must be
//	unique.
//
// Fix: Verify that the value is unique and doesn't duplicate an existing value in
//
//	the system.
type ValidationExceptionError struct {

	// Specifies the error code for the invalid field value.
	//
	// This member is required.
	Code ValidationExceptionErrorCode

	// Specifies the detailed error message for the invalid field value.
	//
	// This member is required.
	Message *string

	// Specifies the field name with the invalid value.
	FieldName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isEngagementContextPayload()       {}
func (*UnknownUnionMember) isPayload()                        {}
func (*UnknownUnionMember) isReceiver()                       {}
func (*UnknownUnionMember) isResourceSnapshotPayload()        {}
func (*UnknownUnionMember) isUpdateEngagementContextPayload() {}
