// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disables [Multi-Region key replication] settings for the specified Amazon Web Services Regions in your Amazon
// Web Services account, preventing new keys from being automatically replicated to
// those regions.
//
// After disabling Multi-Region key replication for specific regions, new keys
// created in your account will not be automatically replicated to those regions.
// You can still manually add replication to those regions for individual keys
// using the [AddKeyReplicationRegions]operation.
//
// This operation does not affect existing keys or their current replication
// configuration.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [EnableDefaultKeyReplicationRegions]
//
// [GetDefaultKeyReplicationRegions]
//
// [Multi-Region key replication]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html
// [AddKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_AddKeyReplicationRegions.html
// [EnableDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_EnableDefaultKeyReplicationRegions.html
// [GetDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetDefaultKeyReplicationRegions.html
func (c *Client) DisableDefaultKeyReplicationRegions(ctx context.Context, params *DisableDefaultKeyReplicationRegionsInput, optFns ...func(*Options)) (*DisableDefaultKeyReplicationRegionsOutput, error) {
	if params == nil {
		params = &DisableDefaultKeyReplicationRegionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisableDefaultKeyReplicationRegions", params, optFns, c.addOperationDisableDefaultKeyReplicationRegionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisableDefaultKeyReplicationRegionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input parameters for disabling default key replication regions for the account.
type DisableDefaultKeyReplicationRegionsInput struct {

	// The list of Amazon Web Services Regions to remove from the account's default
	// replication regions.
	//
	// New keys created after this operation will not automatically be replicated to
	// these regions, though existing keys with replication to these regions will be
	// unaffected.
	//
	// This member is required.
	ReplicationRegions []string

	noSmithyDocumentSerde
}

// Output from disabling default key replication regions for the account.
type DisableDefaultKeyReplicationRegionsOutput struct {

	// The remaining list of regions where default key replication is still enabled
	// for the account.
	//
	// This reflects the account's default replication configuration after removing
	// the specified regions.
	//
	// This member is required.
	EnabledReplicationRegions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisableDefaultKeyReplicationRegionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDisableDefaultKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDisableDefaultKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisableDefaultKeyReplicationRegions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDisableDefaultKeyReplicationRegionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisableDefaultKeyReplicationRegions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisableDefaultKeyReplicationRegions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisableDefaultKeyReplicationRegions",
	}
}
