// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an action connector that enables Amazon Quick Sight to connect to
// external services and perform actions. Action connectors support various
// authentication methods and can be configured with specific actions from
// supported connector types like Amazon S3, Salesforce, JIRA.
func (c *Client) CreateActionConnector(ctx context.Context, params *CreateActionConnectorInput, optFns ...func(*Options)) (*CreateActionConnectorOutput, error) {
	if params == nil {
		params = &CreateActionConnectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateActionConnector", params, optFns, c.addOperationCreateActionConnectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateActionConnectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateActionConnectorInput struct {

	// A unique identifier for the action connector. This ID must be unique within the
	// Amazon Web Services account. The ActionConnectorId must not start with the
	// prefix quicksuite-
	//
	// This member is required.
	ActionConnectorId *string

	// The authentication configuration for connecting to the external service. This
	// includes the authentication type, base URL, and authentication metadata such as
	// client credentials or API keys.
	//
	// This member is required.
	AuthenticationConfig *types.AuthConfig

	// The Amazon Web Services account ID associated with the action connector.
	//
	// This member is required.
	AwsAccountId *string

	// A descriptive name for the action connector.
	//
	// This member is required.
	Name *string

	// The type of action connector.
	//
	// This member is required.
	Type types.ActionConnectorType

	// An optional description of the action connector.
	Description *string

	// The permissions configuration that defines which users, groups, or namespaces
	// can access this action connector and what operations they can perform.
	Permissions []types.ResourcePermission

	// A list of tags to apply to the action connector for resource management and
	// organization.
	Tags []types.Tag

	// The ARN of the VPC connection to use for secure connectivity to the external
	// service.
	VpcConnectionArn *string

	noSmithyDocumentSerde
}

type CreateActionConnectorOutput struct {

	// The unique identifier of the created action connector.
	ActionConnectorId *string

	// The Amazon Resource Name (ARN) of the created action connector.
	Arn *string

	// The creation status of the action connector.
	CreationStatus types.ResourceStatus

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status code of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateActionConnectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateActionConnector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateActionConnector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateActionConnector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateActionConnectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateActionConnector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateActionConnector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateActionConnector",
	}
}
