// Code generated by smithy-go-codegen DO NOT EDIT.

package rds

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rds/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new DB proxy.
func (c *Client) CreateDBProxy(ctx context.Context, params *CreateDBProxyInput, optFns ...func(*Options)) (*CreateDBProxyOutput, error) {
	if params == nil {
		params = &CreateDBProxyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDBProxy", params, optFns, c.addOperationCreateDBProxyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDBProxyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDBProxyInput struct {

	// The identifier for the proxy. This name must be unique for all proxies owned by
	// your Amazon Web Services account in the specified Amazon Web Services Region. An
	// identifier must begin with a letter and must contain only ASCII letters, digits,
	// and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
	//
	// This member is required.
	DBProxyName *string

	// The kinds of databases that the proxy can connect to. This value determines
	// which database network protocol the proxy recognizes when it interprets network
	// traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for
	// MySQL databases, specify MYSQL . For Aurora PostgreSQL and RDS for PostgreSQL
	// databases, specify POSTGRESQL . For RDS for Microsoft SQL Server, specify
	// SQLSERVER .
	//
	// This member is required.
	EngineFamily types.EngineFamily

	// The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access
	// secrets in Amazon Web Services Secrets Manager.
	//
	// This member is required.
	RoleArn *string

	// One or more VPC subnet IDs to associate with the new proxy.
	//
	// This member is required.
	VpcSubnetIds []string

	// The authorization mechanism that the proxy uses.
	Auth []types.UserAuthConfig

	// Specifies whether the proxy logs detailed connection and query information.
	// When you enable DebugLogging , the proxy captures connection details and
	// connection pool behavior from your queries. Debug logging increases CloudWatch
	// costs and can impact proxy performance. Enable this option only when you need to
	// troubleshoot connection or performance issues.
	DebugLogging *bool

	// The default authentication scheme that the proxy uses for client connections to
	// the proxy and connections from the proxy to the underlying database. Valid
	// values are NONE and IAM_AUTH . When set to IAM_AUTH , the proxy uses end-to-end
	// IAM authentication to connect to the database. If you don't specify
	// DefaultAuthScheme or specify this parameter as NONE , you must specify the Auth
	// option.
	DefaultAuthScheme types.DefaultAuthScheme

	// The network type of the DB proxy endpoint. The network type determines the IP
	// version that the proxy endpoint supports.
	//
	// Valid values:
	//
	//   - IPV4 - The proxy endpoint supports IPv4 only.
	//
	//   - IPV6 - The proxy endpoint supports IPv6 only.
	//
	//   - DUAL - The proxy endpoint supports both IPv4 and IPv6.
	//
	// Default: IPV4
	//
	// Constraints:
	//
	//   - If you specify IPV6 or DUAL , the VPC and all subnets must have an IPv6 CIDR
	//   block.
	//
	//   - If you specify IPV6 or DUAL , the VPC tenancy cannot be dedicated .
	EndpointNetworkType types.EndpointNetworkType

	// The number of seconds that a connection to the proxy can be inactive before the
	// proxy disconnects it. You can set this value higher or lower than the connection
	// timeout limit for the associated database.
	IdleClientTimeout *int32

	// Specifies whether Transport Layer Security (TLS) encryption is required for
	// connections to the proxy. By enabling this setting, you can enforce encrypted
	// TLS connections to the proxy.
	RequireTLS *bool

	// An optional set of key-value pairs to associate arbitrary data of your choosing
	// with the proxy.
	Tags []types.Tag

	// The network type that the proxy uses to connect to the target database. The
	// network type determines the IP version that the proxy uses for connections to
	// the database.
	//
	// Valid values:
	//
	//   - IPV4 - The proxy connects to the database using IPv4 only.
	//
	//   - IPV6 - The proxy connects to the database using IPv6 only.
	//
	// Default: IPV4
	//
	// Constraints:
	//
	//   - If you specify IPV6 , the database must support dual-stack mode. RDS doesn't
	//   support IPv6-only databases.
	//
	//   - All targets registered with the proxy must be compatible with the specified
	//   network type.
	TargetConnectionNetworkType types.TargetConnectionNetworkType

	// One or more VPC security group IDs to associate with the new proxy.
	VpcSecurityGroupIds []string

	noSmithyDocumentSerde
}

type CreateDBProxyOutput struct {

	// The DBProxy structure corresponding to the new proxy.
	DBProxy *types.DBProxy

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDBProxyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateDBProxy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateDBProxy{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDBProxy"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDBProxyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDBProxy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDBProxy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDBProxy",
	}
}
