// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftdata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftdata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Fetches the temporarily cached result of an SQL statement in CSV format. The
// ExecuteStatement or BatchExecuteStatement operation that ran the SQL statement
// must have specified ResultFormat as CSV . A token is returned to page through
// the statement results.
//
// For more information about the Amazon Redshift Data API and CLI usage examples,
// see [Using the Amazon Redshift Data API]in the Amazon Redshift Management Guide.
//
// [Using the Amazon Redshift Data API]: https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html
func (c *Client) GetStatementResultV2(ctx context.Context, params *GetStatementResultV2Input, optFns ...func(*Options)) (*GetStatementResultV2Output, error) {
	if params == nil {
		params = &GetStatementResultV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStatementResultV2", params, optFns, c.addOperationGetStatementResultV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStatementResultV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStatementResultV2Input struct {

	// The identifier of the SQL statement whose results are to be fetched. This value
	// is a universally unique identifier (UUID) generated by Amazon Redshift Data API.
	// A suffix indicates then number of the SQL statement. For example,
	// d9b6c0c9-0747-4bf4-b142-e8883122f766:2 has a suffix of :2 that indicates the
	// second SQL statement of a batch query. This identifier is returned by
	// BatchExecuteStatment , ExecuteStatment , and ListStatements .
	//
	// This member is required.
	Id *string

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the next
	// NextToken parameter and retrying the command. If the NextToken field is empty,
	// all response records have been retrieved for the request.
	NextToken *string

	noSmithyDocumentSerde
}

type GetStatementResultV2Output struct {

	// The results of the SQL statement in CSV format.
	//
	// This member is required.
	Records []types.QueryRecords

	// The properties (metadata) of a column.
	ColumnMetadata []types.ColumnMetadata

	// A value that indicates the starting point for the next set of response records
	// in a subsequent request. If a value is returned in a response, you can retrieve
	// the next set of records by providing this returned NextToken value in the next
	// NextToken parameter and retrying the command. If the NextToken field is empty,
	// all response records have been retrieved for the request.
	NextToken *string

	// The data format of the result of the SQL statement.
	ResultFormat types.ResultFormatString

	// The total number of rows in the result set returned from a query. You can use
	// this number to estimate the number of calls to the GetStatementResultV2
	// operation needed to page through the results.
	TotalNumRows int64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStatementResultV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetStatementResultV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetStatementResultV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStatementResultV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetStatementResultV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStatementResultV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetStatementResultV2PaginatorOptions is the paginator options for
// GetStatementResultV2
type GetStatementResultV2PaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetStatementResultV2Paginator is a paginator for GetStatementResultV2
type GetStatementResultV2Paginator struct {
	options   GetStatementResultV2PaginatorOptions
	client    GetStatementResultV2APIClient
	params    *GetStatementResultV2Input
	nextToken *string
	firstPage bool
}

// NewGetStatementResultV2Paginator returns a new GetStatementResultV2Paginator
func NewGetStatementResultV2Paginator(client GetStatementResultV2APIClient, params *GetStatementResultV2Input, optFns ...func(*GetStatementResultV2PaginatorOptions)) *GetStatementResultV2Paginator {
	if params == nil {
		params = &GetStatementResultV2Input{}
	}

	options := GetStatementResultV2PaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetStatementResultV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetStatementResultV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetStatementResultV2 page.
func (p *GetStatementResultV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetStatementResultV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetStatementResultV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetStatementResultV2APIClient is a client that implements the
// GetStatementResultV2 operation.
type GetStatementResultV2APIClient interface {
	GetStatementResultV2(context.Context, *GetStatementResultV2Input, ...func(*Options)) (*GetStatementResultV2Output, error)
}

var _ GetStatementResultV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetStatementResultV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStatementResultV2",
	}
}
