// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an workgroup in Amazon Redshift Serverless.
//
// VPC Block Public Access (BPA) enables you to block resources in VPCs and
// subnets that you own in a Region from reaching or being reached from the
// internet through internet gateways and egress-only internet gateways. If a
// workgroup is in an account with VPC BPA turned on, the following capabilities
// are blocked:
//
//   - Creating a public access workgroup
//
//   - Modifying a private workgroup to public
//
//   - Adding a subnet with VPC BPA turned on to the workgroup when the workgroup
//     is public
//
// For more information about VPC BPA, see [Block public access to VPCs and subnets] in the Amazon VPC User Guide.
//
// [Block public access to VPCs and subnets]: https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html
func (c *Client) CreateWorkgroup(ctx context.Context, params *CreateWorkgroupInput, optFns ...func(*Options)) (*CreateWorkgroupOutput, error) {
	if params == nil {
		params = &CreateWorkgroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWorkgroup", params, optFns, c.addOperationCreateWorkgroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWorkgroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWorkgroupInput struct {

	// The name of the namespace to associate with the workgroup.
	//
	// This member is required.
	NamespaceName *string

	// The name of the created workgroup.
	//
	// This member is required.
	WorkgroupName *string

	// The base data warehouse capacity of the workgroup in Redshift Processing Units
	// (RPUs).
	BaseCapacity *int32

	// An array of parameters to set for advanced control over a database. The options
	// are auto_mv , datestyle , enable_case_sensitive_identifier ,
	// enable_user_activity_logging , query_group , search_path , require_ssl ,
	// use_fips_ssl , and query monitoring metrics that let you define performance
	// boundaries. For more information about query monitoring rules and available
	// metrics, see [Query monitoring metrics for Amazon Redshift Serverless].
	//
	// [Query monitoring metrics for Amazon Redshift Serverless]: https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless
	ConfigParameters []types.ConfigParameter

	// The value that specifies whether to turn on enhanced virtual private cloud
	// (VPC) routing, which forces Amazon Redshift Serverless to route traffic through
	// your VPC instead of over the internet.
	EnhancedVpcRouting *bool

	// The IP address type that the workgroup supports. Possible values are ipv4 and
	// dualstack .
	IpAddressType *string

	// The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve
	// queries. The max capacity is specified in RPUs.
	MaxCapacity *int32

	// The custom port to use when connecting to a workgroup. Valid port ranges are
	// 5431-5455 and 8191-8215. The default is 5439.
	Port *int32

	// An object that represents the price performance target settings for the
	// workgroup.
	PricePerformanceTarget *types.PerformanceTarget

	// A value that specifies whether the workgroup can be accessed from a public
	// network.
	PubliclyAccessible *bool

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []string

	// An array of VPC subnet IDs to associate with the workgroup.
	SubnetIds []string

	// A array of tag instances.
	Tags []types.Tag

	// An optional parameter for the name of the track for the workgroup. If you don't
	// provide a track name, the workgroup is assigned to the current track.
	TrackName *string

	noSmithyDocumentSerde
}

type CreateWorkgroupOutput struct {

	// The created workgroup object.
	Workgroup *types.Workgroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWorkgroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateWorkgroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateWorkgroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWorkgroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWorkgroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWorkgroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWorkgroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWorkgroup",
	}
}
