// Code generated by smithy-go-codegen DO NOT EDIT.

package redshiftserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshiftserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the lakehouse configuration for a namespace. This operation allows you
// to manage Amazon Redshift federated permissions and Amazon Web Services IAM
// Identity Center trusted identity propagation.
func (c *Client) UpdateLakehouseConfiguration(ctx context.Context, params *UpdateLakehouseConfigurationInput, optFns ...func(*Options)) (*UpdateLakehouseConfigurationOutput, error) {
	if params == nil {
		params = &UpdateLakehouseConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateLakehouseConfiguration", params, optFns, c.addOperationUpdateLakehouseConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateLakehouseConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateLakehouseConfigurationInput struct {

	// The name of the namespace whose lakehouse configuration you want to modify.
	//
	// This member is required.
	NamespaceName *string

	// The name of the Glue Data Catalog that will be associated with the namespace
	// enabled with Amazon Redshift federated permissions.
	//
	// Pattern: ^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$
	CatalogName *string

	// A boolean value that, if true , validates the request without actually updating
	// the lakehouse configuration. Use this to check for errors before making changes.
	DryRun *bool

	// The Amazon Resource Name (ARN) of the IAM Identity Center application used for
	// enabling Amazon Web Services IAM Identity Center trusted identity propagation on
	// a namespace enabled with Amazon Redshift federated permissions.
	LakehouseIdcApplicationArn *string

	// Modifies the Amazon Web Services IAM Identity Center trusted identity
	// propagation on a namespace enabled with Amazon Redshift federated permissions.
	// Valid values are Associate or Disassociate .
	LakehouseIdcRegistration types.LakehouseIdcRegistration

	// Specifies whether to register or deregister the namespace with Amazon Redshift
	// federated permissions. Valid values are Register or Deregister .
	LakehouseRegistration types.LakehouseRegistration

	noSmithyDocumentSerde
}

type UpdateLakehouseConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the Glue Data Catalog associated with the
	// lakehouse configuration.
	CatalogArn *string

	// The Amazon Resource Name (ARN) of the IAM Identity Center application used for
	// enabling Amazon Web Services IAM Identity Center trusted identity propagation.
	LakehouseIdcApplicationArn *string

	// The current status of the lakehouse registration. Indicates whether the
	// namespace is successfully registered with Amazon Redshift federated permissions.
	LakehouseRegistrationStatus *string

	// The name of the namespace.
	NamespaceName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateLakehouseConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateLakehouseConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateLakehouseConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateLakehouseConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateLakehouseConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateLakehouseConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateLakehouseConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateLakehouseConfiguration",
	}
}
