// Code generated by smithy-go-codegen DO NOT EDIT.

package repostspace

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/repostspace/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Displays information about the AWS re:Post Private private re:Post.
func (c *Client) GetSpace(ctx context.Context, params *GetSpaceInput, optFns ...func(*Options)) (*GetSpaceOutput, error) {
	if params == nil {
		params = &GetSpaceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSpace", params, optFns, c.addOperationGetSpaceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSpaceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSpaceInput struct {

	// The ID of the private re:Post.
	//
	// This member is required.
	SpaceId *string

	noSmithyDocumentSerde
}

type GetSpaceOutput struct {

	// The ARN of the private re:Post.
	//
	// This member is required.
	Arn *string

	// The Identity Center identifier for the Application Instance.
	//
	// This member is required.
	ClientId *string

	// The configuration status of the private re:Post.
	//
	// This member is required.
	ConfigurationStatus types.ConfigurationStatus

	// The date when the private re:Post was created.
	//
	// This member is required.
	CreateDateTime *time.Time

	// The name of the private re:Post.
	//
	// This member is required.
	Name *string

	// The AWS generated subdomain of the private re:Post
	//
	// This member is required.
	RandomDomain *string

	// The unique ID of the private re:Post.
	//
	// This member is required.
	SpaceId *string

	// The creation or deletion status of the private re:Post.
	//
	// This member is required.
	Status *string

	// The storage limit of the private re:Post.
	//
	// This member is required.
	StorageLimit *int64

	// The pricing tier of the private re:Post.
	//
	// This member is required.
	Tier types.TierLevel

	// The custom subdomain that you use to access your private re:Post. All custom
	// subdomains must be approved by AWS before use.
	//
	// This member is required.
	VanityDomain *string

	// The approval status of the custom subdomain.
	//
	// This member is required.
	VanityDomainStatus types.VanityDomainStatus

	//
	ApplicationArn *string

	// The content size of the private re:Post.
	ContentSize *int64

	// The IAM role that grants permissions to the private re:Post to convert
	// unanswered questions into AWS support tickets.
	CustomerRoleArn *string

	// The date when the private re:Post was deleted.
	DeleteDateTime *time.Time

	// The description of the private re:Post.
	Description *string

	// The list of groups that are administrators of the private re:Post.
	//
	// Deprecated: This property has been depracted and will be replaced by the roles
	// property.
	GroupAdmins []string

	//
	IdentityStoreId *string

	// A map of accessor identifiers and their roles.
	Roles map[string][]types.Role

	//
	SupportedEmailDomains *types.SupportedEmailDomainsStatus

	// The list of users that are administrators of the private re:Post.
	//
	// Deprecated: This property has been depracted and will be replaced by the roles
	// property.
	UserAdmins []string

	// The number of users that have onboarded to the private re:Post.
	UserCount *int32

	// The custom AWS KMS key ARN that’s used for the AWS KMS encryption.
	UserKMSKey *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSpaceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSpace{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSpace{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSpace"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSpaceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSpace(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SpaceCreatedWaiterOptions are waiter options for SpaceCreatedWaiter
type SpaceCreatedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SpaceCreatedWaiter will use default minimum delay of 300 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SpaceCreatedWaiter will use default max delay of 7200 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSpaceInput, *GetSpaceOutput, error) (bool, error)
}

// SpaceCreatedWaiter defines the waiters for SpaceCreated
type SpaceCreatedWaiter struct {
	client GetSpaceAPIClient

	options SpaceCreatedWaiterOptions
}

// NewSpaceCreatedWaiter constructs a SpaceCreatedWaiter.
func NewSpaceCreatedWaiter(client GetSpaceAPIClient, optFns ...func(*SpaceCreatedWaiterOptions)) *SpaceCreatedWaiter {
	options := SpaceCreatedWaiterOptions{}
	options.MinDelay = 300 * time.Second
	options.MaxDelay = 7200 * time.Second
	options.Retryable = spaceCreatedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SpaceCreatedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SpaceCreated waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SpaceCreatedWaiter) Wait(ctx context.Context, params *GetSpaceInput, maxWaitDur time.Duration, optFns ...func(*SpaceCreatedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SpaceCreated waiter and returns the
// output of the successful operation. The maxWaitDur is the maximum wait duration
// the waiter will wait. The maxWaitDur is required and must be greater than zero.
func (w *SpaceCreatedWaiter) WaitForOutput(ctx context.Context, params *GetSpaceInput, maxWaitDur time.Duration, optFns ...func(*SpaceCreatedWaiterOptions)) (*GetSpaceOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 7200 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSpace(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SpaceCreated waiter")
}

func spaceCreatedStateRetryable(ctx context.Context, input *GetSpaceInput, output *GetSpaceOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "CREATED"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CREATE_FAILED"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "CREATING"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// SpaceDeletedWaiterOptions are waiter options for SpaceDeletedWaiter
type SpaceDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// SpaceDeletedWaiter will use default minimum delay of 300 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, SpaceDeletedWaiter will use default max delay of 7200 seconds. Note
	// that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetSpaceInput, *GetSpaceOutput, error) (bool, error)
}

// SpaceDeletedWaiter defines the waiters for SpaceDeleted
type SpaceDeletedWaiter struct {
	client GetSpaceAPIClient

	options SpaceDeletedWaiterOptions
}

// NewSpaceDeletedWaiter constructs a SpaceDeletedWaiter.
func NewSpaceDeletedWaiter(client GetSpaceAPIClient, optFns ...func(*SpaceDeletedWaiterOptions)) *SpaceDeletedWaiter {
	options := SpaceDeletedWaiterOptions{}
	options.MinDelay = 300 * time.Second
	options.MaxDelay = 7200 * time.Second
	options.Retryable = spaceDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &SpaceDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for SpaceDeleted waiter. The maxWaitDur is the
// maximum wait duration the waiter will wait. The maxWaitDur is required and must
// be greater than zero.
func (w *SpaceDeletedWaiter) Wait(ctx context.Context, params *GetSpaceInput, maxWaitDur time.Duration, optFns ...func(*SpaceDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for SpaceDeleted waiter and returns the
// output of the successful operation. The maxWaitDur is the maximum wait duration
// the waiter will wait. The maxWaitDur is required and must be greater than zero.
func (w *SpaceDeletedWaiter) WaitForOutput(ctx context.Context, params *GetSpaceInput, maxWaitDur time.Duration, optFns ...func(*SpaceDeletedWaiterOptions)) (*GetSpaceOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 7200 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetSpace(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for SpaceDeleted waiter")
}

func spaceDeletedStateRetryable(ctx context.Context, input *GetSpaceInput, output *GetSpaceOutput, err error) (bool, error) {

	if err != nil {
		var errorType *types.ResourceNotFoundException
		if errors.As(err, &errorType) {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "DELETED"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "DELETE_FAILED"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "DELETING"
		var pathValue string
		if v1 != nil {
			pathValue = string(*v1)
		}
		if pathValue == expectedValue {
			return true, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetSpaceAPIClient is a client that implements the GetSpace operation.
type GetSpaceAPIClient interface {
	GetSpace(context.Context, *GetSpaceInput, ...func(*Options)) (*GetSpaceOutput, error)
}

var _ GetSpaceAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetSpace(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSpace",
	}
}
