// Code generated by smithy-go-codegen DO NOT EDIT.

package resourceexplorer2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourceexplorer2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Resource Explorer indexes across the specified Amazon Web Services
// Regions. This operation returns information about indexes including their ARNs,
// types, and Regions.
func (c *Client) ListServiceIndexes(ctx context.Context, params *ListServiceIndexesInput, optFns ...func(*Options)) (*ListServiceIndexesOutput, error) {
	if params == nil {
		params = &ListServiceIndexesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceIndexes", params, optFns, c.addOperationListServiceIndexesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceIndexesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceIndexesInput struct {

	// The maximum number of index results to return in a single response. Valid
	// values are between 1 and 100 .
	MaxResults *int32

	// The pagination token from a previous ListServiceIndexes response. Use this
	// token to retrieve the next set of results.
	NextToken *string

	// A list of Amazon Web Services Regions to include in the search for indexes. If
	// not specified, indexes from all Regions are returned.
	Regions []string

	noSmithyDocumentSerde
}

type ListServiceIndexesOutput struct {

	// A list of Index objects that describe the Resource Explorer indexes found in
	// the specified Regions.
	Indexes []types.Index

	// The pagination token to use in a subsequent ListServiceIndexes request to
	// retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceIndexesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceIndexes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceIndexes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceIndexes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceIndexes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServiceIndexesPaginatorOptions is the paginator options for
// ListServiceIndexes
type ListServiceIndexesPaginatorOptions struct {
	// The maximum number of index results to return in a single response. Valid
	// values are between 1 and 100 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceIndexesPaginator is a paginator for ListServiceIndexes
type ListServiceIndexesPaginator struct {
	options   ListServiceIndexesPaginatorOptions
	client    ListServiceIndexesAPIClient
	params    *ListServiceIndexesInput
	nextToken *string
	firstPage bool
}

// NewListServiceIndexesPaginator returns a new ListServiceIndexesPaginator
func NewListServiceIndexesPaginator(client ListServiceIndexesAPIClient, params *ListServiceIndexesInput, optFns ...func(*ListServiceIndexesPaginatorOptions)) *ListServiceIndexesPaginator {
	if params == nil {
		params = &ListServiceIndexesInput{}
	}

	options := ListServiceIndexesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceIndexesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceIndexesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceIndexes page.
func (p *ListServiceIndexesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceIndexesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceIndexes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceIndexesAPIClient is a client that implements the ListServiceIndexes
// operation.
type ListServiceIndexesAPIClient interface {
	ListServiceIndexes(context.Context, *ListServiceIndexesInput, ...func(*Options)) (*ListServiceIndexesOutput, error)
}

var _ ListServiceIndexesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceIndexes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceIndexes",
	}
}
