// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a DNS view within a Route 53 Global Resolver. A DNS view models end
// users, user groups, networks, and devices, and serves as a parent resource that
// holds configurations controlling access, authorization, DNS firewall rules, and
// forwarding rules.
func (c *Client) CreateDNSView(ctx context.Context, params *CreateDNSViewInput, optFns ...func(*Options)) (*CreateDNSViewOutput, error) {
	if params == nil {
		params = &CreateDNSViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDNSView", params, optFns, c.addOperationCreateDNSViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDNSViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDNSViewInput struct {

	// The ID of the Route 53 Global Resolver to associate with this DNS view.
	//
	// This member is required.
	GlobalResolverId *string

	// A descriptive name for the DNS view.
	//
	// This member is required.
	Name *string

	// A unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// An optional description for the DNS view.
	Description *string

	// Whether to enable DNSSEC validation for DNS queries in this DNS view. When
	// enabled, the resolver verifies the authenticity and integrity of DNS responses
	// from public name servers for DNSSEC-signed domains.
	DnssecValidation types.DnsSecValidationType

	// Whether to enable EDNS Client Subnet injection for DNS queries in this DNS
	// view. When enabled, client subnet information is forwarded to provide more
	// accurate geographic-based DNS responses.
	EdnsClientSubnet types.EdnsClientSubnetType

	// Determines the behavior when Route 53 Global Resolver cannot apply DNS firewall
	// rules due to service impairment. When enabled, DNS queries are allowed through;
	// when disabled, queries are blocked.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// Tags to associate with the DNS view.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateDNSViewOutput struct {

	// The Amazon Resource Name (ARN) of the DNS view.
	//
	// This member is required.
	Arn *string

	// The date and time when the DNS view was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Whether DNSSEC validation is enabled for DNS queries in this DNS view.
	//
	// This member is required.
	DnssecValidation types.DnsSecValidationType

	// Whether EDNS Client Subnet injection is enabled for DNS queries in this DNS
	// view.
	//
	// This member is required.
	EdnsClientSubnet types.EdnsClientSubnetType

	// The behavior when Route 53 Global Resolver cannot apply DNS firewall rules due
	// to service impairment.
	//
	// This member is required.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// The ID of the Route 53 Global Resolver instance the DNS view is created for.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier for the DNS view.
	//
	// This member is required.
	Id *string

	// The descriptive name of the DNS view.
	//
	// This member is required.
	Name *string

	// The operational status of the DNS view.
	//
	// This member is required.
	Status types.ProfileResourceStatus

	// The date and time when the DNS view was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// The description of the DNS view.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDNSViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDNSView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateDNSViewMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDNSViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDNSView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateDNSView struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateDNSView) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateDNSView) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateDNSViewInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateDNSViewInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateDNSViewMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateDNSView{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateDNSView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDNSView",
	}
}
