// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Disables a DNS view, preventing it from serving DNS queries.
func (c *Client) DisableDNSView(ctx context.Context, params *DisableDNSViewInput, optFns ...func(*Options)) (*DisableDNSViewOutput, error) {
	if params == nil {
		params = &DisableDNSViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisableDNSView", params, optFns, c.addOperationDisableDNSViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisableDNSViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisableDNSViewInput struct {

	// The unique identifier of the DNS view to disable.
	//
	// This member is required.
	DnsViewId *string

	noSmithyDocumentSerde
}

type DisableDNSViewOutput struct {

	// The Amazon Resource Name (ARN) of the disabled DNS view.
	//
	// This member is required.
	Arn *string

	// The date and time when the DNS view was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Whether DNSSEC validation is enabled for the disabled DNS view.
	//
	// This member is required.
	DnssecValidation types.DnsSecValidationType

	// Whether EDNS Client Subnet injection is enabled for the disabled DNS view.
	//
	// This member is required.
	EdnsClientSubnet types.EdnsClientSubnetType

	// The firewall rules fail-open behavior configured for the disabled DNS view.
	//
	// This member is required.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// The ID of the Route 53 Global Resolver that the disabled DNS view is associated
	// with.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the disabled DNS view.
	//
	// This member is required.
	Id *string

	// The name of the disabled DNS view.
	//
	// This member is required.
	Name *string

	// The current status of the disabled DNS view.
	//
	// This member is required.
	Status types.ProfileResourceStatus

	// The date and time when the DNS view was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// The description of the disabled DNS view.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisableDNSViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDisableDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDisableDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisableDNSView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDisableDNSViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisableDNSView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDisableDNSView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisableDNSView",
	}
}
