// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a firewall domain list.
func (c *Client) GetFirewallDomainList(ctx context.Context, params *GetFirewallDomainListInput, optFns ...func(*Options)) (*GetFirewallDomainListOutput, error) {
	if params == nil {
		params = &GetFirewallDomainListInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFirewallDomainList", params, optFns, c.addOperationGetFirewallDomainListMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFirewallDomainListOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFirewallDomainListInput struct {

	// ID of the domain list.
	//
	// This member is required.
	FirewallDomainListId *string

	noSmithyDocumentSerde
}

type GetFirewallDomainListOutput struct {

	// Amazon Resource Name (ARN) of the domain list.
	//
	// This member is required.
	Arn *string

	// The time and date the domain list was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Number of domains in the domain list.
	//
	// This member is required.
	DomainCount *int32

	// ID of the Global Resolver that the domain list is associated to.
	//
	// This member is required.
	GlobalResolverId *string

	// ID of the domain list.
	//
	// This member is required.
	Id *string

	// Name of the domain list.
	//
	// This member is required.
	Name *string

	// Operational status of the domain list.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time the domain list was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	ClientToken *string

	// The description of the domain list.
	Description *string

	// Additional information about the status of the domain list.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFirewallDomainListMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFirewallDomainList{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFirewallDomainList{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFirewallDomainList"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFirewallDomainListValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFirewallDomainList(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFirewallDomainList(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFirewallDomainList",
	}
}
