// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all DNS firewall rules for a DNS view with pagination support.
func (c *Client) ListFirewallRules(ctx context.Context, params *ListFirewallRulesInput, optFns ...func(*Options)) (*ListFirewallRulesOutput, error) {
	if params == nil {
		params = &ListFirewallRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFirewallRules", params, optFns, c.addOperationListFirewallRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFirewallRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFirewallRulesInput struct {

	// ID of the DNS view.
	//
	// This member is required.
	DnsViewId *string

	// Values to filter the results.
	Filters map[string][]string

	// The maximum number of results to retrieve in a single call.
	MaxResults *int32

	// A pagination token used for large sets of results that can't be returned in a
	// single response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListFirewallRulesOutput struct {

	// List of the firewall rules and information about them.
	//
	// This member is required.
	FirewallRules []types.FirewallRulesItem

	// A pagination token used for large sets of results that can't be returned in a
	// single response. Provide this token in the next call to get the results not
	// returned in this call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFirewallRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListFirewallRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListFirewallRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFirewallRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFirewallRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFirewallRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListFirewallRulesPaginatorOptions is the paginator options for ListFirewallRules
type ListFirewallRulesPaginatorOptions struct {
	// The maximum number of results to retrieve in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFirewallRulesPaginator is a paginator for ListFirewallRules
type ListFirewallRulesPaginator struct {
	options   ListFirewallRulesPaginatorOptions
	client    ListFirewallRulesAPIClient
	params    *ListFirewallRulesInput
	nextToken *string
	firstPage bool
}

// NewListFirewallRulesPaginator returns a new ListFirewallRulesPaginator
func NewListFirewallRulesPaginator(client ListFirewallRulesAPIClient, params *ListFirewallRulesInput, optFns ...func(*ListFirewallRulesPaginatorOptions)) *ListFirewallRulesPaginator {
	if params == nil {
		params = &ListFirewallRulesInput{}
	}

	options := ListFirewallRulesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFirewallRulesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFirewallRulesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFirewallRules page.
func (p *ListFirewallRulesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFirewallRulesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFirewallRules(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFirewallRulesAPIClient is a client that implements the ListFirewallRules
// operation.
type ListFirewallRulesAPIClient interface {
	ListFirewallRules(context.Context, *ListFirewallRulesInput, ...func(*Options)) (*ListFirewallRulesOutput, error)
}

var _ ListFirewallRulesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFirewallRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFirewallRules",
	}
}
